/*
 * Decompiled with CFR 0.152.
 */
package jadean.dean.java.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtilities {
    public static boolean innerClassInDir(String dir, String file) {
        File fDir = new File(dir);
        File[] files = fDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isFile() && f.getName().endsWith(file) && !f.getName().equals(file)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static List<File> filesInDirs(List<String> dirs) {
        ArrayList<File> ret = new ArrayList<File>();
        for (String dir : dirs) {
            String[] files;
            File f = new File(dir);
            String[] stringArray = files = f.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                File _f = new File(f.getAbsolutePath(), s);
                if (!_f.isDirectory()) {
                    ret.add(_f);
                }
                ++n2;
            }
        }
        return ret;
    }

    public static List<File> allFilesInDirs(List<String> dirs) {
        ArrayList<File> ret = new ArrayList<File>();
        for (String dir : dirs) {
            String[] files;
            File f = new File(dir);
            String[] stringArray = files = f.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File _f = new File(f.getAbsolutePath(), file);
                if (!_f.isDirectory()) {
                    ret.add(_f);
                } else {
                    ret.addAll(FileUtilities.filesInDir(_f.getAbsolutePath()));
                }
                ++n2;
            }
        }
        return ret;
    }

    private static List<File> filesInDir(String dir) {
        String[] files;
        ArrayList<File> ret = new ArrayList<File>();
        File f = new File(dir);
        String[] stringArray = files = f.list();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            File _f = new File(f.getAbsolutePath(), s);
            if (!_f.isDirectory()) {
                ret.add(_f);
            } else {
                ret.addAll(FileUtilities.filesInDir(_f.getAbsolutePath()));
            }
            ++n2;
        }
        return ret;
    }

    public static String findInDirs(List<String> dirs, String fileName) {
        for (String dir : dirs) {
            File f = new File(dir, fileName);
            if (!f.exists()) continue;
            return f.getAbsolutePath();
        }
        return null;
    }

    public static String getClassName(File f, List<String> dirs) {
        for (String dir : dirs) {
            if (!f.getAbsolutePath().startsWith(dir)) continue;
            String absolutePath = f.getAbsolutePath();
            String relativeFileName = absolutePath.replace(String.valueOf(dir) + File.separatorChar, "");
            String relativeSourceFileName = relativeFileName.replace(".java", "");
            String relativeClassName = relativeSourceFileName.replace(File.separatorChar, '.');
            return relativeClassName;
        }
        return null;
    }

    public static void renameTo(String oldFileName, String newFileName) throws IOException {
        File oldFile = new File(oldFileName);
        File newFile = new File(newFileName);
        if (newFile.exists() && !newFile.delete()) {
            throw new IOException();
        }
        if (!oldFile.renameTo(newFile)) {
            throw new IOException();
        }
    }

    public static void copyfile(String sourceFileName, String destinationFileName) throws IOException {
        int length;
        File sourceFile = new File(sourceFileName);
        File destinationFile = new File(destinationFileName);
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destinationFile);
        byte[] buffer = new byte[1024];
        while ((length = ((InputStream)in).read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void deleteFile(String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.exists()) {
            throw new IOException("No such file or directory: " + fileName);
        }
        if (!f.canWrite()) {
            throw new IOException("Write access denied: " + fileName);
        }
        if (f.isDirectory() && f.list().length > 0) {
            throw new IOException("Directory is not empty: " + fileName);
        }
        if (!f.delete()) {
            throw new IOException("Failed to delete file: " + fileName);
        }
    }

    public static String inputStreamToString(InputStream input) throws IOException {
        int length;
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[1024];
        while ((length = input.read(buffer)) > 0) {
            sb.append(new String(buffer), 0, length);
        }
        return sb.toString();
    }
}

