/*
 * Decompiled with CFR 0.152.
 */
package jadean.dean.java.utilities;

import jadean.dean.java.utilities.Selector;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUtilities {
    public static <T> ArrayList<T> arrayToList(T[] in) {
        ArrayList<T> ret = new ArrayList<T>();
        T[] TArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            ret.add(t);
            ++n2;
        }
        return ret;
    }

    public static <T> boolean inCollection(Collection<T> collection, T item) {
        for (T i : collection) {
            if (!i.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean inArray(T[] array, T item) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T i = TArray[n2];
            if (i.equals(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean containsItem(T[] array, Selector<T> selector) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T i = TArray[n2];
            if (selector.accept(i)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean containsItem(Collection<T> collection, Selector<T> selector) {
        for (T i : collection) {
            if (!selector.accept(i)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean arraysEquals(T[] array1, T[] array2) {
        ArrayList<T> list1 = JavaUtilities.arrayToList(array1);
        ArrayList<T> list2 = JavaUtilities.arrayToList(array2);
        return JavaUtilities.collectionsEquals(list1, list2);
    }

    public static <T> boolean collectionsEquals(Collection<T> col1, Collection<T> col2) {
        return col1.containsAll(col2) && col2.containsAll(col1);
    }

    public static boolean isAtomicClassName(String className) {
        return className.indexOf(46) == -1;
    }

    public static String buildFullyQualifiedClassName(String classPackage, String className) {
        if ("".equals(classPackage)) {
            return className;
        }
        return String.valueOf(classPackage) + "." + className;
    }

    public static String extractPackage(String fQClassName) {
        int i = fQClassName.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return fQClassName.substring(0, i);
    }

    public static String extractClassName(String fQClassName) {
        int i = fQClassName.lastIndexOf(46);
        if (i == -1) {
            return fQClassName;
        }
        return fQClassName.substring(i + 1);
    }
}

