/*
 * Decompiled with CFR 0.152.
 */
package jadean.dean.java.utilities;

import jadean.dean.Resource;
import jadean.dean.java.JavaProject;
import jadean.dean.java.JavaResource;
import jadean.dean.java.utilities.JavaUtilities;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtilities {
    public static Collection<Resource> deDuplicateResources(Collection<Resource> resources) {
        HashSet<Resource> deDuplicatedResources = new HashSet<Resource>(resources);
        for (Resource _resource1 : resources) {
            JavaResource resource1 = (JavaResource)_resource1;
            for (Resource _resource2 : resources) {
                JavaResource resource2 = (JavaResource)_resource2;
                String shortClassName2 = JavaUtilities.extractClassName(resource2.getName());
                if ((!shortClassName2.equals(resource1.getName()) || !resource1.getContext().getClassImportedClasses().contains(resource2.getName())) && (!resource1.getName().startsWith(resource2.getName().replace(".*", "")) || resource1.getName().equals(resource2.getName()))) continue;
                deDuplicatedResources.remove(resource1);
            }
        }
        return deDuplicatedResources;
    }

    public static Collection<Resource> removeResourcesFromPackage(Collection<Resource> resources) {
        HashSet<Resource> deDuplicatedResources = new HashSet<Resource>(resources);
        for (Resource resource1 : resources) {
            for (Resource resource2 : resources) {
                if (!resource2.getName().endsWith(".*") || !resource1.getName().startsWith(resource2.getName().replace(".*", "")) || resource1.getName().equals(resource2.getName())) continue;
                deDuplicatedResources.remove(resource1);
            }
        }
        return deDuplicatedResources;
    }

    public static Collection<Resource> normalizeResources(Collection<Resource> resources, JavaProject project) {
        HashSet<Resource> normalizedResources = new HashSet<Resource>(resources);
        for (Resource resource : resources) {
            JavaResource javaResource = (JavaResource)resource;
            for (String importedPackage : javaResource.getContext().getClassImportedPackages()) {
                String fullyQualifiedClassName = JavaUtilities.buildFullyQualifiedClassName(importedPackage, javaResource.getName());
                if (project.isContainedInReferencedPackages(fullyQualifiedClassName)) {
                    javaResource.setName(fullyQualifiedClassName);
                }
                if (!project.isContainedInProjectFolders(fullyQualifiedClassName)) continue;
                javaResource.setName(fullyQualifiedClassName);
            }
        }
        return normalizedResources;
    }
}

