/*
 * Decompiled with CFR 0.152.
 */
package jadean.test;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

@RunWith(value=AllTestsRunner.class)
public class AllTests {
    private static final File CLASSES_DIR = AllTests.findClassesDir();

    private AllTests() {
    }

    private static File findClassesDir() {
        try {
            String path = AllTests.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            return new File(URLDecoder.decode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllTestsRunner
    extends Suite {
        public AllTestsRunner(Class<?> clazz) throws InitializationError {
            super(clazz, (Class[])AllTestsRunner.findClasses());
        }

        public void run(RunNotifier notifier) {
            AllTestsRunner.initializeBeforeTests();
            notifier.addListener(new RunListener(){

                public void testStarted(Description description) {
                }

                public void testFinished(Description description) {
                }
            });
            super.run(notifier);
        }

        private static Class<?>[] findClasses() {
            ArrayList<File> classFiles = new ArrayList<File>();
            AllTestsRunner.findClasses(classFiles, CLASSES_DIR);
            List<Class<?>> classes = AllTestsRunner.convertToClasses(classFiles, CLASSES_DIR);
            return classes.toArray(new Class[classes.size()]);
        }

        private static void initializeBeforeTests() {
        }

        private static List<Class<?>> convertToClasses(List<File> classFiles, File classesDir) {
            ArrayList classes = new ArrayList();
            for (File file : classFiles) {
                Class<?> c;
                if (!file.getName().endsWith("Test.class")) continue;
                String name = file.getPath().substring(classesDir.getPath().length() + 1).replace('/', '.').replace('\\', '.');
                name = name.substring(0, name.length() - 6);
                try {
                    c = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    throw new AssertionError((Object)e);
                }
                if (Modifier.isAbstract(c.getModifiers())) continue;
                classes.add(c);
            }
            Collections.sort(classes, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> c1, Class<?> c2) {
                    return c1.getName().compareTo(c2.getName());
                }
            });
            return classes;
        }

        private static void findClasses(List<File> classFiles, File dir) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    AllTestsRunner.findClasses(classFiles, file);
                } else if (file.getName().toLowerCase().endsWith(".class")) {
                    classFiles.add(file);
                }
                ++n2;
            }
        }
    }
}

