/*
 * Decompiled with CFR 0.152.
 */
package jadean.test.dean.java.resourceparser.jarparser;

import jadean.dean.java.JavaPackage;
import jadean.dean.java.resourceparser.jarparser.DefaultJarEntryFilter;
import jadean.dean.java.resourceparser.jarparser.DefaultJarEntryFormatter;
import jadean.dean.java.resourceparser.jarparser.JarEntryFilter;
import jadean.dean.java.resourceparser.jarparser.JarEntryFormatter;
import jadean.dean.java.resourceparser.jarparser.JarResourceUtilities;
import jadean.dean.java.utilities.FileUtilities;
import jadean.dean.java.utilities.JavaUtilities;
import jadean.dean.java.utilities.Selector;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JarResourceUtilitiesTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        try {
            FileUtilities.deleteFile("test/resources/jarutilities/delete.tmp.jar");
            FileUtilities.deleteFile("test/resources/jarutilities/emptyfolders.tmp.jar");
        }
        catch (Exception exception) {}
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        try {
            FileUtilities.deleteFile("test/resources/jarutilities/delete.tmp.jar");
            FileUtilities.deleteFile("test/resources/jarutilities/emptyfolders.tmp.jar");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testRemoveEntries() {
        try {
            String jarFileName = "test/resources/jarutilities/delete.tmp.jar";
            FileUtilities.copyfile("test/resources/jarutilities/delete.jar", jarFileName);
            ArrayList<String> entriesToDelete = new ArrayList<String>();
            entriesToDelete.add("resources.Class");
            entriesToDelete.add("resources.a.Class");
            entriesToDelete.add("resources.c.Class");
            JarResourceUtilities.removeEntries(jarFileName, entriesToDelete);
            List<String> files = JarResourceUtilities.listFiles(jarFileName, (JarEntryFilter)new DefaultJarEntryFilter(), (JarEntryFormatter)new DefaultJarEntryFormatter());
            Assert.assertFalse((boolean)JavaUtilities.inCollection(files, "resources.Class"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(files, "resources.a.Class"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(files, "resources.c.Class"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(files, "resources.c.Class$Inner"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(files, "resources.c.Class$Inner$1"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(files, "resources.c.Class$Inner$2"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(files, "resources.c.Class$Inner$2$Listener"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(files, "resources.b.Class"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(files, "resources.a.b.Class"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(files, "resources.a.b.c.Class"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(files, "resources.c.Main"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(files, "resources.c.Main$Remain"));
            FileUtilities.deleteFile(jarFileName);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetInputStreamForEntry() {
        try {
            String jarFileName = "test/resources/jarutilities/inputstream.jar";
            InputStream isa = JarResourceUtilities.getInputStreamForEntry(jarFileName, "resources.a.Class");
            Assert.assertNotNull((Object)isa);
            Assert.assertEquals((Object)"aaa", (Object)FileUtilities.inputStreamToString(isa));
            isa.close();
            InputStream isb = JarResourceUtilities.getInputStreamForEntry(jarFileName, "resources.b.Class");
            Assert.assertNotNull((Object)isb);
            Assert.assertEquals((Object)"bbbbb", (Object)FileUtilities.inputStreamToString(isb));
            isb.close();
            InputStream isx = JarResourceUtilities.getInputStreamForEntry(jarFileName, "rexourxex.x.Class");
            Assert.assertNull((Object)isx);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testListFilesString() {
        try {
            String jarFileName = "test/resources/jarutilities/list.jar";
            JarEntryFilter emptyFilter = new JarEntryFilter(){

                public boolean accept(JarEntry je) {
                    return true;
                }
            };
            JarEntryFormatter emptyFormatter = new JarEntryFormatter(){

                public String format(JarEntry je) {
                    return je.getName();
                }
            };
            JarEntryFilter standardFilter = new JarEntryFilter(){

                public boolean accept(JarEntry je) {
                    return !je.isDirectory() && je.getName().endsWith(".class");
                }
            };
            JarEntryFormatter standardFormatter = new JarEntryFormatter(){

                public String format(JarEntry je) {
                    return je.getName().replace(".class", "").replace('/', '.');
                }
            };
            List<String> emptyEResult = Arrays.asList("META-INF/", "META-INF/MANIFEST.MF", "resources/", "resources/a/", "resources/a/b/", "resources/a/b/c/", "resources/a/b/c/Class.class", "resources/a/b/Class.class", "resources/a/Class.class", "resources/b/", "resources/b/Class.class", "resources/b/Class$Inner.class", "resources/Class.class");
            List<String> standardEResult = Arrays.asList("resources.a.b.c.Class", "resources.a.b.Class", "resources.a.Class", "resources.b.Class", "resources.b.Class$Inner", "resources.Class");
            List<String> emptyAResult = JarResourceUtilities.listFiles(jarFileName, emptyFilter, emptyFormatter);
            List<String> standardAResult = JarResourceUtilities.listFiles(jarFileName, standardFilter, standardFormatter);
            Assert.assertTrue((boolean)JavaUtilities.collectionsEquals(emptyEResult, emptyAResult));
            Assert.assertTrue((boolean)JavaUtilities.collectionsEquals(standardEResult, standardAResult));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testListFilesJavaPackage() {
        try {
            String jarFileName1 = "test/resources/jarutilities/list1.jar";
            String jarFileName2 = "test/resources/jarutilities/list2.jar";
            JavaPackage package1 = new JavaPackage(jarFileName1);
            JavaPackage package2 = new JavaPackage(jarFileName2);
            List<String> ePackage1Content = Arrays.asList("test1/Class.class", "test1/a/Class.class", "test1/a/b/Class.class", "test1/a/", "test1/a/b/", "test1/", "META-INF/", "META-INF/MANIFEST.MF");
            List<String> ePackage2Content = Arrays.asList("test2/Class.class", "test2/a/Class.class", "test2/a/b/Class.class", "test2/a/", "test2/a/b/", "test2/", "META-INF/", "META-INF/MANIFEST.MF");
            List<JavaPackage> packages = Arrays.asList(package1, package2);
            JarEntryFilter emptyFilter = new JarEntryFilter(){

                public boolean accept(JarEntry je) {
                    return true;
                }
            };
            JarEntryFormatter emptyFormatter = new JarEntryFormatter(){

                public String format(JarEntry je) {
                    return je.getName();
                }
            };
            HashMap<JavaPackage, List<String>> eResult = new HashMap<JavaPackage, List<String>>();
            eResult.put(package1, ePackage1Content);
            eResult.put(package2, ePackage2Content);
            HashMap<JavaPackage, List<String>> aResult = JarResourceUtilities.listFiles(packages, emptyFilter, emptyFormatter);
            Assert.assertTrue((aResult.keySet().size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)aResult.keySet().contains(package1));
            Assert.assertTrue((boolean)aResult.keySet().contains(package2));
            List<String> aPackage1Content = aResult.get(package1);
            List<String> aPackage2Content = aResult.get(package2);
            Assert.assertTrue((boolean)JavaUtilities.collectionsEquals(ePackage1Content, aPackage1Content));
            Assert.assertTrue((boolean)JavaUtilities.collectionsEquals(ePackage2Content, aPackage2Content));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIsEntryInList() {
        try {
            String jarFileName = "test/resources/jarutilities/list.jar";
            String[] eDelete = new String[]{"resources.c.Class"};
            ArrayList<String> entriesToDelete = JavaUtilities.arrayToList(eDelete);
            JarFile jarFile = new JarFile(jarFileName);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry entry = enumeration.nextElement();
                if (entry.getName().equals("resources/c/Class.class") || entry.getName().equals("resources/c/Class$Inner.class") || entry.getName().equals("resources/c/Class$Inner$1.class") || entry.getName().equals("resources/c/Class$Inner$2.class") || entry.getName().equals("resources/c/Class$Inner$2$Listener.class")) {
                    Assert.assertTrue((boolean)JarResourceUtilities.isEntryInList(entry, entriesToDelete));
                    continue;
                }
                Assert.assertFalse((boolean)JarResourceUtilities.isEntryInList(entry, entriesToDelete));
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCopyUndeletedEntries() {
        try {
            String sourceJarFileName = "test/resources/jarutilities/delete.jar";
            String destinationJarFileName = "test/resources/jarutilities/delete.tmp.jar";
            String[] eDelete = new String[]{"resources.c.Class", "resources.a.b.Class", "resources.c.Test"};
            ArrayList<String> entriesToDelete = JavaUtilities.arrayToList(eDelete);
            JarEntryFilter emptyFilter = new JarEntryFilter(){

                public boolean accept(JarEntry je) {
                    return true;
                }
            };
            JarEntryFormatter emptyFormatter = new JarEntryFormatter(){

                public String format(JarEntry je) {
                    return je.getName();
                }
            };
            JarResourceUtilities.copyUndeletedEntries(entriesToDelete, sourceJarFileName, destinationJarFileName);
            List<String> eResult = Arrays.asList("META-INF/", "META-INF/MANIFEST.MF", "resources/", "resources/a/", "resources/a/b/", "resources/a/b/c/", "resources/a/b/c/Class.class", "resources/a/Class.class", "resources/b/", "resources/b/a/", "resources/b/a/Class.class", "resources/b/Class.class", "resources/c/", "resources/c/Main.class", "resources/c/Main$Remain.class", "resources/c/Main$Remain$1.class", "resources/Class.class");
            List<String> aResult = JarResourceUtilities.listFiles(destinationJarFileName, emptyFilter, emptyFormatter);
            Assert.assertTrue((boolean)JavaUtilities.collectionsEquals(eResult, aResult));
            FileUtilities.deleteFile(destinationJarFileName);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetClassPathPackages() {
        String yesJarFileName = "test/resources/jarutilities/classpath-yes.jar";
        String noJarFileName = "test/resources/jarutilities/classpath-no.jar";
        final List<String> yesClassPathLibs = Arrays.asList("test/resources/jarutilities/abc.jar", "test/resources/jarutilities/lib/def.jar");
        List<String> noClassPathLibs = Arrays.asList(new String[0]);
        List<String> noResult = JarResourceUtilities.getClassPathPackages(noJarFileName);
        List<String> yesResult = JarResourceUtilities.getClassPathPackages(yesJarFileName);
        Selector<String> selector = new Selector<String>(){

            @Override
            public boolean accept(String item) {
                for (String lib : yesClassPathLibs) {
                    if (!item.endsWith(lib.replace('/', File.separatorChar))) continue;
                    return true;
                }
                return false;
            }
        };
        Assert.assertTrue((boolean)JavaUtilities.collectionsEquals(noClassPathLibs, noResult));
        Assert.assertTrue((boolean)JavaUtilities.containsItem(yesResult, selector));
    }

    @Test
    public void testHasClassPathPackages() {
        try {
            String yesJarFileName = "test/resources/jarutilities/classpath-yes.jar";
            String noJarFileName = "test/resources/jarutilities/classpath-no.jar";
            Assert.assertTrue((boolean)JarResourceUtilities.hasClassPathPackages(yesJarFileName));
            Assert.assertFalse((boolean)JarResourceUtilities.hasClassPathPackages(noJarFileName));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeleteEmptyFolders() {
        try {
            String jarFileName = "test/resources/jarutilities/emptyfolders.tmp.jar";
            FileUtilities.copyfile("test/resources/jarutilities/emptyfolders.jar", jarFileName);
            JarEntryFilter emptyFilter = new JarEntryFilter(){

                public boolean accept(JarEntry je) {
                    return true;
                }
            };
            JarEntryFormatter emptyFormatter = new JarEntryFormatter(){

                public String format(JarEntry je) {
                    return je.getName();
                }
            };
            JarResourceUtilities.deleteEmptyFolders(jarFileName);
            List<String> aFiles = JarResourceUtilities.listFiles(jarFileName, emptyFilter, emptyFormatter);
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "META-INF/"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "META-INF/MANIFEST.MF"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/a/"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/a/bb/"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/a/bb/Class.class"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/a/Class.class"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/b/"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/b/a/"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/b/a/Class.class"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/c/"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/c/Test.class"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/d/"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/d/Class.class"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/e/"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/e/a/"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/e/a/Class.class"));
            Assert.assertTrue((boolean)JavaUtilities.inCollection(aFiles, "resources/e/Class.class"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "resources/a/aa/"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "resources/a/b/c/"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "resources/a/b/"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "resources/d/a/"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "resources/f/a/a/a/a/"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "resources/f/a/a/a/"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "resources/f/a/a/"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "resources/f/a/"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "resources/f/"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "resources/g/"));
            Assert.assertFalse((boolean)JavaUtilities.inCollection(aFiles, "sk/"));
            FileUtilities.deleteFile(jarFileName);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

