/*
 * Decompiled with CFR 0.152.
 */
package jadean.test.dean.java.utilities;

import jadean.dean.java.utilities.JavaUtilities;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JavaUtilitiesTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testArrayToList() {
        String[] inputArray = new String[]{"1", "2", "3", "4"};
        ArrayList<String> expectedResult = new ArrayList<String>();
        expectedResult.add("1");
        expectedResult.add("2");
        expectedResult.add("3");
        expectedResult.add("4");
        ArrayList<String> realResult = JavaUtilities.arrayToList(inputArray);
        Assert.assertTrue((boolean)expectedResult.containsAll(realResult));
        Assert.assertTrue((boolean)realResult.containsAll(expectedResult));
    }

    @Test
    public void testIsAtomicClassName() {
        Assert.assertTrue((boolean)JavaUtilities.isAtomicClassName("abc"));
        Assert.assertTrue((boolean)JavaUtilities.isAtomicClassName("Abc"));
        Assert.assertTrue((boolean)JavaUtilities.isAtomicClassName("ABC"));
        Assert.assertTrue((boolean)JavaUtilities.isAtomicClassName("aBc"));
        Assert.assertFalse((boolean)JavaUtilities.isAtomicClassName("a.aBc"));
        Assert.assertFalse((boolean)JavaUtilities.isAtomicClassName("a.a.a"));
        Assert.assertFalse((boolean)JavaUtilities.isAtomicClassName("a.a.Main"));
    }

    @Test
    public void testBuildFullyQualifiedClassName() {
        Assert.assertEquals((String)"a.b.A", (String)JavaUtilities.buildFullyQualifiedClassName("a.b", "A"));
        Assert.assertEquals((String)"a.A", (String)JavaUtilities.buildFullyQualifiedClassName("a", "A"));
        Assert.assertEquals((String)"A", (String)JavaUtilities.buildFullyQualifiedClassName("", "A"));
    }

    @Test
    public void testExtractPackage() {
        Assert.assertEquals((String)"a.b", (String)JavaUtilities.extractPackage("a.b.A"));
        Assert.assertEquals((String)"a", (String)JavaUtilities.extractPackage("a.A"));
        Assert.assertEquals((String)"", (String)JavaUtilities.extractPackage("A"));
    }

    @Test
    public void testExtractClassName() {
        Assert.assertEquals((String)"A", (String)JavaUtilities.extractClassName("a.b.A"));
        Assert.assertEquals((String)"A", (String)JavaUtilities.extractClassName("a.A"));
        Assert.assertEquals((String)"A", (String)JavaUtilities.extractClassName("A"));
    }
}

