/*
 * Decompiled with CFR 0.152.
 */
package jadean.ui.java.handlers;

import java.util.ArrayList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class HandlerUtilities {
    public static IJavaProject getJavaProject(Object element) {
        if (element instanceof IJavaProject) {
            return (IJavaProject)element;
        }
        if (element instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)element;
            return javaElement.getJavaProject();
        }
        return null;
    }

    public static String getJavaOutputFolder(IJavaProject project) throws JavaModelException {
        return project.getCorrespondingResource().getLocation().append(project.getOutputLocation().removeFirstSegments(1)).toFile().getAbsolutePath().toString();
    }

    public static String[] getJavaSourceFolders(IJavaProject project) throws JavaModelException {
        ArrayList<String> sourceFolders = new ArrayList<String>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry ce = iClasspathEntryArray[n2];
            if (ce.getEntryKind() == 3) {
                sourceFolders.add(project.getCorrespondingResource().getLocation().append(ce.getPath().removeFirstSegments(1)).toFile().getAbsolutePath().toString());
            }
            ++n2;
        }
        return sourceFolders.toArray(new String[sourceFolders.size()]);
    }

    public static String[] getJavaReferencedPackages(IJavaProject project) throws JavaModelException {
        ArrayList<String> referencedLibraries = new ArrayList<String>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry ce = iClasspathEntryArray[n2];
            if (ce.getEntryKind() == 1) {
                System.out.println(ce.getPath() + " " + ce.getPath().getDevice());
                if (ce.getPath().getDevice() != null) {
                    referencedLibraries.add(ce.getPath().toFile().getAbsolutePath());
                } else if (ce.getPath().segment(0).equals(project.getCorrespondingResource().getLocation().lastSegment())) {
                    referencedLibraries.add(project.getCorrespondingResource().getLocation().append(ce.getPath().removeFirstSegments(1)).toFile().getAbsolutePath().toString());
                } else {
                    referencedLibraries.add(project.getCorrespondingResource().getLocation().removeLastSegments(1).append(ce.getPath()).toFile().getAbsolutePath());
                }
            }
            ++n2;
        }
        return referencedLibraries.toArray(new String[referencedLibraries.size()]);
    }
}

