/*
 * Decompiled with CFR 0.152.
 */
package jadean.ui.java.wizards;

import jadean.dean.java.JavaPackage;
import jadean.ui.java.wizards.JavaPackageLabelProvider;
import jadean.ui.java.wizards.WizardInput;
import jadean.ui.java.wizards.WizardInputChangedListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class BasicInformationPage
extends WizardPage {
    private Text projectName;
    private Text projectOutputFolder;
    private Composite container;
    private Composite smallContainer;
    private Composite largeContainer;
    private WizardInput input;
    private Table sourceFoldersTB;
    private Table referencedLibrariesTB;
    private TableViewer sourceFoldersTV;
    private TableViewer referencedLibrariesTV;

    public BasicInformationPage(WizardInput input) {
        super("Project basic information");
        this.setTitle("Project basic information");
        this.setDescription("This page shows basic project information such as project name, source folders, output folder and list of referenced libraries");
        this.input = input;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 4);
        this.container.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.container.setLayout((Layout)new GridLayout());
        this.smallContainer = new Composite(this.container, 4);
        this.smallContainer.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridLayout l2 = new GridLayout();
        this.smallContainer.setLayout((Layout)l2);
        l2.numColumns = 2;
        Label label1 = new Label(this.smallContainer, 0);
        label1.setText("Project name: ");
        this.projectName = new Text(this.smallContainer, 2052);
        this.projectName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.projectName.setText(this.input.getProject().getProjectName());
        Label label2 = new Label(this.smallContainer, 0);
        label2.setText("Project output folder: ");
        this.projectOutputFolder = new Text(this.smallContainer, 2052);
        this.projectOutputFolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.projectOutputFolder.setText(this.input.getProject().getOutputFolder());
        this.largeContainer = new Composite(this.container, 4);
        this.largeContainer.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        GridLayout l3 = new GridLayout();
        this.largeContainer.setLayout((Layout)l3);
        l3.numColumns = 3;
        Label sourceFoldersLB = new Label(this.largeContainer, 128);
        sourceFoldersLB.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        sourceFoldersLB.setText("Project source folders: ");
        this.sourceFoldersTV = new TableViewer(this.largeContainer, 67584);
        this.sourceFoldersTV.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sourceFoldersTV.setInput(this.input.getProject().getSourceFolders());
        this.sourceFoldersTB = this.sourceFoldersTV.getTable();
        this.sourceFoldersTB.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite sourceFoldersButtonsCO = new Composite(this.largeContainer, 0);
        sourceFoldersButtonsCO.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        GridLayout bl = new GridLayout();
        bl.numColumns = 1;
        sourceFoldersButtonsCO.setLayout((Layout)bl);
        Button addSourceFolderBT = new Button(sourceFoldersButtonsCO, 0);
        addSourceFolderBT.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                DirectoryDialog dd = new DirectoryDialog(BasicInformationPage.this.getShell(), 4096);
                dd.setFilterPath(BasicInformationPage.this.input.getPath());
                String s = dd.open();
                if (s != null) {
                    BasicInformationPage.this.sourceFoldersTV.add((Object)s);
                    BasicInformationPage.this.input.getProject().getSourceFolders().add(s);
                    BasicInformationPage.this.input.notifyListeners();
                }
            }
        });
        addSourceFolderBT.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addSourceFolderBT.setText("Add");
        Button removeSourceFolderBT = new Button(sourceFoldersButtonsCO, 0);
        removeSourceFolderBT.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (BasicInformationPage.this.sourceFoldersTB.getSelectionIndex() < 0) {
                    return;
                }
                BasicInformationPage.this.sourceFoldersTB.remove(BasicInformationPage.this.sourceFoldersTB.getSelectionIndex());
                BasicInformationPage.this.input.getProject().getSourceFolders().remove(BasicInformationPage.this.sourceFoldersTB.getSelectionIndex());
                BasicInformationPage.this.input.notifyListeners();
            }
        });
        removeSourceFolderBT.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        removeSourceFolderBT.setText("Remove");
        Label label4 = new Label(this.largeContainer, 0);
        label4.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        label4.setText("Project referenced libraries: ");
        this.referencedLibrariesTV = new TableViewer(this.largeContainer, 67584);
        this.referencedLibrariesTV.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.referencedLibrariesTV.setLabelProvider((IBaseLabelProvider)new JavaPackageLabelProvider());
        this.referencedLibrariesTV.setInput(this.input.getProject().getReferencedPackages());
        this.referencedLibrariesTB = this.referencedLibrariesTV.getTable();
        this.referencedLibrariesTB.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite referencedLibrariesButtonsCO = new Composite(this.largeContainer, 0);
        referencedLibrariesButtonsCO.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        GridLayout bl2 = new GridLayout();
        bl2.numColumns = 1;
        referencedLibrariesButtonsCO.setLayout((Layout)bl2);
        Button addReferencedLibraryBT = new Button(referencedLibrariesButtonsCO, 0x1000000);
        addReferencedLibraryBT.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        addReferencedLibraryBT.setText("Add");
        addReferencedLibraryBT.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FileDialog dd = new FileDialog(BasicInformationPage.this.getShell(), 4096);
                dd.setFilterPath(BasicInformationPage.this.input.getPath());
                dd.setFilterExtensions(new String[]{"*.jar"});
                dd.setFilterNames(new String[]{"JAR file"});
                String s = dd.open();
                if (s != null) {
                    BasicInformationPage.this.referencedLibrariesTV.add((Object)new JavaPackage(s));
                    BasicInformationPage.this.input.getProject().getReferencedPackages().add(new JavaPackage(s));
                    BasicInformationPage.this.input.notifyListeners();
                }
            }
        });
        Button removeReferencedLibrary = new Button(referencedLibrariesButtonsCO, 0);
        removeReferencedLibrary.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        removeReferencedLibrary.setText("Remove");
        removeReferencedLibrary.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (BasicInformationPage.this.referencedLibrariesTB.getSelectionIndex() < 0) {
                    return;
                }
                BasicInformationPage.this.referencedLibrariesTB.remove(BasicInformationPage.this.referencedLibrariesTB.getSelectionIndex());
                BasicInformationPage.this.input.getProject().getReferencedPackages().remove(BasicInformationPage.this.referencedLibrariesTB.getSelectionIndex());
            }
        });
        this.input.addListener(new WizardInputChangedListener(){

            public void inputChanged() {
                try {
                    BasicInformationPage.this.sourceFoldersTV.refresh();
                    BasicInformationPage.this.referencedLibrariesTV.refresh();
                }
                catch (Exception exception) {}
            }
        });
        this.setControl((Control)this.container);
        this.setPageComplete(true);
        this.input.notifyListeners();
    }
}

