/*
 * Decompiled with CFR 0.152.
 */
package jadean.ui.java.wizards;

import jadean.dean.Resource;
import jadean.dean.java.resources.JavaResourceProjectClass;
import jadean.ui.java.wizards.WizardInput;
import java.io.File;
import java.util.Collection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EntryPointPage
extends WizardPage {
    private Text entryPointTF;
    private Combo foundCB;
    private Composite mainCO;
    private Composite selectFoundCO;
    private Composite selectOtherCO;
    private WizardInput input;
    private Button foundRB;
    private Button manuallyRB;
    private Button browseBT;
    private Label foundLB;
    private Label manuallyLB;

    public EntryPointPage(WizardInput input) {
        super("Entry point");
        this.setTitle("Entry point");
        this.setDescription("Please select entry point of the application. You can do it by selecting resource from classes with method main, or manually by choosing file with source code of the entry point.");
        this.setControl((Control)this.entryPointTF);
        this.input = input;
    }

    public void createControl(Composite parent) {
        this.mainCO = new Composite(parent, 0);
        this.mainCO.setLayout((Layout)new GridLayout(1, true));
        this.selectFoundCO = new Composite(this.mainCO, 0);
        this.selectFoundCO.setLayout((Layout)new GridLayout(3, false));
        this.selectFoundCO.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.foundRB = new Button(this.selectFoundCO, 16);
        this.foundRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntryPointPage.this.entryPointTF.setEnabled(false);
                EntryPointPage.this.browseBT.setEnabled(false);
                EntryPointPage.this.manuallyRB.setSelection(false);
                EntryPointPage.this.manuallyLB.setEnabled(false);
                EntryPointPage.this.foundCB.setEnabled(true);
                EntryPointPage.this.foundRB.setSelection(true);
                EntryPointPage.this.foundLB.setEnabled(true);
                EntryPointPage.this._setPageComplete();
            }
        });
        this.foundLB = new Label(this.selectFoundCO, 0);
        this.foundLB.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.foundLB.setText("Select entry point from found resources");
        this.foundCB = new Combo(this.selectFoundCO, 8);
        this.foundCB.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.foundCB.add("<< Select from found resources >>");
        Collection<JavaResourceProjectClass> mainClasses = this.input.getProject().getClassesWithMainMethod();
        for (Resource resource : mainClasses) {
            this.foundCB.add(resource.getName());
        }
        if (mainClasses.size() > 0) {
            this.foundCB.select(1);
        } else {
            this.foundCB.select(0);
        }
        this._selectFound();
        this.foundCB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntryPointPage.this._selectFound();
                EntryPointPage.this._setPageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EntryPointPage.this._selectFound();
                EntryPointPage.this._setPageComplete();
            }
        });
        this.selectOtherCO = new Composite(this.mainCO, 0);
        this.selectOtherCO.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gridLayout = new GridLayout();
        this.selectOtherCO.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 4;
        this.manuallyRB = new Button(this.selectOtherCO, 16);
        this.manuallyRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntryPointPage.this.entryPointTF.setEnabled(true);
                EntryPointPage.this.browseBT.setEnabled(true);
                EntryPointPage.this.manuallyRB.setSelection(true);
                EntryPointPage.this.manuallyLB.setEnabled(true);
                EntryPointPage.this.foundCB.setEnabled(false);
                EntryPointPage.this.foundRB.setSelection(false);
                EntryPointPage.this.foundLB.setEnabled(false);
                EntryPointPage.this._setPageComplete();
            }
        });
        this.manuallyLB = new Label(this.selectOtherCO, 0);
        this.manuallyLB.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.manuallyLB.setText("Select entry point manually");
        this.entryPointTF = new Text(this.selectOtherCO, 2052);
        this.entryPointTF.setText("");
        this.entryPointTF.setLayoutData((Object)new GridData(768));
        this.browseBT = new Button(this.selectOtherCO, 0);
        this.browseBT.setText("Browse...");
        this.browseBT.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FileDialog fd = new FileDialog(EntryPointPage.this.getShell(), 4096);
                fd.setFilterPath(EntryPointPage.this.input.getPath());
                fd.setFilterExtensions(new String[]{"*.java"});
                fd.setFilterNames(new String[]{"JAVA file"});
                String s = fd.open();
                if (s != null) {
                    EntryPointPage.this.entryPointTF.setText(s);
                    String entryPoint = EntryPointPage.this.input.getProject().extractResourceNameFromFileName(s);
                    EntryPointPage.this.input.setEntryPoint(entryPoint);
                    EntryPointPage.this._setPageComplete();
                }
            }
        });
        this.entryPointTF.setEnabled(false);
        this.browseBT.setEnabled(false);
        this.manuallyRB.setSelection(false);
        this.manuallyLB.setEnabled(false);
        this.foundCB.setEnabled(true);
        this.foundRB.setSelection(true);
        this.foundLB.setEnabled(true);
        this.setControl((Control)this.mainCO);
        this._setPageComplete();
        this.input.notifyListeners();
    }

    private void _setPageComplete() {
        if (this.manuallyRB.getSelection()) {
            if ("".equals(this.entryPointTF.getText())) {
                this.setErrorMessage(null);
                this.setPageComplete(false);
            } else {
                File f = new File(this.entryPointTF.getText());
                if (f.exists()) {
                    this.setErrorMessage(null);
                    this.setPageComplete(true);
                } else {
                    this.setErrorMessage("Resource does not exist!");
                    this.setPageComplete(false);
                }
            }
        } else if (this.foundRB.getSelection()) {
            if (this.foundCB.getSelectionIndex() > 0) {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(false);
            }
        }
    }

    private void _selectFound() {
        if (this.foundCB.getSelectionIndex() > 0) {
            this.input.setEntryPoint(this.foundCB.getItem(this.foundCB.getSelectionIndex()));
        }
    }
}

