/*
 * Decompiled with CFR 0.152.
 */
package jadean.ui.java.wizards;

import jadean.dean.Resource;
import jadean.ui.java.wizards.AllResourcesLabelProvider;
import jadean.ui.java.wizards.ResourceFilter;
import jadean.ui.java.wizards.ResourceLabelProvider;
import jadean.ui.java.wizards.WizardInput;
import jadean.ui.java.wizards.WizardInputChangedListener;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ResultPage
extends WizardPage {
    private Composite containerCO;
    private Table allResources;
    private Table unusedResources;
    private WizardInput input;
    private CheckboxTableViewer unusedResourcesTV;
    private TableViewer allResourcesTV;
    private TabFolder tabFolder;
    private TabItem allResourcesTI;
    private TabItem unusedResourcesTI;
    private AllResourcesLabelProvider arlp;
    private ResourceFilter allResourcesFilter;
    private ResourceFilter unusedResourcesFilter;

    public ResultPage(WizardInput _input) {
        super("Dependency Analyzer result");
        this.setTitle("Dependency Analyzer result");
        this.setDescription("This page shows result dependency analysis result. Tab All resources shows list of all resources of the project, used resources are in bold. Tab Unused resources shows list of unused resources. You can deselect resources by unchecking them. Selected resources will be deleted after clicking Finish button.");
        this.setControl((Control)this.allResources);
        this.input = _input;
    }

    public void createControl(Composite parent) {
        this.containerCO = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.containerCO.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.tabFolder = new TabFolder(this.containerCO, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.allResourcesTI = new TabItem(this.tabFolder, 0);
        this.allResourcesTI.setText("All resources");
        this.unusedResourcesTI = new TabItem(this.tabFolder, 0);
        this.unusedResourcesTI.setText("Unused resources");
        this.arlp = new AllResourcesLabelProvider();
        this.allResourcesFilter = new ResourceFilter();
        this.unusedResourcesFilter = new ResourceFilter();
        Composite c1 = new Composite((Composite)this.tabFolder, 0);
        c1.setLayout((Layout)new GridLayout(1, true));
        final Text allResourcesFilterText = new Text(c1, 2176);
        this.allResourcesTV = new TableViewer(c1, 2052);
        allResourcesFilterText.setLayoutData((Object)new GridData(768));
        allResourcesFilterText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ResultPage.this.allResourcesFilter.setSearchString(allResourcesFilterText.getText());
                ResultPage.this.allResourcesTV.refresh();
            }

            public void keyPressed(KeyEvent e) {
                ResultPage.this.allResourcesFilter.setSearchString(allResourcesFilterText.getText());
                ResultPage.this.allResourcesTV.refresh();
            }
        });
        this.allResourcesTV.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.allResourcesTV.setLabelProvider((IBaseLabelProvider)this.arlp);
        this.allResourcesTV.addFilter((ViewerFilter)this.allResourcesFilter);
        this.allResources = this.allResourcesTV.getTable();
        this.allResources.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite c3 = new Composite((Composite)this.tabFolder, 3);
        GridLayout gl = new GridLayout(1, true);
        c3.setLayout((Layout)gl);
        this.unusedResourcesTV = CheckboxTableViewer.newCheckList((Composite)c3, (int)2084);
        this.unusedResourcesTV.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.unusedResourcesTV.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        this.unusedResourcesTV.addFilter((ViewerFilter)this.unusedResourcesFilter);
        this.unusedResources = this.unusedResourcesTV.getTable();
        this.unusedResources.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        final Text unusedFilterText = new Text(c3, 2176);
        unusedFilterText.setLayoutData((Object)new GridData(768));
        unusedFilterText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ResultPage.this.unusedResourcesFilter.setSearchString(unusedFilterText.getText());
                ResultPage.this.unusedResourcesTV.refresh();
            }

            public void keyPressed(KeyEvent e) {
                ResultPage.this.unusedResourcesFilter.setSearchString(unusedFilterText.getText());
                ResultPage.this.unusedResourcesTV.refresh();
            }
        });
        this.allResourcesTI.setControl((Control)c1);
        this.unusedResourcesTI.setControl((Control)c3);
        this.input.addListener(new WizardInputChangedListener(){

            public void inputChanged() {
                if (ResultPage.this.input.getEntryPoint() == null) {
                    return;
                }
                try {
                    ResultPage.this.refresh();
                }
                catch (Exception exception) {}
            }
        });
        this.setControl((Control)this.containerCO);
        this.setPageComplete(true);
    }

    public Object[] getCheckedElements() {
        return this.unusedResourcesTV.getCheckedElements();
    }

    public void refresh() {
        Collection<Resource> usedResources = this.input.getProject().getUsedResources(this.input.getEntryPoint());
        Collection<Resource> unusedResources = this.input.getProject().getUnusedResources(this.input.getEntryPoint());
        Collection<Resource> allResources = this.input.getProject().getAllResources();
        System.out.println(String.valueOf(usedResources.size()) + " " + unusedResources.size() + " " + allResources.size());
        Object[] usedResourcesI = usedResources.toArray(new Resource[usedResources.size()]);
        Arrays.sort(usedResourcesI);
        this.arlp.setUsedResources((Resource[])usedResourcesI);
        Object[] unusedResourcesI = unusedResources.toArray(new Resource[unusedResources.size()]);
        Arrays.sort(unusedResourcesI);
        this.unusedResourcesTV.setInput((Object)unusedResourcesI);
        this.unusedResourcesTV.refresh();
        this.unusedResourcesTV.setAllChecked(true);
        Object[] allResourcesI = allResources.toArray(new Resource[allResources.size()]);
        Arrays.sort(allResourcesI);
        this.allResourcesTV.setInput((Object)allResourcesI);
        this.allResourcesTV.refresh();
        this.setMessage("By clicking on Finish button you can violate the licences' terms of conditions of included libraries!", 2);
        if (this.input.getProject().isReflectionUsed()) {
            this.setErrorMessage("Use of Java Reflection API was detected in this project. By clicking on Finish button you risk deleting important resources!");
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.refresh();
        }
    }
}

