/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import bakalarka.Automaton;
import bakalarka.AutomatonAnalyzerThread;
import bakalarka.AutomatonIterator;
import bakalarka.FastPrint;
import bakalarka.Functions;
import bakalarka.MergeThread;
import bakalarka.MinimalAutomatonHashMap;
import bakalarka.MinimalAutomatonHashMapWithCounter;
import bakalarka.NaiveAutomatonIterator;
import bakalarka.Tuple;
import bakalarka.Variables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;

public class Experiments {
    static int sumCollisions(HashMap<BigInteger, Integer> m) {
        Integer sum = 0;
        for (BigInteger x : m.keySet()) {
            sum = sum + m.get(x);
        }
        return sum;
    }

    static double avgCollisions(HashMap<BigInteger, Integer> m) {
        return (double)Experiments.sumCollisions(m) / (double)m.size();
    }

    public static void safeWordLengthExperiment(int n) throws Exception {
        int wordLength = 0;
        HashMap<BigInteger, Integer> collisionCount = new HashMap<BigInteger, Integer>();
        do {
            collisionCount = new HashMap();
            Variables.initializeWordToNumberMap(wordLength);
            MinimalAutomatonHashMap languages = new MinimalAutomatonHashMap();
            for (int i = 1; i <= n; ++i) {
                AutomatonIterator it = new AutomatonIterator(i);
                while (it.hasNext()) {
                    Automaton a = it.next();
                    boolean isNew = languages.tryToInsert(a);
                    if (!isNew) continue;
                    BigInteger hashCode = a.hashCodeFromWords(wordLength);
                    if (collisionCount.containsKey(hashCode)) {
                        Integer oldVal = collisionCount.get(hashCode);
                        collisionCount.put(hashCode, oldVal + 1);
                        continue;
                    }
                    collisionCount.put(hashCode, 0);
                }
            }
            System.out.println(wordLength + " & " + Experiments.sumCollisions(collisionCount));
            ++wordLength;
        } while (Experiments.sumCollisions(collisionCount) > 0);
    }

    public static MinimalAutomatonHashMap treeMerge(ArrayList<MinimalAutomatonHashMap> listOfCandidates) throws InterruptedException {
        if (listOfCandidates.isEmpty()) {
            return null;
        }
        while (listOfCandidates.size() != 1) {
            int i;
            System.err.printf("Number of candidates lists: %d%n", listOfCandidates.size());
            int pocetZoznamov = listOfCandidates.size();
            ArrayList<MergeThread> mergers = new ArrayList<MergeThread>();
            for (i = 0; i < pocetZoznamov / 2; ++i) {
                mergers.add(new MergeThread(listOfCandidates.get(2 * i), listOfCandidates.get(2 * i + 1)));
                ((MergeThread)mergers.get(i)).start();
            }
            for (i = 0; i < pocetZoznamov / 2; ++i) {
                ((MergeThread)mergers.get(i)).join();
            }
            ArrayList<MinimalAutomatonHashMap> newCandidates = new ArrayList<MinimalAutomatonHashMap>();
            for (int i2 = 0; i2 < pocetZoznamov / 2; ++i2) {
                newCandidates.add(((MergeThread)mergers.get((int)i2)).result);
            }
            if (pocetZoznamov % 2 == 1) {
                newCandidates.add(listOfCandidates.get(pocetZoznamov - 1));
            }
            listOfCandidates = newCandidates;
        }
        return listOfCandidates.get(0);
    }

    public static void generateAllNFAsOfSize(int limit) throws IOException, Exception {
        FastPrint.cleanFile(Variables.outputFileForAutomata);
        FastPrint.cleanFile(Variables.outputFile);
        Variables.initialize();
        for (int i = 1; i <= limit; ++i) {
            ArrayList<AutomatonAnalyzerThread> slaves = new ArrayList<AutomatonAnalyzerThread>();
            for (int j = 0; j < Variables.numberOfCores; ++j) {
                slaves.add(new AutomatonAnalyzerThread(i, j));
            }
            for (AutomatonAnalyzerThread slave : slaves) {
                slave.start();
            }
            for (AutomatonAnalyzerThread slave : slaves) {
                slave.join();
            }
            System.err.printf("Merging candidates started for " + i + " states at time: %s%n", Functions.getFormattedTime((int)((System.nanoTime() - Variables.start) / 1000000000L)));
            ArrayList<MinimalAutomatonHashMap> candidates = new ArrayList<MinimalAutomatonHashMap>();
            for (AutomatonAnalyzerThread slave : slaves) {
                candidates.add(slave.minimalNFAsResult);
            }
            MinimalAutomatonHashMap result = Experiments.treeMerge(candidates);
            System.err.printf("Merging ended, time: %s%n", Functions.getFormattedTime((int)((System.nanoTime() - Variables.start) / 1000000000L)));
            Variables.allMinimalDFAs = MergeThread.merge(Variables.allMinimalDFAs, result);
            System.err.printf("%d languages found%n", Variables.allMinimalDFAs.size());
        }
        System.err.printf("%d automata tested%n", Variables.counterOfTestedAutomata);
        System.err.printf("Generating automata ended at time: %s%n", Functions.getFormattedTime((int)((System.nanoTime() - Variables.start) / 1000000000L)));
        Variables.outputStream.close();
    }

    public static void automataFileToHashes() throws FileNotFoundException, Exception {
        PrintWriter writer = new PrintWriter("automataHashes.txt", "UTF-8");
        Scanner s = new Scanner(new File(Variables.automataFile));
        HashSet automataHashCodes = new HashSet();
        int counter = 0;
        while (s.hasNext()) {
            if (counter++ % 100000 == 99999) {
                System.err.println(counter + " languages processed");
            }
            Automaton.readAutomaton(s);
            Automaton a = Automaton.readAutomaton(s);
            if (a == null) continue;
            if (automataHashCodes.contains(a.myHashCode())) {
                System.err.println("FAIL");
                System.exit(1);
            }
            writer.println(a.myHashCode());
        }
        Variables.allMinimalDFAs.allMinDFACodes = automataHashCodes;
        writer.close();
    }

    public static void readAutomataHashes() throws IOException {
        BufferedReader bi = new BufferedReader(new InputStreamReader(new FileInputStream(Variables.hashesFile)));
        int counter = 0;
        while (bi.ready()) {
            String str = bi.readLine();
            String[] splited = str.split("\\s+");
            BigInteger first = new BigInteger(splited[0]);
            Integer second = Integer.parseInt(splited[1]);
            Tuple hash = new Tuple(first, second);
            Variables.allMinimalDFAs.insertValue(hash);
            if (counter++ % 100000 != 99999) continue;
            System.err.println(counter + " hashes processed");
        }
    }

    public static void fiveStateNFAs(long numberOfSamples) throws Exception {
        Variables.initialize();
        Variables.allMinimalDFAs.clear();
        Experiments.readAutomataHashes();
        AutomatonIterator it = new AutomatonIterator(5);
        long counter = 0L;
        int time = (int)(System.nanoTime() / 1000000000L);
        FastPrint fp = new FastPrint("5StateNFAvsDFA" + time + ".txt", false);
        FastPrint automata = new FastPrint("5StateAutomata" + time + ".txt", false);
        automata.println("#initial state is fixed to 0 the format of output is the following\n#/number of the automaton\n#number of states\n#id of initial state (-1 if none)\n#number of final states followed by final states enumeration\n#number of transitions followed by its enumeration\n#from_state to_state character\n#begin of output:\n");
        for (long i = 0L; i < numberOfSamples; ++i) {
            Automaton a;
            if (i % 100000L == 0L) {
                int seconds = (int)((System.nanoTime() - Variables.start) / 1000000000L);
                System.err.printf("%d automata generated, time: %s, %d automata in MinimalAutomatonHashMap%n", i, Functions.getFormattedTime(seconds), Variables.allMinimalDFAs.size());
            }
            if (!Variables.allMinimalDFAs.tryToInsert(a = it.random())) continue;
            fp.println(a.numberOfStates() + " " + a.minimalDFA().numberOfStates());
            a.print(automata, ++counter);
        }
        fp.close();
    }

    public static void fourStateNFAs(long numberOfSamples) throws Exception {
        Variables.initialize();
        Variables.allMinimalDFAs.clear();
        Experiments.readAutomataHashes();
        AutomatonIterator it = new AutomatonIterator(4);
        long counter = 0L;
        int time = (int)(System.nanoTime() / 1000000000L);
        FastPrint fp = new FastPrint("4StateNFAvsDFA" + time + ".txt", false);
        FastPrint automata = new FastPrint("4StateAutomata" + time + ".txt", false);
        automata.println("#initial state is fixed to 0 the format of output is the following\n#/number of the automaton\n#number of states\n#id of initial state (-1 if none)\n#number of final states followed by final states enumeration\n#number of transitions followed by its enumeration\n#from_state to_state character\n#begin of output:\n");
        for (long i = 0L; i < numberOfSamples; ++i) {
            Automaton a;
            if (i % 100000L == 0L) {
                int seconds = (int)((System.nanoTime() - Variables.start) / 1000000000L);
                System.err.printf("%d automata generated, time: %s, %d automata in MinimalAutomatonHashMap%n", i, Functions.getFormattedTime(seconds), Variables.allMinimalDFAs.size());
            }
            if (!Variables.allMinimalDFAs.tryToInsert(a = it.random())) continue;
            fp.println(a.numberOfStates() + " " + a.minimalDFA().numberOfStates());
            a.print(automata, ++counter);
        }
        fp.close();
    }

    public static void automataDistributionExperiment(int n) throws Exception {
        MinimalAutomatonHashMapWithCounter languages = new MinimalAutomatonHashMapWithCounter();
        ArrayList<Tuple> InterestingLanguageHashCodes = new ArrayList<Tuple>();
        for (int i = 1; i <= n; ++i) {
            NaiveAutomatonIterator it = new NaiveAutomatonIterator(i);
            int j = 0;
            while (it.hasNext()) {
                ++j;
                Automaton automaton = it.next();
                if (!languages.tryToInsert(automaton) || i != n) continue;
                InterestingLanguageHashCodes.add(automaton.myHashCode());
            }
            System.out.println(j);
        }
        ArrayList<Integer> x = new ArrayList<Integer>();
        FastPrint fp = new FastPrint("AutomataDistribution.txt", false);
        for (Tuple tuple : InterestingLanguageHashCodes) {
            x.add(languages.allMinDFACodesWithCounter.get(tuple));
            fp.println(tuple + " " + languages.allMinDFACodesWithCounter.get(tuple));
        }
        fp.close();
        Collections.sort(x);
        fp = new FastPrint("sortedDistribution.txt", false);
        for (Integer n2 : x) {
            fp.println(n2.toString());
        }
        fp.close();
    }

    public static void analyzeMinimalNFADistribution(int n) throws Exception {
        MinimalAutomatonHashMapWithCounter languages = new MinimalAutomatonHashMapWithCounter();
        ArrayList<Tuple> InterestingLanguageHashCodes = new ArrayList<Tuple>();
        for (int i = 1; i <= n; ++i) {
            NaiveAutomatonIterator it = new NaiveAutomatonIterator(i);
            int j = 0;
            while (it.hasNext()) {
                ++j;
                Automaton automaton = it.next();
                if (!languages.tryToInsert(automaton) || i != n) continue;
                InterestingLanguageHashCodes.add(automaton.myHashCode());
            }
            System.out.println(j);
        }
        ArrayList<Integer> x = new ArrayList<Integer>();
        FastPrint fp = new FastPrint("AutomataDistribution.txt", false);
        for (Tuple tuple : InterestingLanguageHashCodes) {
            x.add(languages.allMinDFACodesWithCounter.get(tuple));
            fp.println(tuple + " " + languages.allMinDFACodesWithCounter.get(tuple));
        }
        fp.close();
        Collections.sort(x);
        fp = new FastPrint("sortedDistribution.txt", false);
        for (Integer n2 : x) {
            fp.println(n2.toString());
        }
        fp.close();
    }
}

