/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

public class Matrix {
    boolean[][] matrix;
    int n;
    private BigInteger numericRepresentation;

    public Matrix(int n) {
        this.numericRepresentation = BigInteger.valueOf(0L);
        this.matrix = new boolean[n][n];
        this.n = n;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.matrix[i][j] = false;
            }
        }
    }

    public Matrix(int n, BigInteger numericRepresentation) {
        this.numericRepresentation = numericRepresentation;
        this.matrix = new boolean[n][n];
        this.n = n;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.matrix[i][j] = numericRepresentation.mod(BigInteger.valueOf(2L)).equals(BigInteger.valueOf(1L));
                numericRepresentation = numericRepresentation.shiftRight(1);
            }
        }
    }

    public void set(int r, int c, boolean val) {
        this.matrix[r][c] = val;
        BigInteger offset = BigInteger.valueOf(1L).shiftLeft(this.n * r + c);
        if (val) {
            this.numericRepresentation = this.numericRepresentation.or(offset);
        } else if (this.get(r, c)) {
            this.numericRepresentation = this.numericRepresentation.subtract(offset);
        }
    }

    public BigInteger getNumericRepresentation() {
        return this.numericRepresentation;
    }

    public boolean get(int r, int c) {
        return this.matrix[r][c];
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("\n");
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.matrix[i][j]) {
                    ret.append("1 ");
                    continue;
                }
                ret.append("0 ");
            }
            ret.append("\n");
        }
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Matrix other = (Matrix)obj;
        if (!Arrays.deepEquals((Object[])this.matrix, (Object[])other.matrix)) {
            return false;
        }
        return this.n == other.n;
    }

    boolean isConnected() {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        HashSet<Integer> seen = new HashSet<Integer>();
        queue.add(0);
        seen.add(0);
        while (!queue.isEmpty()) {
            int current = (Integer)queue.remove();
            for (int i = 0; i < this.matrix[current].length; ++i) {
                if (!this.matrix[current][i] || seen.contains(i)) continue;
                seen.add(i);
                queue.add(i);
            }
        }
        for (int i = 0; i < this.n; ++i) {
            if (seen.contains(i)) continue;
            return false;
        }
        return true;
    }

    Matrix union(Matrix other) {
        return new Matrix(this.n, other.numericRepresentation.or(this.numericRepresentation));
    }

    public BigInteger getNumericRepresentationDFA() {
        BigInteger ret = BigInteger.valueOf(0L);
        for (int r = 0; r < this.n; ++r) {
            for (int c = 0; c < this.n; ++c) {
                if (!this.matrix[r][c]) continue;
                ret = ret.or(BigInteger.valueOf(1L).shiftLeft(this.n * r + c));
            }
        }
        return ret;
    }
}

