/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import bakalarka.Matrix;
import java.util.Iterator;
import java.util.Random;

public class MatrixIterator
implements Iterator<Matrix> {
    int n;
    long state;
    Random generator;
    long limit;

    public MatrixIterator(int n) {
        this.n = n;
        this.state = 0L;
        this.generator = new Random();
        this.limit = (long)Math.pow(2.0, n * n);
    }

    public MatrixIterator(int n, long limit) {
        this.n = n;
        this.state = 0L;
        this.generator = new Random();
        this.limit = limit;
    }

    public MatrixIterator(int n, MatrixIterator otherIt) {
        this.n = n;
        this.state = 0L;
        this.generator = new Random();
        this.limit = Math.min(otherIt.limit, otherIt.state + 1L);
    }

    @Override
    public Matrix next() {
        if (!this.hasNext()) {
            return null;
        }
        Matrix ret = new Matrix(this.n);
        long pom = this.state;
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                ret.set(i, j, pom % 2L == 1L);
                pom /= 2L;
            }
        }
        ++this.state;
        return ret;
    }

    public void skip() {
        if (!this.hasNext()) {
            return;
        }
        ++this.state;
    }

    @Override
    public boolean hasNext() {
        return this.state < this.limit;
    }

    public Matrix random() {
        long pom = this.state;
        this.state = Math.abs(this.generator.nextLong()) % this.limit;
        Matrix ret = this.next();
        this.state = pom;
        return ret;
    }

    public MatrixIterator copy() {
        MatrixIterator ret = new MatrixIterator(this.n);
        ret.state = this.state;
        ret.limit = this.limit;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

