/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import bakalarka.Identificator;
import bakalarka.SetOfIdentificators;
import bakalarka.Variables;
import java.util.HashMap;
import java.util.HashSet;

public class State
extends HashMap<Character, SetOfIdentificators> {
    Identificator id;

    public State(Identificator id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "state " + this.id.toString();
    }

    public State copy() {
        State ret = new State(this.id.copy());
        for (Character c : Variables.alphabet) {
            if (this.get(c) == null) continue;
            for (Identificator transitionStateId : (SetOfIdentificators)this.get(c)) {
                ret.addTransition(c, transitionStateId.copy());
            }
        }
        return ret;
    }

    public boolean isDeterministic() {
        for (Character c : Variables.alphabet) {
            if (this.get(c) != null && ((SetOfIdentificators)this.get(c)).size() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean addTransition(Character c, Identificator stateId) {
        SetOfIdentificators value = (SetOfIdentificators)this.get(c);
        if (value == null) {
            value = new SetOfIdentificators();
        }
        boolean ret = !value.contains(stateId);
        value.add(stateId);
        this.put(c, value);
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        return other.id.equals(this.id);
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    HashSet<Identificator> getTransition(Character c) {
        return (HashSet)this.get(c);
    }

    public void setIdentificator(Identificator id) {
        this.id = id;
    }

    public Identificator getId() {
        return this.id;
    }
}

