#pragma once

#include <stdio.h>
#include "ParamDataInfo.h"


using namespace std;
class FunctionDataInfo {

public:

	// filtering
	bool paramNameEnabled;
	bool moduleNameEnabled;
	bool classNameEnabled;
	bool typeNameEnabled;
	bool varNameEnabled;
	bool varValueEnabled;

	HRESULT hr;
	mdToken  methodToken;
	WCHAR widebuffer[largeBufSize * 2];
	CHAR methodName[bufSize];
	CHAR className[bufSize];
	CHAR moduleName[bufSize];
	CHAR tempbuf[bufSize];
	mdTypeDef Class;
	ULONG methodLength;
	ULONG classLength;
	ULONG moduleLength;
	bool methodDataFlag = false;
	PCOR_SIGNATURE pSignatureFunc = NULL;
	ULONG callingConvention;
	ULONG paramCount;
	ParamDataInfo* pReturnInfo;
	bool hasThis = false;
	bool thisType = false;

	vector<ParamDataInfo*> parameters;

	FunctionID funcId;
	UINT_PTR clientData;
	IMetaDataImport *ppImport;
	COR_PRF_FUNCTION_ARGUMENT_INFO *argumentInfo;
	COR_PRF_FRAME_INFO frameInfo;
	HCORENUM paramEnumerator;


	HRESULT getMethodNameAndClassType(char * name);
	HRESULT getClassName(char * name);
	HRESULT getModuleName(char * name);
	HRESULT getCallerName(char * name);
	HRESULT getArguments(char * name);
	HRESULT getAddress();

	void FunctionDataInfo::setClassName(bool val);
	void FunctionDataInfo::setParamName(bool val);
	void FunctionDataInfo::setModuleName(bool val);
	void FunctionDataInfo::setVarName(bool val);
	void FunctionDataInfo::setVarValue(bool val);
	void FunctionDataInfo::setTypeName(bool val);

	static bool parseFloat(UINT_PTR addr, char* temp);
	static bool parseDouble(UINT_PTR addr, char* temp);
	static bool parseInt(UINT_PTR addr, char* temp);
	static bool parseUint(UINT_PTR addr, char* temp);
	static bool parseInt64(UINT_PTR addr, char* temp);
	static bool parseUint64(UINT_PTR addr, char* temp);
	static bool parseInt8(UINT_PTR addr, char* temp);
	static bool parseShort(UINT_PTR addr, char* temp);
	static bool parseUshort(UINT_PTR addr, char* temp);
	static bool parseUintPointer(UINT_PTR addr, char* temp);
	static bool parseIntPointer(UINT_PTR addr, char* temp);
	static bool parseCharPointer(UINT_PTR addr, char* temp);
	static bool parseChar(UINT_PTR addr, char* temp);
	static bool parseBool(UINT_PTR addr, char* temp);
	static bool parseByte(UINT_PTR addr, char* temp);
	static bool parseString(UINT_PTR addr, char* temp);
	static bool parseIntArray(UINT_PTR addr, char* temp);
	static bool parseCharArray(UINT_PTR addr, char* temp);
	static bool parseByteArray(UINT_PTR addr, char* temp);
	static bool parseDoublePointer(UINT_PTR addr, char* temp);

	void release();
	bool isParamNameEnabled();
	bool isModuleNameEnabled();
	bool isClassNameEnabled();
	bool isVarNameEnabled();
	bool isTypeNameEnabled();
	bool isVarValueEnabled();

	// Constructor
	FunctionDataInfo(FunctionID funcId, UINT_PTR clientData, COR_PRF_FRAME_INFO frameInfo, COR_PRF_FUNCTION_ARGUMENT_INFO  *argumentInfo){

		this->paramEnumerator = NULL;
		this->funcId = funcId;
		this->clientData = clientData;
		this->frameInfo = frameInfo;
		this->argumentInfo = argumentInfo;
		this->ppImport = ppImport;
		this->paramNameEnabled = true;
		this->moduleNameEnabled = true;
		this->classNameEnabled = true;

		memset(widebuffer, 0, sizeof(widebuffer));

		// get MetadataToken for function with funcId and IMetadataImport interface to retreive information about function
		hr = pInfo->GetTokenAndMetaDataFromFunction(funcId, IID_IMetaDataImport, (IUnknown**)&ppImport, &methodToken);

		if (SUCCEEDED(hr)) {
			// get pointer to Signature describing function arguments and their types, and class token in which function is defined
			hr = ppImport->GetMethodProps(methodToken, &Class, widebuffer, bufSize, &methodLength, NULL, (PCCOR_SIGNATURE*)&pSignatureFunc, NULL, NULL, NULL);

			if (SUCCEEDED(hr)) {

				wcstombs((char*)methodName, widebuffer, bufSize);
				methodDataFlag = true;
			}

		}

		else	printf(" Error retreiving function token \r\n");

		hr = getModuleName(moduleName);

		if (!SUCCEEDED(hr)) printf(" Error retreiving module name \r\n");


	}



};

