#include "stdafx.h"
#include "FunctionDataInfo.h"


void ParamDataInfo::getName(char* buffer){

	memset(buffer, 0, sizeof(buffer));
	strcpy(buffer, this->valueTypeName);
}


// parse argument type in signature
ParamDataInfo* ParamDataInfo::ParseSignature(PCOR_SIGNATURE* ppSignature, IMetaDataImport *ppImport) {

	COR_SIGNATURE Signature;
	HRESULT	hr = NULL;
	mdToken	Token;
	WCHAR wname[bufSize * 2];
	ULONG nameSize;

	ParamDataInfo* parameterInfo = new ParamDataInfo();

	memset(parameterInfo->valueTypeName, 0, sizeof(parameterInfo->valueTypeName));
	memset(wname, 0, sizeof(wname));


	Signature = **ppSignature;
	// move forward in signature
	(*ppSignature)++;


	// Default
	strcpy(parameterInfo->valueTypeName, "UNKNOWN");

	// list of supported types
	switch (Signature){

	case ELEMENT_TYPE_VOID:
		strcpy(parameterInfo->valueTypeName, "void");
		break;
	case ELEMENT_TYPE_BOOLEAN:
		strcpy(parameterInfo->valueTypeName, "bool");
		break;
	case ELEMENT_TYPE_CHAR:
		strcpy(parameterInfo->valueTypeName, "char");
		break;
	case ELEMENT_TYPE_I1:
		strcpy(parameterInfo->valueTypeName, "INT8");
		break;
	case ELEMENT_TYPE_U1:
		strcpy(parameterInfo->valueTypeName, "byte");
		break;
	case ELEMENT_TYPE_I2:
		strcpy(parameterInfo->valueTypeName, "short");
		break;
	case ELEMENT_TYPE_U2:
		strcpy(parameterInfo->valueTypeName, "ushort");
		break;
	case ELEMENT_TYPE_I4:
		strcpy(parameterInfo->valueTypeName, "int");
		break;
	case ELEMENT_TYPE_U4:
		strcpy(parameterInfo->valueTypeName, "uint");
		break;
	case ELEMENT_TYPE_I8:
		strcpy(parameterInfo->valueTypeName, "int64");
		break;
	case ELEMENT_TYPE_U8:
		strcpy(parameterInfo->valueTypeName, "uint64");
		break;
	case ELEMENT_TYPE_R4:
		strcpy(parameterInfo->valueTypeName, "float");
		break;
	case ELEMENT_TYPE_R8:
		strcpy(parameterInfo->valueTypeName, "double");
		break;
	case ELEMENT_TYPE_STRING:
		strcpy(parameterInfo->valueTypeName, "String");
		break;
	case ELEMENT_TYPE_PTR:
		delete parameterInfo;
		parameterInfo = ParamDataInfo::ParseSignature(ppSignature, ppImport);
		strcat(parameterInfo->valueTypeName, "*");
		break;
	case ELEMENT_TYPE_BYREF:
		delete parameterInfo;
		parameterInfo = ParamDataInfo::ParseSignature(ppSignature, ppImport);
		strcat(parameterInfo->valueTypeName, "*");
		break;
	case ELEMENT_TYPE_VALUETYPE: 
		delete parameterInfo;
		parameterInfo = ParamDataInfo::ParseSignature(ppSignature, ppImport);
		strcat(parameterInfo->valueTypeName, "");
		break;
	case ELEMENT_TYPE_CLASS:


		(*ppSignature) += CorSigUncompressToken(*ppSignature, &Token);

		if (TypeFromToken(Token) == mdtTypeDef)
		{
			hr = ppImport->GetTypeDefProps(Token, wname, bufSize * 2, &nameSize, NULL, NULL);
		}
		else if (TypeFromToken(Token) == mdtTypeRef)
		{
			hr = ppImport->GetTypeRefProps(Token, NULL, wname, bufSize * 2, &nameSize);
		}


		if (SUCCEEDED(hr)) {

			wcstombs(parameterInfo->valueTypeName, wname, bufSize);
		}

		else  sprintf(parameterInfo->valueTypeName, "Token %u", Token);



		break;
	case ELEMENT_TYPE_VAR: break;
	case ELEMENT_TYPE_ARRAY: break;
	case ELEMENT_TYPE_GENERICINST: break;
	case ELEMENT_TYPE_TYPEDBYREF: break;
	case ELEMENT_TYPE_I: break;
	case ELEMENT_TYPE_U: break;
	case ELEMENT_TYPE_FNPTR:
		strcpy(parameterInfo->valueTypeName, "FunctionPointer");
		break;
	case ELEMENT_TYPE_OBJECT:
		strcpy(parameterInfo->valueTypeName, "PVOID");
		break;
	case ELEMENT_TYPE_SZARRAY:
		delete parameterInfo;
		parameterInfo = ParamDataInfo::ParseSignature(ppSignature, ppImport);
		strcat(parameterInfo->valueTypeName, "[]");
		break;
	case ELEMENT_TYPE_MVAR: break;
	case ELEMENT_TYPE_CMOD_REQD:

		(*ppSignature) += CorSigUncompressToken(*ppSignature, &Token);

		if (TypeFromToken(Token) == mdtTypeDef)
		{
			hr = ppImport->GetTypeDefProps(Token, wname, bufSize * 2, &nameSize, NULL, NULL);
		}
		else if (TypeFromToken(Token) == mdtTypeRef)
		{
			hr = ppImport->GetTypeRefProps(Token, NULL, wname, bufSize * 2, &nameSize);
		}


		if (SUCCEEDED(hr)) {

			wcstombs(parameterInfo->valueTypeName, wname, bufSize);
		}

		else  sprintf(parameterInfo->valueTypeName, "REQMOD Token %u", Token);


		break;
	case ELEMENT_TYPE_CMOD_OPT:
		(*ppSignature) += CorSigUncompressToken(*ppSignature, &Token);

		if (TypeFromToken(Token) == mdtTypeDef)
		{
			hr = ppImport->GetTypeDefProps(Token, wname, bufSize * 2, &nameSize, NULL, NULL);
		}
		else if (TypeFromToken(Token) == mdtTypeRef)
		{
			hr = ppImport->GetTypeRefProps(Token, NULL, wname, bufSize * 2, &nameSize);
		}


		if (SUCCEEDED(hr)) {

			wcstombs(parameterInfo->valueTypeName, wname, bufSize);
		}

		else  sprintf(parameterInfo->valueTypeName, "OPTMOD Token %u", Token);
		break;
	case ELEMENT_TYPE_INTERNAL: break;
	case ELEMENT_TYPE_MAX: break;
	case ELEMENT_TYPE_MODIFIER: break;
	case ELEMENT_TYPE_SENTINEL: break;
	case ELEMENT_TYPE_PINNED: break;

	}

	return parameterInfo;
}