#pragma once
#include "resource.h" 
#include "CorProfilerCallbackImpl.h"
#include "NETProfiler_i.h"
#include <unordered_map>
#include <stdint.h>


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif

using namespace ATL;

extern HANDLE hFile;
extern ICorProfilerInfo2* pInfo;
const ULONG smallBufSize = 20;
const ULONG largeBufSize = 1000;
const ULONG bufSize = 500;
const ULONG maxBufferCount = 50;
const ULONG maxStringLength = 150;



static void logData(char data[], bool console = true) {
	ULONG length;
	char dwrite[largeBufSize];
	if (IsBadCodePtr((FARPROC)data) == 0){

		if (console) printf("%s\r\n", data);
		strcpy(dwrite, data);
		strcat(dwrite, "\r\n");
		WriteFile(hFile, dwrite, strlen(dwrite), (LPDWORD)&length, NULL);

	}

}


// ATL generated, COM stuff
class ATL_NO_VTABLE CProfiler :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CProfiler, &CLSID_Profiler>,
	public CCorProfilerCallbackImpl
{
public:

	CProfiler()
	{
	}

	DECLARE_REGISTRY_RESOURCEID(IDR_PROFILER)

	// implemented interfaces need to be registered in COM_MAP
	BEGIN_COM_MAP(CProfiler)
		COM_INTERFACE_ENTRY(ICorProfilerCallback)
		COM_INTERFACE_ENTRY(ICorProfilerCallback2)
	END_COM_MAP()

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
	}


public:
	// get console for DLL
	HANDLE console = GetStdHandle(STD_OUTPUT_HANDLE);

	// implemented callbacks
	STDMETHOD(Initialize)(IUnknown *pICorProfilerInfoUnk);
	STDMETHOD(Shutdown)();
	STDMETHOD(ModuleLoadFinished)(ModuleID moduleID, HRESULT hrStatus);
	STDMETHOD(AssemblyLoadFinished)(AssemblyID assemblyID, HRESULT hrStatus);
};

OBJECT_ENTRY_AUTO(__uuidof(Profiler), CProfiler)

