/*
 * Decompiled with CFR 0.152.
 */
package baw;

import baw.InsufficientFunds;
import baw.TransactionBlockHelperClass;
import baw.TransactionDataSaveInfo;
import com.google.bitcoin.core.AbstractPeerEventListener;
import com.google.bitcoin.core.AbstractWalletEventListener;
import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.AddressFormatException;
import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Peer;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerException;
import com.google.bitcoin.core.PeerGroup;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.discovery.DnsDiscovery;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.store.BoundedOverheadBlockStore;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class BAWModel
extends Observable
implements Runnable {
    private NetworkParameters params = NetworkParameters.prodNet();
    private Wallet wallet;
    private PeerGroup peerGroup;
    private BlockChain blockChain;
    private File walletFile;
    private boolean FTRPconnected = false;

    public BAWModel() throws IOException, BlockStoreException {
        boolean freshWallet = false;
        this.walletFile = new File("baw.wallet");
        try {
            this.wallet = Wallet.loadFromFile(this.walletFile);
        }
        catch (IOException e) {
            this.wallet = new Wallet(this.params);
            ECKey key = new ECKey();
            this.wallet.keychain.add(key);
            this.wallet.saveToFile(this.walletFile);
            freshWallet = true;
        }
        System.out.println("Send to: " + this.wallet.keychain.get(0).toAddress(this.params));
        System.out.println(this.wallet);
        File blockChainFile = new File("baw.blockchain");
        if (!blockChainFile.exists() && !freshWallet) {
            this.wallet.clearTransactions(0);
        }
        this.blockChain = new BlockChain(this.params, this.wallet, (BlockStore)new BoundedOverheadBlockStore(this.params, blockChainFile));
        this.peerGroup = new PeerGroup(this.params, this.blockChain);
        this.peerGroup.setUserAgent("BAW", "1.0");
        this.peerGroup.addPeerDiscovery(new DnsDiscovery(this.params));
        this.peerGroup.addWallet(this.wallet);
        this.peerGroup.setFastCatchupTimeSecs(this.wallet.getEarliestKeyCreationTime());
        this.peerGroup.addEventListener(new AbstractPeerEventListener(){

            @Override
            public void onBlocksDownloaded(Peer peer, Block block, int blocksLeft) {
                super.onBlocksDownloaded(peer, block, blocksLeft);
                BAWModel.this.setChanged();
                BAWModel.this.notifyObservers();
            }

            @Override
            public void onPeerConnected(Peer peer, int peerCount) {
                super.onPeerConnected(peer, peerCount);
                System.out.println("Connected to: " + peer);
                String peerStr = peer.toString();
                if (peerStr.indexOf("173.242.112.53:8333") > -1) {
                    BAWModel.this.FTRPnodeConnected();
                } else {
                    BAWModel.this.setChanged();
                    BAWModel.this.notifyObservers();
                }
            }

            @Override
            public void onPeerDisconnected(Peer peer, int peerCount) {
                super.onPeerDisconnected(peer, peerCount);
                System.out.println("Disconnected from: " + peer);
                String peerStr = peer.toString();
                if (peerStr.indexOf("173.242.112.53:8333") > -1) {
                    BAWModel.this.FTRPnodeDisconnected();
                } else {
                    BAWModel.this.setChanged();
                    BAWModel.this.notifyObservers();
                }
            }
        });
        this.wallet.addEventListener(new AbstractWalletEventListener(){

            @Override
            public void onChange() {
                try {
                    System.out.println("Wallet changed");
                    BAWModel.this.wallet.saveToFile(BAWModel.this.walletFile);
                    System.out.println("Wallet saved");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                BAWModel.this.setChanged();
                BAWModel.this.notifyObservers();
            }

            @Override
            public void onCoinsReceived(Wallet wallet, Transaction tx, BigInteger prevBalance, BigInteger newBalance) {
                super.onCoinsReceived(wallet, tx, prevBalance, newBalance);
                BAWModel.this.setChanged();
                BAWModel.this.notifyObservers();
            }

            @Override
            public void onCoinsSent(Wallet wallet, Transaction tx, BigInteger prevBalance, BigInteger newBalance) {
                super.onCoinsSent(wallet, tx, prevBalance, newBalance);
                BAWModel.this.setChanged();
                BAWModel.this.notifyObservers();
            }

            @Override
            public void onReorganize(Wallet wallet) {
                super.onReorganize(wallet);
                BAWModel.this.setChanged();
                BAWModel.this.notifyObservers();
            }

            @Override
            public void onTransactionConfidenceChanged(Wallet wallet, Transaction tx) {
                super.onTransactionConfidenceChanged(wallet, tx);
                BAWModel.this.setChanged();
                BAWModel.this.notifyObservers();
            }
        });
        this.peerGroup.setMaxConnections(4);
    }

    public void start() {
        System.out.println("startuje");
        this.peerGroup.start();
        System.out.println("nacitavame blockchain");
        this.peerGroup.downloadBlockChain();
    }

    private void FTRPnodeDisconnected() {
        this.FTRPconnected = false;
        this.setChanged();
        this.notifyObservers();
    }

    private void FTRPnodeConnected() {
        this.FTRPconnected = true;
        this.setChanged();
        this.notifyObservers();
    }

    public String getMainAddress() {
        return this.wallet.keychain.get(0).toAddress(this.params).toString();
    }

    public BigInteger getWalletBalance() {
        return this.wallet.getBalance();
    }

    public String getBlockChainInfo() {
        return "#" + this.blockChain.getChainHead().getHeight() + " (" + this.blockChain.getChainHead().getHeader().getTime().toString() + ")";
    }

    public int getNumConnectedPeers() {
        return this.peerGroup.numConnectedPeers();
    }

    public int getMaxConnectedPeers() {
        return this.peerGroup.getMaxConnections();
    }

    public boolean isConnectedToFTRPnode() {
        return this.FTRPconnected;
    }

    @Override
    public void run() {
        this.start();
    }

    public void setNumberOfPeers(int number) {
        this.peerGroup.setMaxConnections(number);
    }

    public void connectToFTRPnode() {
        try {
            Peer peer = new Peer(this.params, new PeerAddress(InetAddress.getByName("173.242.112.53")), this.blockChain);
            peer.connect();
            if (this.peerGroup.numConnectedPeers() == this.peerGroup.getMaxConnections()) {
                this.peerGroup.setMaxConnections(this.peerGroup.getMaxConnections() + 1);
            }
            this.peerGroup.addPeer(peer);
        }
        catch (PeerException ex) {
            ex.printStackTrace();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<TransactionBlockHelperClass> getWalletTransactions() {
        ArrayList<TransactionBlockHelperClass> data = new ArrayList<TransactionBlockHelperClass>();
        Set<Transaction> walletTransactions = this.wallet.getTransactions(true, true);
        for (Transaction tx : walletTransactions) {
            int appearedAtBlock = -1;
            String confidenceString = "";
            if (tx.hasConfidence()) {
                try {
                    appearedAtBlock = tx.getConfidence().getAppearedAtChainHeight();
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
                TransactionConfidence.ConfidenceType confidenceType = tx.getConfidence().getConfidenceType();
                switch (confidenceType) {
                    case BUILDING: {
                        confidenceString = "v blokovej vetve";
                        break;
                    }
                    case NOT_IN_BEST_CHAIN: {
                        confidenceString = "nie v najlepsej vetve";
                        break;
                    }
                    case NOT_SEEN_IN_CHAIN: {
                        confidenceString = "nie je v blokovej vetve";
                        break;
                    }
                    case OVERRIDDEN_BY_DOUBLE_SPEND: {
                        confidenceString = "obet double spendingu";
                        break;
                    }
                    case UNKNOWN: {
                        confidenceString = "neznamy";
                    }
                }
            }
            TransactionBlockHelperClass tbhc = new TransactionBlockHelperClass(tx.getHashAsString(), appearedAtBlock, confidenceString);
            data.add(tbhc);
        }
        return data;
    }

    public void sendTheWholeWallet(String addressStr) throws AddressFormatException, IOException, InsufficientFunds {
        Address targetAddress = new Address(this.params, addressStr);
        Transaction tx = this.wallet.sendCoinsAsync(this.peerGroup, targetAddress, this.wallet.getBalance());
        if (tx == null) {
            throw new InsufficientFunds(new BigInteger("0"));
        }
    }

    public String saveDataInAddressTry(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException {
        TransactionDataSaveInfo dataSaveInfo = this.saveDataInAddress(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, transactionFee, transactionFeeType, false);
        return "Skutocne chcete ulozit udaje? Celkovo sa na data minie " + dataSaveInfo.getSumOutputPrice() + " Satoshi, na transakcne poplatky sa minie " + dataSaveInfo.getSumFee() + " Satoshi .";
    }

    public void saveDataInAddressExecute(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException {
        this.saveDataInAddress(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, transactionFee, transactionFeeType, true);
    }

    private TransactionDataSaveInfo saveDataInAddress(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType, boolean execute) throws InsufficientFunds, NotImplementedException, IOException {
        BigInteger sumOutputPrice = BigInteger.ZERO;
        BigInteger sumFee = BigInteger.ZERO;
        int numPieces = 0;
        byte[] messageBytes = this.convertToMessageBytes(transactionData);
        List<byte[]> pieces = this.divideIntoPieces(messageBytes, transactionMaxSize, "address");
        numPieces = pieces.size();
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        if (pieces.size() > 1) {
            throw new NotImplementedException();
        }
        for (byte[] piece : pieces) {
            byte[] pieceWithSize = this.prependPieceSize(piece);
            Transaction tx = new Transaction(this.params);
            BigInteger txOutputPrice = this.addDataAddressOutputs(tx, pieceWithSize, outputPrice);
            sumOutputPrice = sumOutputPrice.add(txOutputPrice);
            BigInteger fee = this.calculateNeededFee(tx, transactionFee, transactionFeeType);
            sumFee = sumFee.add(fee);
            boolean b = this.completeTxWithFee(tx, fee);
            if (b) {
                System.out.println(tx);
                for (TransactionOutput to : tx.getOutputs()) {
                    try {
                        byte[] hash = to.getScriptPubKey().getToAddress().getHash160();
                        for (int i = 0; i < hash.length; ++i) {
                            int actByte = hash[i] & 0xFF;
                            System.out.print(actByte + " ");
                        }
                        String conv = new String(hash);
                        System.out.println(" " + conv);
                        byte[] scriptBytes = to.getScriptBytes();
                        for (int i = 0; i < scriptBytes.length; ++i) {
                            int actByte = scriptBytes[i] & 0xFF;
                            System.out.print(actByte + " ");
                        }
                        System.out.println();
                    }
                    catch (ScriptException ex) {
                        ex.printStackTrace();
                    }
                }
                txs.add(tx);
                continue;
            }
            return null;
        }
        if (execute) {
            FileWriter fstream = new FileWriter(infoSaveLocation);
            BufferedWriter out = new BufferedWriter(fstream);
            for (Transaction transaction : txs) {
                out.write(transaction.getHashAsString() + " ");
            }
            out.close();
            for (Transaction transaction : txs) {
                this.peerGroup.broadcastTransaction(transaction);
                try {
                    this.wallet.commitTx(transaction);
                }
                catch (VerificationException ex) {
                    System.out.println("POZOR!!!! VerificationException");
                    ex.printStackTrace();
                }
            }
        }
        TransactionDataSaveInfo dataSaveInfo = new TransactionDataSaveInfo(sumOutputPrice, sumFee, numPieces);
        return dataSaveInfo;
    }

    public String saveDataInPubKeyTry(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException {
        TransactionDataSaveInfo dataSaveInfo = this.saveDataInPubKey(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, transactionFee, transactionFeeType, false);
        return "Skutocne chcete ulozit udaje? Celkovo sa na data minie " + dataSaveInfo.getSumOutputPrice() + " Satoshi, na transakcne poplatky sa minie " + dataSaveInfo.getSumFee() + " Satoshi .";
    }

    public void saveDataInPubKeyExecute(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException {
        this.saveDataInPubKey(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, transactionFee, transactionFeeType, true);
    }

    private TransactionDataSaveInfo saveDataInPubKey(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType, boolean execute) throws InsufficientFunds, NotImplementedException, IOException {
        BigInteger sumOutputPrice = BigInteger.ZERO;
        BigInteger sumFee = BigInteger.ZERO;
        int numPieces = 0;
        byte[] messageBytes = this.convertToMessageBytes(transactionData);
        List<byte[]> pieces = this.divideIntoPieces(messageBytes, transactionMaxSize, "pubkey");
        numPieces = pieces.size();
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        if (pieces.size() > 1) {
            throw new NotImplementedException();
        }
        for (byte[] piece : pieces) {
            byte[] pieceWithSize = this.prependPieceSize(piece);
            Transaction tx = new Transaction(this.params);
            BigInteger txOutputPrice = this.addDataPubKeyOutputs(tx, pieceWithSize, outputPrice);
            sumOutputPrice = sumOutputPrice.add(txOutputPrice);
            BigInteger fee = this.calculateNeededFee(tx, transactionFee, transactionFeeType);
            sumFee = sumFee.add(fee);
            boolean b = this.completeTxWithFee(tx, fee);
            if (b) {
                System.out.println(tx);
                for (TransactionOutput to : tx.getOutputs()) {
                    byte[] scriptBytes = to.getScriptBytes();
                    for (int i = 0; i < scriptBytes.length; ++i) {
                        int actByte = scriptBytes[i] & 0xFF;
                        System.out.print(actByte + " ");
                    }
                    String conv = new String(scriptBytes);
                    System.out.println(" " + conv);
                }
                txs.add(tx);
                continue;
            }
            return null;
        }
        if (execute) {
            FileWriter fstream = new FileWriter(infoSaveLocation);
            BufferedWriter out = new BufferedWriter(fstream);
            for (Transaction transaction : txs) {
                out.write(transaction.getHashAsString() + " ");
            }
            out.close();
            for (Transaction transaction : txs) {
                this.peerGroup.broadcastTransaction(transaction);
                try {
                    this.wallet.commitTx(transaction);
                }
                catch (VerificationException ex) {
                    System.out.println("POZOR!!!! VerificationException");
                    ex.printStackTrace();
                }
            }
        }
        TransactionDataSaveInfo dataSaveInfo = new TransactionDataSaveInfo(sumOutputPrice, sumFee, numPieces);
        return dataSaveInfo;
    }

    public String saveDataInScriptTry(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, String outputAddress, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException, AddressFormatException {
        TransactionDataSaveInfo dataSaveInfo = this.saveDataInScript(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, outputAddress, transactionFee, transactionFeeType, false);
        return "Skutocne chcete ulozit udaje? Celkovo sa na data minie " + dataSaveInfo.getSumOutputPrice() + " Satoshi, na transakcne poplatky sa minie " + dataSaveInfo.getSumFee() + " Satoshi .";
    }

    public void saveDataInScriptExecute(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, String outputAddress, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException, AddressFormatException {
        this.saveDataInScript(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, outputAddress, transactionFee, transactionFeeType, true);
    }

    private TransactionDataSaveInfo saveDataInScript(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, String outputAddress, BigInteger transactionFee, String transactionFeeType, boolean execute) throws InsufficientFunds, NotImplementedException, IOException, AddressFormatException {
        BigInteger sumOutputPrice = BigInteger.ZERO;
        BigInteger sumFee = BigInteger.ZERO;
        int numPieces = 0;
        byte[] messageBytes = this.convertToMessageBytes(transactionData);
        List<byte[]> pieces = this.divideIntoPieces(messageBytes, transactionMaxSize, "script");
        numPieces = pieces.size();
        ArrayList<Transaction> txs = new ArrayList<Transaction>();
        if (pieces.size() > 1) {
            throw new NotImplementedException();
        }
        for (byte[] piece : pieces) {
            byte[] pieceWithSize = this.prependPieceSize(piece);
            Transaction tx = new Transaction(this.params);
            BigInteger txOutputPrice = this.addDataScriptOutputs(tx, pieceWithSize, outputPrice, outputAddress);
            sumOutputPrice = sumOutputPrice.add(txOutputPrice);
            BigInteger fee = this.calculateNeededFee(tx, transactionFee, transactionFeeType);
            sumFee = sumFee.add(fee);
            boolean b = this.completeTxWithFee(tx, fee);
            if (b) {
                System.out.println(tx);
                for (TransactionOutput to : tx.getOutputs()) {
                    byte[] scriptBytes = to.getScriptBytes();
                    for (int i = 0; i < scriptBytes.length; ++i) {
                        int actByte = scriptBytes[i] & 0xFF;
                        System.out.print(actByte + " ");
                    }
                    String conv = new String(scriptBytes);
                    System.out.println(" " + conv);
                }
                txs.add(tx);
                continue;
            }
            return null;
        }
        if (execute) {
            FileWriter fstream = new FileWriter(infoSaveLocation);
            BufferedWriter out = new BufferedWriter(fstream);
            for (Transaction transaction : txs) {
                out.write(transaction.getHashAsString() + " ");
            }
            out.close();
            for (Transaction transaction : txs) {
                this.peerGroup.broadcastTransaction(transaction);
                try {
                    this.wallet.commitTx(transaction);
                }
                catch (VerificationException ex) {
                    System.out.println("POZOR!!!! VerificationException");
                    ex.printStackTrace();
                }
            }
        }
        TransactionDataSaveInfo dataSaveInfo = new TransactionDataSaveInfo(sumOutputPrice, sumFee, numPieces);
        return dataSaveInfo;
    }

    private byte[] convertToMessageBytes(String transactionData) {
        return transactionData.getBytes();
    }

    private List<byte[]> divideIntoPieces(byte[] messageBytes, int transactionMaxSize, String saveType) {
        double numOutputsInTrans;
        int maxSize;
        if (transactionMaxSize == 0) {
            transactionMaxSize = 900000;
        }
        int pieceSize = transactionMaxSize;
        if (saveType.equals("address")) {
            maxSize = transactionMaxSize - 13 - 63 - 4;
            numOutputsInTrans = (double)maxSize / 35.0;
            pieceSize = (int)Math.ceil(numOutputsInTrans * 20.0);
        }
        if (saveType.equals("pubkey")) {
            maxSize = transactionMaxSize - 13 - 63 - 4;
            numOutputsInTrans = (double)maxSize / 76.0;
            pieceSize = (int)Math.ceil(numOutputsInTrans * 65.0);
        }
        if (saveType.equals("script")) {
            maxSize = transactionMaxSize - 13 - 63 - 4;
            numOutputsInTrans = (double)maxSize / 9990.0;
            pieceSize = (int)Math.ceil(numOutputsInTrans * 9880.0);
        }
        System.out.println("piece size: " + pieceSize);
        ArrayList<byte[]> pieces = new ArrayList<byte[]>();
        for (int from = 0; from < messageBytes.length; from += pieceSize) {
            int to = from + pieceSize;
            if (to > messageBytes.length) {
                to = messageBytes.length;
            }
            byte[] piece = Arrays.copyOfRange(messageBytes, from, to);
            pieces.add(piece);
        }
        return pieces;
    }

    private byte[] prependPieceSize(byte[] piece) {
        int pl = piece.length;
        byte[] pieceWS = new byte[pl + 4];
        pieceWS[0] = (byte)(pl & 0xFF);
        pieceWS[1] = (byte)(pl >> 8 & 0xFF);
        pieceWS[2] = (byte)(pl >> 16 & 0xFF);
        pieceWS[3] = (byte)(pl >> 24 & 0xFF);
        System.arraycopy(piece, 0, pieceWS, 4, pl);
        return pieceWS;
    }

    private BigInteger addDataAddressOutputs(Transaction tx, byte[] piece, BigInteger outputPrice) {
        BigInteger sumOutputPrice = BigInteger.ZERO;
        for (int startByte = 0; startByte < piece.length; startByte += 20) {
            byte[] addrBytes = new byte[20];
            int length = Math.min(20, piece.length - startByte);
            System.arraycopy(piece, startByte, addrBytes, 0, length);
            Address addr = new Address(this.params, addrBytes);
            tx.addOutput(outputPrice, addr);
            sumOutputPrice = sumOutputPrice.add(outputPrice);
        }
        return sumOutputPrice;
    }

    private BigInteger calculateNeededFee(Transaction tx, BigInteger transactionFee, String transactionFeeType) {
        BigInteger fee = new BigInteger("0");
        if (transactionFeeType.equals("output")) {
            int numOutputs = tx.getOutputs().size();
            fee = fee.add(transactionFee);
            fee = fee.multiply(new BigInteger(numOutputs + ""));
        }
        if (transactionFeeType.equals("kB")) {
            int numBytes = 76;
            List<TransactionOutput> txOuts = tx.getOutputs();
            for (TransactionOutput transactionOutput : txOuts) {
                numBytes += 8;
                int scriptLen = transactionOutput.getScriptBytes().length;
                numBytes += scriptLen;
                int lengthBytes = scriptLen < 256 ? 1 : 4;
                numBytes += lengthBytes;
            }
            fee = fee.add(transactionFee);
            fee = fee.multiply(new BigInteger(numBytes + ""));
            fee = fee.divide(new BigInteger("1000"));
        }
        if (transactionFeeType.equals("fix")) {
            fee = fee.add(transactionFee);
        }
        return fee;
    }

    private boolean completeTxWithFee(Transaction tx, BigInteger fee) throws InsufficientFunds {
        return this.completeTxWithFee(tx, fee, this.wallet.keychain.get(0).toAddress(this.params));
    }

    private boolean completeTxWithFee(Transaction tx, BigInteger fee, Address changeAddress) throws InsufficientFunds {
        BigInteger satoshis = BigInteger.ZERO;
        satoshis = satoshis.add(fee);
        for (TransactionOutput output : tx.getOutputs()) {
            satoshis = satoshis.add(output.getValue());
        }
        BigInteger valueGathered = BigInteger.ZERO;
        LinkedList<TransactionOutput> gathered = new LinkedList<TransactionOutput>();
        Set<Transaction> transactions = this.wallet.getTransactions(false, false);
        for (Transaction t : transactions) {
            for (TransactionOutput output : t.getOutputs()) {
                try {
                    Method isAvailableForSpending = TransactionOutput.class.getDeclaredMethod("isAvailableForSpending", null);
                    isAvailableForSpending.setAccessible(true);
                    boolean res = (Boolean)isAvailableForSpending.invoke((Object)output, null);
                    if (!res) {
                        continue;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
                if (!output.isMine(this.wallet)) continue;
                gathered.add(output);
                valueGathered = valueGathered.add(output.getValue());
            }
        }
        if (valueGathered.compareTo(satoshis) < 0) {
            throw new InsufficientFunds(satoshis.subtract(valueGathered));
        }
        assert (gathered.size() > 0);
        tx.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.NOT_SEEN_IN_CHAIN);
        BigInteger change = valueGathered.subtract(satoshis);
        if (change.compareTo(BigInteger.ZERO) > 0) {
            tx.addOutput(change, changeAddress);
        }
        for (TransactionOutput output : gathered) {
            tx.addInput(output);
        }
        try {
            tx.signInputs(Transaction.SigHash.ALL, this.wallet);
        }
        catch (ScriptException e) {
            System.out.println("Velky problem");
            throw new RuntimeException(e);
        }
        return true;
    }

    private BigInteger addDataPubKeyOutputs(Transaction tx, byte[] piece, BigInteger outputPrice) {
        BigInteger sumOutputPrice = BigInteger.ZERO;
        int embeddedLength = 65;
        for (int startByte = 0; startByte < piece.length; startByte += embeddedLength) {
            byte[] dataBytes = new byte[embeddedLength];
            int length = Math.min(embeddedLength, piece.length - startByte);
            System.arraycopy(piece, startByte, dataBytes, 0, length);
            byte[] scriptBytes = new byte[1 + embeddedLength + 1];
            scriptBytes[0] = (byte)embeddedLength;
            scriptBytes[66] = -84;
            System.arraycopy(dataBytes, 0, scriptBytes, 1, embeddedLength);
            tx.addOutput(new TransactionOutput(this.params, tx, outputPrice, scriptBytes));
            sumOutputPrice = sumOutputPrice.add(outputPrice);
        }
        return sumOutputPrice;
    }

    private BigInteger addDataScriptOutputs(Transaction tx, byte[] piece, BigInteger outputPrice, String outputAddress) throws IOException, AddressFormatException {
        int maxScriptLen = 9975;
        int maxItemLen = 520;
        int OP_DROP = 117;
        int OP_DUP = 118;
        int OP_HASH160 = 169;
        int OP_EQUALVERIFY = 136;
        int OP_CHECKSIG = 172;
        int OP_PUSHDATA1 = 76;
        int OP_PUSHDATA2 = 77;
        int OP_TRUE = 81;
        BigInteger sumOutputPrice = BigInteger.ZERO;
        int startByte = 0;
        while (startByte < piece.length) {
            ByteArrayOutputStream transactionOutputScript = new ByteArrayOutputStream();
            ByteArrayOutputStream subPiece = new ByteArrayOutputStream();
            while (startByte < piece.length) {
                int subPieceDataLength = Math.min(520, piece.length - startByte);
                byte[] subPieceData = new byte[subPieceDataLength];
                System.arraycopy(piece, startByte, subPieceData, 0, subPieceDataLength);
                if (subPieceDataLength < 256) {
                    subPiece.write(76);
                    subPiece.write(subPieceDataLength);
                } else {
                    subPiece.write(77);
                    subPiece.write(subPieceDataLength);
                    subPiece.write(subPieceDataLength >> 8);
                }
                subPiece.write(subPieceData);
                subPiece.write(117);
                if (transactionOutputScript.size() + subPiece.size() > 9975) break;
                transactionOutputScript.write(subPiece.toByteArray());
                startByte += subPieceDataLength;
            }
            if (!outputAddress.equals("")) {
                Address addr = new Address(this.params, outputAddress);
                transactionOutputScript.write(118);
                transactionOutputScript.write(169);
                transactionOutputScript.write(20);
                transactionOutputScript.write(addr.getHash160());
                transactionOutputScript.write(136);
                transactionOutputScript.write(172);
            } else {
                transactionOutputScript.write(81);
            }
            tx.addOutput(new TransactionOutput(this.params, tx, outputPrice, transactionOutputScript.toByteArray()));
            sumOutputPrice = sumOutputPrice.add(outputPrice);
        }
        return sumOutputPrice;
    }

    public void resendAllPendingTransactions() {
        Set<Transaction> transactions = this.wallet.getTransactions(false, false);
        for (Transaction transaction : transactions) {
            if (transaction.getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.NOT_SEEN_IN_CHAIN) continue;
            System.out.println("rebroadcasting " + transaction.getHashAsString());
            this.peerGroup.broadcastTransaction(transaction);
        }
    }

    public void resetTheWallet() {
        this.wallet.clearTransactions(0);
        try {
            this.wallet.saveToFile(this.walletFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

