/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AddressFormatException;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.VersionedChecksummedBytes;

public class Address
extends VersionedChecksummedBytes {
    public Address(NetworkParameters params, byte[] hash160) {
        super(params.addressHeader, hash160);
        if (hash160.length != 20) {
            throw new RuntimeException("Addresses are 160-bit hashes, so you must provide 20 bytes");
        }
    }

    public Address(NetworkParameters params, String address) throws AddressFormatException {
        super(address);
        if (this.version != params.addressHeader) {
            throw new AddressFormatException("Mismatched version number, trying to cross networks? " + this.version + " vs " + params.addressHeader);
        }
    }

    public byte[] getHash160() {
        return this.bytes;
    }
}

