/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.VarInt;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressMessage
extends Message {
    private static final long serialVersionUID = 8058283864924679460L;
    private static final long MAX_ADDRESSES = 1024L;
    private List<PeerAddress> addresses;
    private transient long numAddresses = -1L;

    AddressMessage(NetworkParameters params, byte[] payload, int offset, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, payload, offset, parseLazy, parseRetain, length);
    }

    AddressMessage(NetworkParameters params, byte[] payload, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, payload, 0, parseLazy, parseRetain, length);
    }

    AddressMessage(NetworkParameters params, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset, false, false, -1);
    }

    AddressMessage(NetworkParameters params, byte[] payload) throws ProtocolException {
        super(params, payload, 0, false, false, -1);
    }

    @Override
    protected void parseLite() throws ProtocolException {
    }

    @Override
    void parse() throws ProtocolException {
        this.numAddresses = this.readVarInt();
        if (this.numAddresses > 1024L) {
            throw new ProtocolException("Address message too large.");
        }
        this.addresses = new ArrayList<PeerAddress>((int)this.numAddresses);
        int i = 0;
        while ((long)i < this.numAddresses) {
            PeerAddress addr = new PeerAddress(this.params, this.bytes, this.cursor, this.protocolVersion, this, this.parseLazy, this.parseRetain);
            this.addresses.add(addr);
            this.cursor += addr.getMessageSize();
            ++i;
        }
        this.length = this.cursor - this.offset;
    }

    @Override
    void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        if (this.addresses == null) {
            return;
        }
        stream.write(new VarInt(this.addresses.size()).encode());
        for (PeerAddress addr : this.addresses) {
            addr.bitcoinSerialize(stream);
        }
    }

    @Override
    int getMessageSize() {
        if (this.length != -1) {
            return this.length;
        }
        if (this.addresses != null) {
            this.length = new VarInt(this.addresses.size()).getSizeInBytes();
            this.length += this.addresses.size() * (this.protocolVersion > 31402 ? 30 : 26);
        }
        return this.length;
    }

    @Override
    void setChecksum(byte[] checksum) {
        if (this.parseRetain) {
            super.setChecksum(checksum);
        } else {
            this.checksum = null;
        }
    }

    public List<PeerAddress> getAddresses() {
        this.maybeParse();
        return Collections.unmodifiableList(this.addresses);
    }

    public void addAddress(PeerAddress address) {
        this.unCache();
        this.maybeParse();
        address.setParent(this);
        this.addresses.add(address);
        if (this.length == -1) {
            this.getMessageSize();
        } else {
            this.length += address.getMessageSize();
        }
    }

    public void removeAddress(int index) {
        this.unCache();
        PeerAddress address = this.addresses.remove(index);
        if (address != null) {
            address.setParent(null);
        }
        if (this.length == -1) {
            this.getMessageSize();
        } else {
            this.length -= address.getMessageSize();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("addr: ");
        for (PeerAddress a : this.addresses) {
            builder.append(a.toString());
            builder.append(" ");
        }
        return builder.toString();
    }
}

