/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AddressFormatException;
import com.google.bitcoin.core.Utils;
import java.math.BigInteger;
import java.util.Arrays;

public class Base58 {
    private static final String ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final BigInteger BASE = BigInteger.valueOf(58L);

    public static String encode(byte[] input) {
        BigInteger bi = new BigInteger(1, input);
        StringBuffer s = new StringBuffer();
        while (bi.compareTo(BASE) >= 0) {
            BigInteger mod = bi.mod(BASE);
            s.insert(0, ALPHABET.charAt(mod.intValue()));
            bi = bi.subtract(mod).divide(BASE);
        }
        s.insert(0, ALPHABET.charAt(bi.intValue()));
        for (byte anInput : input) {
            if (anInput != 0) break;
            s.insert(0, ALPHABET.charAt(0));
        }
        return s.toString();
    }

    public static byte[] decode(String input) throws AddressFormatException {
        byte[] bytes = Base58.decodeToBigInteger(input).toByteArray();
        boolean stripSignByte = bytes.length > 1 && bytes[0] == 0 && bytes[1] < 0;
        int leadingZeros = 0;
        int i = 0;
        while (input.charAt(i) == ALPHABET.charAt(0)) {
            ++leadingZeros;
            ++i;
        }
        byte[] tmp = new byte[bytes.length - (stripSignByte ? 1 : 0) + leadingZeros];
        System.arraycopy(bytes, stripSignByte ? 1 : 0, tmp, leadingZeros, tmp.length - leadingZeros);
        return tmp;
    }

    public static BigInteger decodeToBigInteger(String input) throws AddressFormatException {
        BigInteger bi = BigInteger.valueOf(0L);
        for (int i = input.length() - 1; i >= 0; --i) {
            int alphaIndex = ALPHABET.indexOf(input.charAt(i));
            if (alphaIndex == -1) {
                throw new AddressFormatException("Illegal character " + input.charAt(i) + " at " + i);
            }
            bi = bi.add(BigInteger.valueOf(alphaIndex).multiply(BASE.pow(input.length() - 1 - i)));
        }
        return bi;
    }

    public static byte[] decodeChecked(String input) throws AddressFormatException {
        byte[] tmp = Base58.decode(input);
        if (tmp.length < 4) {
            throw new AddressFormatException("Input too short");
        }
        byte[] checksum = new byte[4];
        System.arraycopy(tmp, tmp.length - 4, checksum, 0, 4);
        byte[] bytes = new byte[tmp.length - 4];
        System.arraycopy(tmp, 0, bytes, 0, tmp.length - 4);
        tmp = Utils.doubleDigest(bytes);
        byte[] hash = new byte[4];
        System.arraycopy(tmp, 0, hash, 0, 4);
        if (!Arrays.equals(hash, checksum)) {
            throw new AddressFormatException("Checksum does not validate");
        }
        return bytes;
    }
}

