/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AbstractPeerEventListener;
import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.Peer;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.Semaphore;

public class DownloadListener
extends AbstractPeerEventListener {
    private int originalBlocksLeft = -1;
    private int lastPercent = 0;
    private Semaphore done = new Semaphore(0);

    public void onChainDownloadStarted(Peer peer, int blocksLeft) {
        this.startDownload(blocksLeft);
        this.originalBlocksLeft = blocksLeft;
        if (blocksLeft == 0) {
            this.doneDownload();
            this.done.release();
        }
    }

    public void onBlocksDownloaded(Peer peer, Block block, int blocksLeft) {
        if (blocksLeft == 0) {
            this.doneDownload();
            this.done.release();
        }
        if (blocksLeft < 0 || this.originalBlocksLeft <= 0) {
            return;
        }
        double pct = 100.0 - 100.0 * ((double)blocksLeft / (double)this.originalBlocksLeft);
        if ((int)pct != this.lastPercent) {
            this.progress(pct, blocksLeft, new Date(block.getTimeSeconds() * 1000L));
            this.lastPercent = (int)pct;
        }
    }

    protected void progress(double pct, int blocksSoFar, Date date) {
        System.out.println(String.format("Chain download %d%% done with %d blocks to go, block date %s", (int)pct, blocksSoFar, DateFormat.getDateTimeInstance().format(date)));
    }

    protected void startDownload(int blocks) {
        System.out.println("Downloading block chain of size " + blocks + ". " + (blocks > 1000 ? "This may take a while." : ""));
    }

    protected void doneDownload() {
        System.out.println("Done downloading block chain");
    }

    public void await() throws InterruptedException {
        this.done.acquire();
    }
}

