/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.DumpedPrivateKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.UnsafeByteArrayOutputStream;
import com.google.bitcoin.core.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;

public class ECKey
implements Serializable {
    private static final ECDomainParameters ecParams;
    private static final SecureRandom secureRandom;
    private static final long serialVersionUID = -728224901792295832L;
    private BigInteger priv;
    private byte[] pub;
    private long creationTimeSeconds;
    private transient byte[] pubKeyHash;

    public ECKey() {
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters keygenParams = new ECKeyGenerationParameters(ecParams, secureRandom);
        generator.init((KeyGenerationParameters)keygenParams);
        AsymmetricCipherKeyPair keypair = generator.generateKeyPair();
        ECPrivateKeyParameters privParams = (ECPrivateKeyParameters)keypair.getPrivate();
        ECPublicKeyParameters pubParams = (ECPublicKeyParameters)keypair.getPublic();
        this.priv = privParams.getD();
        this.pub = pubParams.getQ().getEncoded();
        this.creationTimeSeconds = Utils.now().getTime() / 1000L;
    }

    public static ECKey fromASN1(byte[] asn1privkey) {
        return new ECKey(ECKey.extractPrivateKeyFromASN1(asn1privkey));
    }

    public byte[] toASN1() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(400);
            ASN1OutputStream encoder = new ASN1OutputStream((OutputStream)baos);
            DERSequenceGenerator seq = new DERSequenceGenerator((OutputStream)encoder);
            seq.addObject((DEREncodable)new DERInteger(1));
            seq.addObject((DEREncodable)new DEROctetString(this.priv.toByteArray()));
            seq.addObject((DEREncodable)new DERTaggedObject(0, (DEREncodable)SECNamedCurves.getByName((String)"secp256k1").getDERObject()));
            seq.addObject((DEREncodable)new DERTaggedObject(1, (DEREncodable)new DERBitString(this.getPubKey())));
            seq.close();
            encoder.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ECKey(BigInteger privKey, byte[] pubKey) {
        this.priv = privKey;
        this.pub = null;
        if (pubKey == null && privKey != null) {
            this.pub = ECKey.publicKeyFromPrivate(privKey);
        } else if (pubKey != null) {
            this.pub = pubKey;
        }
    }

    public ECKey(BigInteger privKey) {
        this(privKey, (byte[])null);
    }

    public ECKey(BigInteger privKey, BigInteger pubKey) {
        this(privKey, Utils.bigIntegerToBytes(pubKey, 65));
    }

    public ECKey(byte[] privKeyBytes, byte[] pubKey) {
        this(privKeyBytes == null ? null : new BigInteger(1, privKeyBytes), pubKey);
    }

    public static byte[] publicKeyFromPrivate(BigInteger privKey) {
        return ecParams.getG().multiply(privKey).getEncoded();
    }

    public byte[] getPubKeyHash() {
        if (this.pubKeyHash == null) {
            this.pubKeyHash = Utils.sha256hash160(this.pub);
        }
        return this.pubKeyHash;
    }

    public byte[] getPubKey() {
        return this.pub;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("pub:").append(Utils.bytesToHexString(this.pub));
        if (this.creationTimeSeconds != 0L) {
            b.append(" timestamp:" + this.creationTimeSeconds);
        }
        return b.toString();
    }

    public String toStringWithPrivate() {
        StringBuffer b = new StringBuffer();
        b.append(this.toString());
        if (this.priv != null) {
            b.append(" priv:").append(Utils.bytesToHexString(this.priv.toByteArray()));
        }
        return b.toString();
    }

    public Address toAddress(NetworkParameters params) {
        byte[] hash160 = Utils.sha256hash160(this.pub);
        return new Address(params, hash160);
    }

    public byte[] sign(byte[] input) {
        if (this.priv == null) {
            throw new IllegalStateException("This ECKey does not have the private key necessary for signing.");
        }
        ECDSASigner signer = new ECDSASigner();
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(this.priv, ecParams);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] sigs = signer.generateSignature(input);
        try {
            UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(72);
            DERSequenceGenerator seq = new DERSequenceGenerator((OutputStream)bos);
            seq.addObject((DEREncodable)new DERInteger(sigs[0]));
            seq.addObject((DEREncodable)new DERInteger(sigs[1]));
            seq.close();
            return ((ByteArrayOutputStream)bos).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verify(byte[] data, byte[] signature, byte[] pub) {
        ECDSASigner signer = new ECDSASigner();
        ECPublicKeyParameters params = new ECPublicKeyParameters(ecParams.getCurve().decodePoint(pub), ecParams);
        signer.init(false, (CipherParameters)params);
        try {
            ASN1InputStream decoder = new ASN1InputStream(signature);
            DERSequence seq = (DERSequence)decoder.readObject();
            DERInteger r = (DERInteger)seq.getObjectAt(0);
            DERInteger s = (DERInteger)seq.getObjectAt(1);
            decoder.close();
            return signer.verifySignature(data, r.getValue(), s.getValue());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean verify(byte[] data, byte[] signature) {
        return ECKey.verify(data, signature, this.pub);
    }

    private static BigInteger extractPrivateKeyFromASN1(byte[] asn1privkey) {
        try {
            ASN1InputStream decoder = new ASN1InputStream(asn1privkey);
            DERSequence seq = (DERSequence)decoder.readObject();
            assert (seq.size() == 4) : "Input does not appear to be an ASN.1 OpenSSL EC private key";
            assert (((DERInteger)seq.getObjectAt(0)).getValue().equals(BigInteger.ONE)) : "Input is of wrong version";
            DEROctetString key = (DEROctetString)seq.getObjectAt(1);
            decoder.close();
            return new BigInteger(key.getOctets());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getPrivKeyBytes() {
        return Utils.bigIntegerToBytes(this.priv, 32);
    }

    public DumpedPrivateKey getPrivateKeyEncoded(NetworkParameters params) {
        return new DumpedPrivateKey(params, this.getPrivKeyBytes());
    }

    public long getCreationTimeSeconds() {
        return this.creationTimeSeconds;
    }

    public void setCreationTimeSeconds(long newCreationTimeSeconds) {
        if (newCreationTimeSeconds < 0L) {
            throw new IllegalArgumentException("Cannot set creation time to negative value: " + newCreationTimeSeconds);
        }
        this.creationTimeSeconds = newCreationTimeSeconds;
    }

    static {
        X9ECParameters params = SECNamedCurves.getByName((String)"secp256k1");
        ecParams = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH());
        secureRandom = new SecureRandom();
    }
}

