/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.Script;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.TransactionOutput;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.bouncycastle.util.encoders.Hex;

public class NetworkParameters
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final int PROTOCOL_VERSION = 31800;
    public static final byte[] SATOSHI_KEY = Hex.decode((String)"04fc9702847840aaf195de8442ebecedf5b095cdbb9bc716bda9110971b28a49e0ead8564ff0db22209e0374782c093bb899692d524e9d6a6956e7c5ecbcd68284");
    public static final String ID_PRODNET = "org.bitcoin.production";
    public static final String ID_TESTNET = "org.bitcoin.test";
    public Block genesisBlock;
    public BigInteger proofOfWorkLimit;
    public int port;
    public long packetMagic;
    public int addressHeader;
    public int dumpedPrivateKeyHeader;
    public int interval;
    public int targetTimespan;
    public byte[] alertSigningKey;
    private String id;
    private static final int TARGET_TIMESPAN = 1209600;
    private static final int TARGET_SPACING = 600;
    private static final int INTERVAL = 2016;

    private static Block createGenesis(NetworkParameters n) {
        Block genesisBlock = new Block(n);
        Transaction t = new Transaction(n);
        try {
            byte[] bytes = Hex.decode((String)"04ffff001d0104455468652054696d65732030332f4a616e2f32303039204368616e63656c6c6f72206f6e206272696e6b206f66207365636f6e64206261696c6f757420666f722062616e6b73");
            t.addInput(new TransactionInput(n, t, bytes));
            ByteArrayOutputStream scriptPubKeyBytes = new ByteArrayOutputStream();
            Script.writeBytes(scriptPubKeyBytes, Hex.decode((String)"04678afdb0fe5548271967f1a67130b7105cd6a828e03909a67962e0ea1f61deb649f6bc3f4cef38c4f35504e51ec112de5c384df7ba0b8d578a4c702b6bf11d5f"));
            scriptPubKeyBytes.write(172);
            t.addOutput(new TransactionOutput(n, t, scriptPubKeyBytes.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        genesisBlock.addTransaction(t);
        return genesisBlock;
    }

    private static NetworkParameters createTestNet(NetworkParameters n) {
        n.proofOfWorkLimit = new BigInteger("0000000fffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
        n.packetMagic = 4206867930L;
        n.port = 18333;
        n.addressHeader = 111;
        n.dumpedPrivateKeyHeader = 239;
        n.interval = 2016;
        n.targetTimespan = 1209600;
        n.alertSigningKey = SATOSHI_KEY;
        n.genesisBlock = NetworkParameters.createGenesis(n);
        n.genesisBlock.setTime(1296688602L);
        n.genesisBlock.setDifficultyTarget(487063544L);
        n.genesisBlock.setNonce(384568319L);
        n.id = ID_TESTNET;
        String genesisHash = n.genesisBlock.getHashAsString();
        assert (genesisHash.equals("00000007199508e34a9ff81e6ec0c477a4cccff2a4767a8eee39c11db367b008")) : genesisHash;
        return n;
    }

    public static NetworkParameters testNet() {
        NetworkParameters n = new NetworkParameters();
        return NetworkParameters.createTestNet(n);
    }

    public static NetworkParameters prodNet() {
        NetworkParameters n = new NetworkParameters();
        n.proofOfWorkLimit = new BigInteger("00000000ffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
        n.port = 8333;
        n.packetMagic = 4190024921L;
        n.addressHeader = 0;
        n.dumpedPrivateKeyHeader = 128;
        n.interval = 2016;
        n.targetTimespan = 1209600;
        n.alertSigningKey = SATOSHI_KEY;
        n.genesisBlock = NetworkParameters.createGenesis(n);
        n.genesisBlock.setDifficultyTarget(486604799L);
        n.genesisBlock.setTime(1231006505L);
        n.genesisBlock.setNonce(2083236893L);
        n.id = ID_PRODNET;
        String genesisHash = n.genesisBlock.getHashAsString();
        assert (genesisHash.equals("000000000019d6689c085ae165831e934ff763ae46a2a6c172b3f1b60a8ce26f")) : genesisHash;
        return n;
    }

    public static NetworkParameters unitTests() {
        NetworkParameters n = new NetworkParameters();
        n = NetworkParameters.createTestNet(n);
        n.proofOfWorkLimit = new BigInteger("00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
        n.genesisBlock.setNonce(2L);
        n.genesisBlock.setDifficultyTarget(545259519L);
        n.interval = 10;
        n.targetTimespan = 200000000;
        n.id = "com.google.bitcoin.unittest";
        return n;
    }

    public String getId() {
        if (this.id == null) {
            if (this.port == 8333) {
                this.id = ID_PRODNET;
            } else if (this.port == 18333) {
                this.id = ID_TESTNET;
            }
        }
        return this.id;
    }
}

