/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AddressMessage;
import com.google.bitcoin.core.AlertMessage;
import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.GetBlocksMessage;
import com.google.bitcoin.core.GetDataMessage;
import com.google.bitcoin.core.GetHeadersMessage;
import com.google.bitcoin.core.HeadersMessage;
import com.google.bitcoin.core.InventoryItem;
import com.google.bitcoin.core.InventoryMessage;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkConnection;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerEventListener;
import com.google.bitcoin.core.PeerException;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.TCPNetworkConnection;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.VersionMessage;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.utils.EventListenerInvoker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Peer {
    private static final Logger log = LoggerFactory.getLogger(Peer.class);
    public static final int CONNECT_TIMEOUT_MSEC = 60000;
    private NetworkConnection conn;
    private final NetworkParameters params;
    private boolean running;
    private final BlockChain blockChain;
    private final List<GetDataFuture<Block>> pendingGetBlockFutures;
    private int bestHeight;
    private PeerAddress address;
    private List<PeerEventListener> eventListeners;
    private boolean downloadData = true;
    private VersionMessage versionMessage;
    public static int TRANSACTION_MEMORY_POOL_SIZE = 1000;
    private LinkedHashMap<Sha256Hash, Transaction> announcedTransactionHashes = new LinkedHashMap<Sha256Hash, Transaction>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Sha256Hash, Transaction> sha256HashTransactionEntry) {
            return this.size() > TRANSACTION_MEMORY_POOL_SIZE;
        }
    };
    private long fastCatchupTimeSecs;
    private boolean downloadBlockBodies = true;

    public Peer(NetworkParameters params, PeerAddress address, int bestHeight, BlockChain blockChain) {
        this(params, address, blockChain, new VersionMessage(params, bestHeight));
    }

    public Peer(NetworkParameters params, PeerAddress address, BlockChain blockChain, VersionMessage ver) {
        this.params = params;
        this.address = address;
        this.blockChain = blockChain;
        this.pendingGetBlockFutures = new ArrayList<GetDataFuture<Block>>();
        this.eventListeners = new ArrayList<PeerEventListener>();
        this.fastCatchupTimeSecs = params.genesisBlock.getTimeSeconds();
        this.versionMessage = ver;
    }

    public Peer(NetworkParameters params, PeerAddress address, BlockChain blockChain) {
        this(params, address, 0, blockChain);
    }

    public Peer(NetworkParameters params, BlockChain blockChain, NetworkConnection connection) {
        this(params, null, 0, blockChain);
        this.conn = connection;
        this.address = connection.getPeerAddress();
    }

    public synchronized void addEventListener(PeerEventListener listener) {
        this.eventListeners.add(listener);
    }

    public synchronized boolean removeEventListener(PeerEventListener listener) {
        return this.eventListeners.remove(listener);
    }

    public String toString() {
        if (this.address == null) {
            return "Peer(NetworkConnection:" + this.conn + ")";
        }
        return "Peer(" + this.address.getAddr() + ":" + this.address.getPort() + ")";
    }

    public synchronized void connect() throws PeerException {
        try {
            this.conn = new TCPNetworkConnection(this.address, this.params, 60000, false, this.versionMessage);
        }
        catch (IOException ex) {
            throw new PeerException(ex);
        }
        catch (ProtocolException ex) {
            throw new PeerException(ex);
        }
    }

    void setConnection(NetworkConnection conn) {
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws PeerException {
        if (this.conn == null) {
            throw new RuntimeException("please call connect() first");
        }
        this.running = true;
        try {
            while (true) {
                Message m = this.conn.readMessage();
                Iterator<PeerEventListener> i$ = this.eventListeners.iterator();
                while (i$.hasNext()) {
                    PeerEventListener listener;
                    PeerEventListener peerEventListener = listener = i$.next();
                    synchronized (peerEventListener) {
                        m = listener.onPreMessageReceived(this, m);
                        if (m == null) {
                            break;
                        }
                    }
                }
                if (m == null) continue;
                if (m instanceof InventoryMessage) {
                    this.processInv((InventoryMessage)m);
                    continue;
                }
                if (m instanceof Block) {
                    this.processBlock((Block)m);
                    continue;
                }
                if (m instanceof Transaction) {
                    this.processTransaction((Transaction)m);
                    continue;
                }
                if (m instanceof GetDataMessage) {
                    this.processGetData((GetDataMessage)m);
                    continue;
                }
                if (m instanceof AddressMessage) continue;
                if (m instanceof HeadersMessage) {
                    this.processHeaders((HeadersMessage)m);
                    continue;
                }
                if (m instanceof AlertMessage) {
                    this.processAlert((AlertMessage)m);
                    continue;
                }
                log.warn("Received unhandled message: {}", (Object)m);
            }
        }
        catch (IOException e) {
            if (!this.running) {
                log.info("Shutting down peer loop");
            }
            this.disconnect();
            throw new PeerException(e);
        }
        catch (ProtocolException e) {
            this.disconnect();
            throw new PeerException(e);
        }
        catch (RuntimeException e) {
            this.disconnect();
            log.error("unexpected exception in peer loop: ", (Object)e.getMessage());
            throw e;
        }
        this.disconnect();
    }

    private void processAlert(AlertMessage m) {
        if (m.isSignatureValid()) {
            log.info("Received alert from peer {}: {}", (Object)this.toString(), (Object)m.getStatusBar());
        } else {
            log.warn("Received alert with invalid signature from peer {}: {}", (Object)this.toString(), (Object)m.getStatusBar());
        }
    }

    private void processHeaders(HeadersMessage m) throws IOException, ProtocolException {
        assert (!this.downloadBlockBodies);
        try {
            for (int i = 0; i < m.getBlockHeaders().size(); ++i) {
                Block header = m.getBlockHeaders().get(i);
                if (header.getTimeSeconds() < this.fastCatchupTimeSecs) {
                    if (!this.blockChain.add(header)) {
                        throw new ProtocolException("Got unconnected header from peer: " + header.getHashAsString());
                    }
                } else {
                    log.info("Passed the fast catchup time, discarding {} headers and requesting full blocks", (Object)(m.getBlockHeaders().size() - i));
                    this.downloadBlockBodies = true;
                    this.blockChainDownload(header.getHash());
                    return;
                }
                this.invokeOnBlocksDownloaded(header);
            }
            this.blockChainDownload(Sha256Hash.ZERO_HASH);
        }
        catch (VerificationException e) {
            log.warn("Block header verification failed", (Throwable)e);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGetData(GetDataMessage getdata) throws IOException {
        log.info("Received getdata message: {}", (Object)getdata.toString());
        ArrayList<Message> items = new ArrayList<Message>();
        Iterator<PeerEventListener> i$ = this.eventListeners.iterator();
        while (i$.hasNext()) {
            PeerEventListener listener;
            PeerEventListener peerEventListener = listener = i$.next();
            synchronized (peerEventListener) {
                List<Message> listenerItems = listener.getData(this, getdata);
                if (listenerItems == null) {
                    continue;
                }
                items.addAll(listenerItems);
            }
        }
        if (items.size() == 0) {
            return;
        }
        log.info("Sending {} items gathered from listeners to peer", (Object)items.size());
        for (Message item : items) {
            this.sendMessage(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransaction(Transaction m) {
        log.info("Received broadcast tx {}", (Object)m.getHashAsString());
        Iterator<PeerEventListener> i$ = this.eventListeners.iterator();
        while (i$.hasNext()) {
            PeerEventListener listener;
            PeerEventListener peerEventListener = listener = i$.next();
            synchronized (peerEventListener) {
                listener.onTransaction(this, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBlock(Block m) throws IOException {
        log.trace("Received broadcast block {}", (Object)m.getHashAsString());
        try {
            List<GetDataFuture<Block>> list = this.pendingGetBlockFutures;
            synchronized (list) {
                for (int i = 0; i < this.pendingGetBlockFutures.size(); ++i) {
                    GetDataFuture<Block> f = this.pendingGetBlockFutures.get(i);
                    if (!f.getItem().hash.equals(m.getHash())) continue;
                    f.setResult(m);
                    this.pendingGetBlockFutures.remove(i);
                    return;
                }
            }
            if (this.blockChain.add(m)) {
                this.invokeOnBlocksDownloaded(m);
            } else {
                this.blockChainDownload(m.getHash());
            }
        }
        catch (VerificationException e) {
            log.warn("Block verification failed", (Throwable)e);
        }
        catch (ScriptException e) {
            log.warn("Script exception", (Throwable)e);
        }
    }

    private void invokeOnBlocksDownloaded(final Block m) {
        final int blocksLeft = Math.max(0, this.getPeerBlockHeightDifference());
        EventListenerInvoker.invoke(this.eventListeners, new EventListenerInvoker<PeerEventListener>(){

            @Override
            public void invoke(PeerEventListener listener) {
                listener.onBlocksDownloaded(Peer.this, m, blocksLeft);
            }
        });
    }

    private void processInv(InventoryMessage inv) throws IOException {
        Sha256Hash topHash;
        List<InventoryItem> items = inv.getItems();
        this.updateTransactionConfidenceLevels(items);
        if (!this.downloadData) {
            return;
        }
        Block topBlock = this.blockChain.getUnconnectedBlock();
        Sha256Hash sha256Hash = topHash = topBlock != null ? topBlock.getHash() : null;
        if (this.isNewBlockTickle(topHash, items)) {
            this.blockChainDownload(topHash);
            return;
        }
        GetDataMessage getdata = new GetDataMessage(this.params);
        for (InventoryItem item : items) {
            getdata.addItem(item);
        }
        this.conn.writeMessage(getdata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransactionConfidenceLevels(List<InventoryItem> items) {
        LinkedHashMap<Sha256Hash, Transaction> linkedHashMap = this.announcedTransactionHashes;
        synchronized (linkedHashMap) {
            for (InventoryItem item : items) {
                if (item.type != InventoryItem.Type.Transaction) continue;
                Transaction transaction = this.announcedTransactionHashes.get(item.hash);
                if (transaction == null) {
                    log.debug("Newly announced undownloaded transaction ", (Object)item.hash);
                    this.announcedTransactionHashes.put(item.hash, null);
                    continue;
                }
                log.debug("Marking tx {} as seen by {}", (Object)item.hash, (Object)this.toString());
                transaction.getConfidence().markBroadcastBy(this.address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackTransaction(Transaction tx) {
        LinkedHashMap<Sha256Hash, Transaction> linkedHashMap = this.announcedTransactionHashes;
        synchronized (linkedHashMap) {
            if (this.announcedTransactionHashes.containsKey(tx.getHash())) {
                Transaction storedTx = this.announcedTransactionHashes.get(tx.getHash());
                assert (storedTx == tx || storedTx == null) : "single Transaction instance";
                log.debug("Provided with a downloaded transaction we have seen before: {}", (Object)tx.getHash());
                tx.getConfidence().markBroadcastBy(this.address);
            } else {
                log.debug("Provided with a downloaded transaction we didn't see broadcast yet: {}", (Object)tx.getHash());
            }
            this.announcedTransactionHashes.put(tx.getHash(), tx);
        }
    }

    private boolean isNewBlockTickle(Sha256Hash topHash, List<InventoryItem> items) {
        return items.size() == 1 && items.get((int)0).type == InventoryItem.Type.Block && topHash != null && items.get((int)0).hash.equals(topHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Block> getBlock(Sha256Hash blockHash) throws IOException {
        GetDataMessage getdata = new GetDataMessage(this.params);
        InventoryItem inventoryItem = new InventoryItem(InventoryItem.Type.Block, blockHash);
        getdata.addItem(inventoryItem);
        GetDataFuture<Block> future = new GetDataFuture<Block>(inventoryItem);
        List<GetDataFuture<Block>> list = this.pendingGetBlockFutures;
        synchronized (list) {
            this.pendingGetBlockFutures.add(future);
        }
        this.conn.writeMessage(getdata);
        return future;
    }

    public void setFastCatchupTime(long secondsSinceEpoch) {
        if (secondsSinceEpoch == 0L) {
            this.fastCatchupTimeSecs = this.params.genesisBlock.getTimeSeconds();
            this.downloadBlockBodies = true;
        } else {
            this.fastCatchupTimeSecs = secondsSinceEpoch;
            if (this.fastCatchupTimeSecs > this.blockChain.getChainHead().getHeader().getTimeSeconds()) {
                this.downloadBlockBodies = false;
            }
        }
    }

    public void addWallet(Wallet wallet) {
        this.addEventListener(wallet.getPeerEventListener());
    }

    public void removeWallet(Wallet wallet) {
        this.removeEventListener(wallet.getPeerEventListener());
    }

    public void sendMessage(Message m) throws IOException {
        this.conn.writeMessage(m);
    }

    private void blockChainDownload(Sha256Hash toHash) throws IOException {
        log.info("blockChainDownload({})", (Object)toHash.toString());
        ArrayList<Sha256Hash> blockLocator = new ArrayList<Sha256Hash>(51);
        BlockStore store = this.blockChain.getBlockStore();
        StoredBlock cursor = this.blockChain.getChainHead();
        for (int i = 50; cursor != null && i > 0; cursor = cursor.getPrev(store), --i) {
            blockLocator.add(cursor.getHeader().getHash());
            try {
                continue;
            }
            catch (BlockStoreException e) {
                log.error("Failed to walk the block chain whilst constructing a locator");
                throw new RuntimeException(e);
            }
        }
        if (cursor != null) {
            blockLocator.add(this.params.genesisBlock.getHash());
        }
        if (this.downloadBlockBodies) {
            GetBlocksMessage message = new GetBlocksMessage(this.params, blockLocator, toHash);
            this.conn.writeMessage(message);
        } else {
            GetHeadersMessage message = new GetHeadersMessage(this.params, blockLocator, toHash);
            this.conn.writeMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlockChainDownload() throws IOException {
        this.setDownloadData(true);
        if (this.getPeerBlockHeightDifference() >= 0) {
            Iterator<PeerEventListener> i$ = this.eventListeners.iterator();
            while (i$.hasNext()) {
                PeerEventListener listener;
                PeerEventListener peerEventListener = listener = i$.next();
                synchronized (peerEventListener) {
                    listener.onChainDownloadStarted(this, this.getPeerBlockHeightDifference());
                }
            }
            this.blockChainDownload(Sha256Hash.ZERO_HASH);
        }
    }

    public int getPeerBlockHeightDifference() {
        int chainHeight = (int)this.conn.getVersionMessage().bestHeight;
        if (chainHeight <= 0) {
            throw new RuntimeException("Connected to peer advertising negative chain height.");
        }
        return chainHeight - this.blockChain.getChainHead().getHeight();
    }

    public synchronized void disconnect() {
        this.running = false;
        try {
            if (this.conn != null) {
                this.conn.shutdown();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean getDownloadData() {
        return this.downloadData;
    }

    public void setDownloadData(boolean downloadData) {
        this.downloadData = downloadData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetDataFuture<T extends Message>
    implements Future<T> {
        private boolean cancelled;
        private final InventoryItem item;
        private final CountDownLatch latch;
        private T result;

        GetDataFuture(InventoryItem item) {
            this.item = item;
            this.latch = new CountDownLatch(1);
        }

        @Override
        public boolean cancel(boolean b) {
            this.cancelled = true;
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.result != null || this.cancelled;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.latch.await();
            assert (this.result != null);
            return this.result;
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.latch.await(l, timeUnit)) {
                throw new TimeoutException();
            }
            assert (this.result != null);
            return this.result;
        }

        InventoryItem getItem() {
            return this.item;
        }

        void setResult(T result) {
            this.result = result;
            this.latch.countDown();
        }
    }
}

