/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AbstractPeerEventListener;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.DownloadListener;
import com.google.bitcoin.core.GetDataMessage;
import com.google.bitcoin.core.InventoryItem;
import com.google.bitcoin.core.InventoryMessage;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Peer;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerEventListener;
import com.google.bitcoin.core.PeerException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VersionMessage;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.discovery.PeerDiscovery;
import com.google.bitcoin.discovery.PeerDiscoveryException;
import com.google.bitcoin.utils.EventListenerInvoker;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerGroup {
    private static final int DEFAULT_CONNECTIONS = 4;
    private static final Logger log = LoggerFactory.getLogger(PeerGroup.class);
    public static final int DEFAULT_CONNECTION_DELAY_MILLIS = 5000;
    private static final int THREAD_KEEP_ALIVE_SECONDS = 1;
    private BlockingQueue<PeerAddress> inactives;
    private PeerGroupThread peerGroupThread;
    private boolean running;
    private ThreadPoolExecutor peerPool;
    private Set<Peer> peers;
    private Peer downloadPeer;
    private PeerEventListener downloadListener;
    private List<PeerEventListener> peerEventListeners;
    private Set<PeerDiscovery> peerDiscoverers;
    private VersionMessage versionMessage;
    private NetworkParameters params;
    private BlockChain chain;
    private int connectionDelayMillis;
    private long fastCatchupTimeSecs;
    private ArrayList<Wallet> wallets;
    private AbstractPeerEventListener getDataListener;

    public PeerGroup(NetworkParameters params, BlockChain chain) {
        this(params, chain, 5000);
    }

    public PeerGroup(NetworkParameters params, BlockChain chain, int connectionDelayMillis) {
        this.params = params;
        this.chain = chain;
        this.connectionDelayMillis = connectionDelayMillis;
        this.fastCatchupTimeSecs = params.genesisBlock.getTimeSeconds();
        this.wallets = new ArrayList(1);
        this.versionMessage = new VersionMessage(params, chain.getBestChainHeight());
        this.inactives = new LinkedBlockingQueue<PeerAddress>();
        this.peers = Collections.synchronizedSet(new HashSet());
        this.peerDiscoverers = new CopyOnWriteArraySet<PeerDiscovery>();
        this.peerPool = new ThreadPoolExecutor(4, 4, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new PeerGroupThreadFactory());
        this.peerEventListeners = new ArrayList<PeerEventListener>();
        this.addEventListener(new AbstractPeerEventListener(){

            public void onTransaction(Peer peer, Transaction t) {
                PeerGroup.this.handleBroadcastTransaction(t);
            }
        });
        this.getDataListener = new AbstractPeerEventListener(){

            @Override
            public List<Message> getData(Peer peer, GetDataMessage m) {
                return PeerGroup.this.handleGetData(m);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<Message> handleGetData(GetDataMessage m) {
        HashMap<Sha256Hash, Transaction> transactions = new HashMap<Sha256Hash, Transaction>();
        Iterator<Wallet> i$ = this.wallets.iterator();
        while (i$.hasNext()) {
            Wallet w;
            Wallet wallet = w = i$.next();
            synchronized (wallet) {
                for (InventoryItem item : m.getItems()) {
                    Transaction tx = w.getTransaction(item.hash);
                    if (tx == null) continue;
                    transactions.put(tx.getHash(), tx);
                }
            }
        }
        return new LinkedList<Message>(transactions.values());
    }

    private synchronized void handleBroadcastTransaction(Transaction tx) {
        for (Peer p : this.peers) {
            p.trackTransaction(tx);
        }
    }

    public synchronized void setVersionMessage(VersionMessage ver) {
        this.versionMessage = ver;
    }

    public synchronized VersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    public void setUserAgent(String name, String version, String comments) {
        VersionMessage ver = new VersionMessage(this.params, 0);
        ver.appendToSubVer(name, version, comments);
        this.setVersionMessage(ver);
    }

    public void setUserAgent(String name, String version) {
        this.setUserAgent(name, version, null);
    }

    public synchronized void addEventListener(PeerEventListener listener) {
        assert (listener != null);
        this.peerEventListeners.add(listener);
    }

    public synchronized boolean removeEventListener(PeerEventListener listener) {
        return this.peerEventListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeer(Peer peer) {
        PeerGroup peerGroup = this;
        synchronized (peerGroup) {
            if (!this.running) {
                throw new IllegalStateException("Must call start() before adding peers.");
            }
            log.info("Adding directly to group: {}", (Object)peer);
        }
        this.executePeer(null, peer, false, ExecuteBlockMode.WAIT_FOR_STARTUP);
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.peerPool.setCorePoolSize(Math.min(maxConnections, 4));
        this.peerPool.setMaximumPoolSize(maxConnections);
    }

    public synchronized int getMaxConnections() {
        return this.peerPool.getMaximumPoolSize();
    }

    public synchronized List<Peer> getConnectedPeers() {
        ArrayList<Peer> result = new ArrayList<Peer>(this.peers.size());
        result.addAll(this.peers);
        return result;
    }

    public void addAddress(PeerAddress peerAddress) {
        this.inactives.add(peerAddress);
    }

    public void addPeerDiscovery(PeerDiscovery peerDiscovery) {
        this.peerDiscoverers.add(peerDiscovery);
    }

    public synchronized void start() {
        this.peerGroupThread = new PeerGroupThread();
        this.running = true;
        this.peerGroupThread.start();
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            this.peerGroupThread.interrupt();
        }
    }

    public Future<Transaction> broadcastTransaction(final Transaction tx) {
        FutureTask<Transaction> future = new FutureTask<Transaction>(new Runnable(){

            public void run() {
                for (Peer peer : PeerGroup.this.peers) {
                    try {
                        peer.sendMessage(tx);
                    }
                    catch (IOException e) {
                        log.warn("Caught IOException whilst sending transaction: {}", (Object)e.getMessage());
                    }
                }
            }
        }, tx);
        this.peerGroupThread.addTask(future);
        return future;
    }

    public synchronized void addWallet(Wallet wallet) {
        if (wallet == null) {
            throw new IllegalArgumentException("wallet is null");
        }
        this.wallets.add(wallet);
        this.addEventListener(wallet.getPeerEventListener());
        this.announcePendingWalletTransactions(Collections.singletonList(wallet), this.peers);
    }

    public void removeWallet(Wallet wallet) {
        if (wallet == null) {
            throw new IllegalArgumentException("wallet is null");
        }
        this.wallets.remove(wallet);
        this.removeEventListener(wallet.getPeerEventListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int numConnectedPeers() {
        Set<Peer> set = this.peers;
        synchronized (set) {
            return this.peers.size();
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private void executePeer(final PeerAddress address, final Peer peer, final boolean shouldConnect, final ExecuteBlockMode blockUntilRunning) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.peerPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    try {
                        if (shouldConnect) {
                            log.info("Connecting to " + peer);
                            peer.connect();
                        }
                        PeerGroup peerGroup = PeerGroup.this;
                        // MONITORENTER : peerGroup
                        if (!PeerGroup.this.running) {
                            peer.disconnect();
                            // MONITOREXIT : peerGroup
                            Object var4_3 = null;
                            PeerGroup peerGroup2 = PeerGroup.this;
                            // MONITORENTER : peerGroup2
                            if (!PeerGroup.this.running) {
                                // MONITOREXIT : peerGroup2
                                return;
                            }
                            peer.disconnect();
                            boolean needHandleDeath = PeerGroup.this.peers.remove(peer);
                            // MONITOREXIT : peerGroup2
                            if (needHandleDeath) {
                                PeerGroup.this.handlePeerDeath(peer);
                            }
                            if (address == null) return;
                            PeerGroup.this.inactives.add(address);
                            return;
                        }
                        PeerGroup.this.peers.add(peer);
                        // MONITOREXIT : peerGroup
                        PeerGroup.this.handleNewPeer(peer);
                        if (blockUntilRunning == ExecuteBlockMode.WAIT_FOR_STARTUP) {
                            latch.countDown();
                        }
                        peer.run();
                    }
                    catch (PeerException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof SocketTimeoutException) {
                            log.info("Timeout talking to " + peer + ": " + cause.getMessage());
                        } else if (cause instanceof ConnectException) {
                            log.info("Could not connect to " + peer + ": " + cause.getMessage());
                        } else if (cause instanceof IOException) {
                            log.info("Error talking to " + peer + ": " + cause.getMessage());
                        } else {
                            log.error("Unexpected exception whilst talking to " + peer, (Throwable)ex);
                        }
                        Object var4_5 = null;
                        PeerGroup peerGroup = PeerGroup.this;
                        // MONITORENTER : peerGroup
                        if (!PeerGroup.this.running) {
                            // MONITOREXIT : peerGroup
                            return;
                        }
                        peer.disconnect();
                        boolean needHandleDeath = PeerGroup.this.peers.remove(peer);
                        // MONITOREXIT : peerGroup
                        if (needHandleDeath) {
                            PeerGroup.this.handlePeerDeath(peer);
                        }
                        if (address == null) return;
                        PeerGroup.this.inactives.add(address);
                        return;
                    }
                    Object var4_4 = null;
                    PeerGroup peerGroup = PeerGroup.this;
                    // MONITORENTER : peerGroup
                    if (!PeerGroup.this.running) {
                        // MONITOREXIT : peerGroup
                        return;
                    }
                    peer.disconnect();
                    boolean needHandleDeath = PeerGroup.this.peers.remove(peer);
                    // MONITOREXIT : peerGroup
                    if (needHandleDeath) {
                        PeerGroup.this.handlePeerDeath(peer);
                    }
                    if (address == null) return;
                    PeerGroup.this.inactives.add(address);
                    return;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    PeerGroup peerGroup = PeerGroup.this;
                    // MONITORENTER : peerGroup
                    if (!PeerGroup.this.running) {
                        // MONITOREXIT : peerGroup
                        return;
                    }
                    peer.disconnect();
                    boolean needHandleDeath = PeerGroup.this.peers.remove(peer);
                    // MONITOREXIT : peerGroup
                    if (needHandleDeath) {
                        PeerGroup.this.handlePeerDeath(peer);
                    }
                    if (address == null) throw throwable;
                    PeerGroup.this.inactives.add(address);
                    throw throwable;
                }
            }
        });
        if (blockUntilRunning == ExecuteBlockMode.WAIT_FOR_STARTUP) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startBlockChainDownload(PeerEventListener listener) {
        this.downloadListener = listener;
        Set<Peer> set = this.peers;
        synchronized (set) {
            if (!this.peers.isEmpty()) {
                this.startBlockChainDownloadFromPeer(this.peers.iterator().next());
            }
        }
    }

    public void downloadBlockChain() {
        DownloadListener listener = new DownloadListener();
        this.startBlockChainDownload(listener);
        try {
            listener.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected synchronized void handleNewPeer(final Peer peer) {
        log.info("Handling new {}", (Object)peer);
        if (this.downloadListener != null && this.downloadPeer == null) {
            log.info("  starting block chain download");
            this.startBlockChainDownloadFromPeer(peer);
        } else if (this.downloadPeer == null) {
            this.setDownloadPeer(peer);
        } else {
            peer.setDownloadData(false);
        }
        peer.addEventListener(this.getDataListener);
        this.announcePendingWalletTransactions(this.wallets, Collections.singleton(peer));
        EventListenerInvoker.invoke(this.peerEventListeners, new EventListenerInvoker<PeerEventListener>(){

            @Override
            public void invoke(PeerEventListener listener) {
                listener.onPeerConnected(peer, PeerGroup.this.peers.size());
            }
        });
    }

    private synchronized boolean announcePendingWalletTransactions(List<Wallet> announceWallets, Set<Peer> announceToPeers) {
        InventoryMessage inv = new InventoryMessage(this.params);
        for (Wallet w : announceWallets) {
            for (Transaction tx : w.getPendingTransactions()) {
                inv.addTransaction(tx);
            }
        }
        if (inv.getItems().size() == 0) {
            return true;
        }
        boolean success = false;
        for (Peer p : announceToPeers) {
            try {
                p.sendMessage(inv);
                success = true;
            }
            catch (IOException e) {
                log.warn("Failed to announce 'inv' to peer: {}", (Object)p);
            }
        }
        return success;
    }

    private synchronized void setDownloadPeer(Peer peer) {
        if (this.downloadPeer != null) {
            log.info("Unsetting download peer: {}", (Object)this.downloadPeer);
            this.downloadPeer.setDownloadData(false);
            for (PeerEventListener listener : this.peerEventListeners) {
                this.downloadPeer.removeEventListener(listener);
            }
        }
        this.downloadPeer = peer;
        if (this.downloadPeer != null) {
            log.info("Setting download peer: {}", (Object)this.downloadPeer);
            this.downloadPeer.setDownloadData(true);
            this.downloadPeer.setFastCatchupTime(this.fastCatchupTimeSecs);
            for (PeerEventListener listener : this.peerEventListeners) {
                this.downloadPeer.addEventListener(listener);
            }
        }
    }

    public synchronized void setFastCatchupTimeSecs(long secondsSinceEpoch) {
        this.fastCatchupTimeSecs = secondsSinceEpoch;
        if (this.downloadPeer != null) {
            this.downloadPeer.setFastCatchupTime(secondsSinceEpoch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void handlePeerDeath(final Peer peer) {
        if (!this.isRunning()) {
            log.info("Peer death while shutting down");
            return;
        }
        assert (!this.peers.contains(peer));
        if (peer == this.downloadPeer) {
            log.info("Download peer died. Picking a new one.");
            this.setDownloadPeer(null);
            Set<Peer> set = this.peers;
            synchronized (set) {
                if (!this.peers.isEmpty()) {
                    Peer next = this.peers.iterator().next();
                    this.setDownloadPeer(next);
                    if (this.downloadListener != null) {
                        this.startBlockChainDownloadFromPeer(next);
                    }
                }
            }
        }
        peer.removeEventListener(this.getDataListener);
        EventListenerInvoker.invoke(this.peerEventListeners, new EventListenerInvoker<PeerEventListener>(){

            @Override
            public void invoke(PeerEventListener listener) {
                listener.onPeerDisconnected(peer, PeerGroup.this.peers.size());
            }
        });
    }

    private synchronized void startBlockChainDownloadFromPeer(Peer peer) {
        try {
            peer.addEventListener(this.downloadListener);
            this.setDownloadPeer(peer);
            peer.startBlockChainDownload();
        }
        catch (IOException e) {
            log.error("failed to start block chain download from " + peer, (Throwable)e);
            return;
        }
    }

    static class PeerGroupThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        PeerGroupThreadFactory() {
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = "PeerGroup-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setPriority(Math.max(1, Thread.currentThread().getPriority() - 1));
            t.setDaemon(true);
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExecuteBlockMode {
        WAIT_FOR_STARTUP,
        RETURN_IMMEDIATELY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PeerGroupThread
    extends Thread {
        private LinkedBlockingQueue<FutureTask> tasks;

        public PeerGroupThread() {
            super("Peer group thread");
            this.tasks = new LinkedBlockingQueue();
            this.setPriority(Math.max(1, Thread.currentThread().getPriority() - 1));
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Object object;
            try {
                while (PeerGroup.this.isRunning()) {
                    object = PeerGroup.this;
                    // MONITORENTER : object
                    int numPeers = PeerGroup.this.peers.size();
                    // MONITOREXIT : object
                    if (PeerGroup.this.inactives.size() == 0) {
                        this.discoverPeers();
                    } else if (numPeers < PeerGroup.this.getMaxConnections()) {
                        this.tryNextPeer();
                    }
                    if (numPeers > 0) {
                        FutureTask task = this.tasks.poll(PeerGroup.this.connectionDelayMillis, TimeUnit.MILLISECONDS);
                        if (task == null) continue;
                        PeerGroup peerGroup = PeerGroup.this;
                        // MONITORENTER : peerGroup
                        task.run();
                        // MONITOREXIT : peerGroup
                        continue;
                    }
                    Thread.sleep(PeerGroup.this.connectionDelayMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PeerGroup peerGroup = PeerGroup.this;
            // MONITORENTER : peerGroup
            PeerGroup.this.running = false;
            PeerGroup.this.peerPool.shutdown();
            this.shutdownPeerDiscovery();
            object = PeerGroup.this.peers;
            // MONITORENTER : object
            Iterator i$ = PeerGroup.this.peers.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    // MONITOREXIT : object
                    PeerGroup.this.peers = null;
                    // MONITOREXIT : peerGroup
                    return;
                }
                Peer peer = (Peer)i$.next();
                peer.disconnect();
            }
        }

        private void discoverPeers() {
            for (PeerDiscovery peerDiscovery : PeerGroup.this.peerDiscoverers) {
                InetSocketAddress[] addresses;
                try {
                    addresses = peerDiscovery.getPeers();
                }
                catch (PeerDiscoveryException e) {
                    log.error("Failed to discover peer addresses from discovery source", (Throwable)e);
                    return;
                }
                for (int i = 0; i < addresses.length; ++i) {
                    PeerGroup.this.inactives.add(new PeerAddress(addresses[i]));
                }
                if (PeerGroup.this.inactives.size() <= 0) continue;
                break;
            }
        }

        private void shutdownPeerDiscovery() {
            for (PeerDiscovery peerDiscovery : PeerGroup.this.peerDiscoverers) {
                peerDiscovery.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryNextPeer() throws InterruptedException {
            PeerAddress address = (PeerAddress)PeerGroup.this.inactives.take();
            while (true) {
                try {
                    VersionMessage ver = PeerGroup.this.getVersionMessage().duplicate();
                    ver.bestHeight = PeerGroup.this.chain.getBestChainHeight();
                    ver.time = Utils.now().getTime() / 1000L;
                    Peer peer = new Peer(PeerGroup.this.params, address, PeerGroup.this.chain, ver);
                    PeerGroup.this.executePeer(address, peer, true, ExecuteBlockMode.RETURN_IMMEDIATELY);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    PeerGroup peerGroup = PeerGroup.this;
                    synchronized (peerGroup) {
                        if (!PeerGroup.this.running) {
                            break;
                        }
                    }
                    Thread.sleep(PeerGroup.this.connectionDelayMillis);
                    continue;
                }
                break;
            }
        }

        public synchronized <T> void addTask(FutureTask<T> task) {
            this.tasks.add(task);
        }
    }
}

