/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.UnsafeByteArrayOutputStream;
import com.google.bitcoin.core.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Script {
    private static Logger log = LoggerFactory.getLogger(Script.class);
    public static final int OP_PUSHDATA1 = 76;
    public static final int OP_PUSHDATA2 = 77;
    public static final int OP_PUSHDATA4 = 78;
    public static final int OP_DUP = 118;
    public static final int OP_HASH160 = 169;
    public static final int OP_EQUALVERIFY = 136;
    public static final int OP_CHECKSIG = 172;
    byte[] program;
    private int cursor;
    private List<byte[]> chunks;
    byte[] programCopy;
    private final NetworkParameters params;

    public Script(NetworkParameters params, byte[] programBytes, int offset, int length) throws ScriptException {
        this.params = params;
        this.parse(programBytes, offset, length);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (byte[] chunk : this.chunks) {
            if (chunk.length == 1) {
                String opName;
                int opcode = 0xFF & chunk[0];
                switch (opcode) {
                    case 118: {
                        opName = "DUP";
                        break;
                    }
                    case 169: {
                        opName = "HASH160";
                        break;
                    }
                    case 172: {
                        opName = "CHECKSIG";
                        break;
                    }
                    case 136: {
                        opName = "EQUALVERIFY";
                        break;
                    }
                    default: {
                        opName = "?(" + opcode + ")";
                    }
                }
                buf.append(opName);
                buf.append(" ");
                continue;
            }
            buf.append("[");
            buf.append(chunk.length);
            buf.append("]");
            buf.append(Utils.bytesToHexString(chunk));
            buf.append(" ");
        }
        return buf.toString();
    }

    private byte[] getData(int len) throws ScriptException {
        try {
            byte[] buf = new byte[len];
            System.arraycopy(this.program, this.cursor, buf, 0, len);
            this.cursor += len;
            return buf;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ScriptException("Failed read of " + len + " bytes", e);
        }
    }

    private int readByte() {
        return 0xFF & this.program[this.cursor++];
    }

    private void parse(byte[] programBytes, int offset, int length) throws ScriptException {
        this.programCopy = new byte[length];
        System.arraycopy(programBytes, offset, this.programCopy, 0, length);
        this.program = this.programCopy;
        offset = 0;
        this.chunks = new ArrayList<byte[]>(10);
        this.cursor = offset;
        while (this.cursor < offset + length) {
            int len;
            int opcode = this.readByte();
            if (opcode >= 240) {
                opcode = opcode << 8 | this.readByte();
            }
            if (opcode > 0 && opcode < 76) {
                this.chunks.add(this.getData(opcode));
                continue;
            }
            if (opcode == 76) {
                len = this.readByte();
                this.chunks.add(this.getData(len));
                continue;
            }
            if (opcode == 77) {
                len = this.readByte() | this.readByte() << 8;
                this.chunks.add(this.getData(len));
                continue;
            }
            if (opcode == 78) {
                log.error("PUSHDATA4: Unimplemented");
                continue;
            }
            this.chunks.add(new byte[]{(byte)opcode});
        }
    }

    public boolean isSentToIP() {
        if (this.chunks.size() != 2) {
            return false;
        }
        return (0xFF & this.chunks.get(1)[0]) == 172 && this.chunks.get(0).length > 1;
    }

    public byte[] getPubKeyHash() throws ScriptException {
        if (this.chunks.size() != 5) {
            throw new ScriptException("Script not of right size to be a scriptPubKey, expecting 5 but got " + this.chunks.size());
        }
        if ((0xFF & this.chunks.get(0)[0]) != 118 || (0xFF & this.chunks.get(1)[0]) != 169 || (0xFF & this.chunks.get(3)[0]) != 136 || (0xFF & this.chunks.get(4)[0]) != 172) {
            throw new ScriptException("Script not in the standard scriptPubKey form");
        }
        return this.chunks.get(2);
    }

    public byte[] getPubKey() throws ScriptException {
        if (this.chunks.size() == 1) {
            return this.chunks.get(0);
        }
        if (this.chunks.size() != 2) {
            throw new ScriptException("Script not of right size to be a scriptSig, expecting 2 but got " + this.chunks.size());
        }
        if (this.chunks.get(0).length <= 1 && this.chunks.get(1).length > 1) {
            throw new ScriptException("Script not in the standard scriptSig form: " + this.chunks.size() + " chunks");
        }
        return this.chunks.get(1);
    }

    public Address getFromAddress() throws ScriptException {
        return new Address(this.params, Utils.sha256hash160(this.getPubKey()));
    }

    public Address getToAddress() throws ScriptException {
        return new Address(this.params, this.getPubKeyHash());
    }

    static void writeBytes(OutputStream os, byte[] buf) throws IOException {
        if (buf.length < 76) {
            os.write(buf.length);
            os.write(buf);
        } else if (buf.length < 256) {
            os.write(76);
            os.write(buf.length);
            os.write(buf);
        } else if (buf.length < 65536) {
            os.write(77);
            os.write(0xFF & buf.length);
            os.write(0xFF & buf.length >> 8);
            os.write(buf);
        } else {
            throw new RuntimeException("Unimplemented");
        }
    }

    static byte[] createOutputScript(Address to) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(24);
            ((ByteArrayOutputStream)bits).write(118);
            ((ByteArrayOutputStream)bits).write(169);
            Script.writeBytes(bits, to.getHash160());
            ((ByteArrayOutputStream)bits).write(136);
            ((ByteArrayOutputStream)bits).write(172);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] createOutputScript(byte[] pubkey) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(pubkey.length + 1);
            Script.writeBytes(bits, pubkey);
            ((ByteArrayOutputStream)bits).write(172);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] createInputScript(byte[] signature, byte[] pubkey) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(signature.length + pubkey.length);
            Script.writeBytes(bits, signature);
            Script.writeBytes(bits, pubkey);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

