/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Utils;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class Sha256Hash
implements Serializable {
    private static final long serialVersionUID = 3778897922647016546L;
    private byte[] bytes;
    private int hash = -1;
    private static int HASHCODE_BYTES_TO_CHECK = 5;
    private static boolean HASHCODE_BYTES_TO_CHECK_CHANGED = false;
    public static final Sha256Hash ZERO_HASH = new Sha256Hash(new byte[32]);

    public static void setHashcodeByteLength(int hashcodeByteLength) {
        if (HASHCODE_BYTES_TO_CHECK_CHANGED) {
            throw new IllegalStateException("setHashcodeByteLength can only be called once and should be called before any instances of Sha256Hash are constructed");
        }
        HASHCODE_BYTES_TO_CHECK = hashcodeByteLength;
        HASHCODE_BYTES_TO_CHECK_CHANGED = true;
    }

    public Sha256Hash(byte[] bytes) {
        assert (bytes.length == 32);
        this.bytes = bytes;
    }

    private Sha256Hash(byte[] bytes, int hash) {
        assert (bytes.length == 32);
        this.bytes = bytes;
        this.hash = hash;
    }

    public Sha256Hash(String string) {
        assert (string.length() == 64);
        this.bytes = Hex.decode((String)string);
    }

    public static Sha256Hash create(byte[] contents) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return new Sha256Hash(digest.digest(contents));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof Sha256Hash)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((Sha256Hash)other).bytes);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = 1;
            for (int i = 0; i < HASHCODE_BYTES_TO_CHECK; ++i) {
                this.hash = 31 * this.hash + this.bytes[i];
            }
        }
        return this.hash;
    }

    public String toString() {
        return Utils.bytesToHexString(this.bytes);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public Sha256Hash duplicate() {
        return new Sha256Hash(this.bytes, this.hash);
    }
}

