/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.BitcoinSerializer;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkConnection;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.Ping;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VersionAck;
import com.google.bitcoin.core.VersionMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPNetworkConnection
implements NetworkConnection {
    private static final Logger log = LoggerFactory.getLogger(TCPNetworkConnection.class);
    private final Socket socket;
    private final OutputStream out;
    private final InputStream in;
    private final InetAddress remoteIp;
    private final NetworkParameters params;
    private final VersionMessage versionMessage;
    private static final LinkedHashMap<Sha256Hash, Integer> dedupeList = BitcoinSerializer.createDedupeList();
    private BitcoinSerializer serializer = null;
    private static final Date checksummingProtocolChangeDate = new Date(1329696000000L);

    public TCPNetworkConnection(PeerAddress peerAddress, NetworkParameters params, int connectTimeoutMsec, boolean dedupe, VersionMessage ver) throws IOException, ProtocolException {
        this.params = params;
        this.remoteIp = peerAddress.getAddr();
        int port = peerAddress.getPort() > 0 ? peerAddress.getPort() : params.port;
        InetSocketAddress address = new InetSocketAddress(this.remoteIp, port);
        this.socket = new Socket();
        this.socket.connect(address, connectTimeoutMsec);
        this.out = this.socket.getOutputStream();
        this.in = this.socket.getInputStream();
        this.serializer = new BitcoinSerializer(params, false, dedupe ? dedupeList : null);
        this.serializer.setUseChecksumming(Utils.now().after(checksummingProtocolChangeDate));
        log.info("Announcing ourselves as: {}", (Object)ver.subVer);
        this.writeMessage(ver);
        Message m = this.readMessage();
        if (!(m instanceof VersionMessage)) {
            throw new ProtocolException("First message received was not a version message but rather " + m);
        }
        this.versionMessage = (VersionMessage)m;
        this.writeMessage(new VersionAck());
        this.readMessage();
        int peerVersion = this.versionMessage.clientVersion;
        log.info("Connected to peer: version={}, subVer='{}', services=0x{}, time={}, blocks={}", new Object[]{peerVersion, this.versionMessage.subVer, this.versionMessage.localServices, new Date(this.versionMessage.time * 1000L), this.versionMessage.bestHeight});
        if (!this.versionMessage.hasBlockChain()) {
            try {
                this.shutdown();
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw new ProtocolException("Peer does not have a copy of the block chain.");
        }
        this.serializer.setUseChecksumming(peerVersion >= 209);
    }

    public TCPNetworkConnection(PeerAddress peerAddress, NetworkParameters params, int bestHeight, int connectTimeoutMsec, boolean dedupe) throws IOException, ProtocolException {
        this(peerAddress, params, connectTimeoutMsec, dedupe, new VersionMessage(params, bestHeight));
    }

    public TCPNetworkConnection(InetAddress inetAddress, NetworkParameters params, int bestHeight, int connectTimeout) throws IOException, ProtocolException {
        this(new PeerAddress(inetAddress), params, bestHeight, connectTimeout, true);
    }

    public void ping() throws IOException {
        this.writeMessage(new Ping());
    }

    public void shutdown() throws IOException {
        this.socket.shutdownOutput();
        this.socket.shutdownInput();
        this.socket.close();
    }

    public String toString() {
        return "[" + this.remoteIp.getHostAddress() + "]:" + this.params.port + " (" + (this.socket.isConnected() ? "connected" : "disconnected") + ")";
    }

    public Message readMessage() throws IOException, ProtocolException {
        Message message;
        while ((message = this.serializer.deserialize(this.in)) == null) {
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessage(Message message) throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.serializer.serialize(message, this.out);
        }
    }

    public VersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    public PeerAddress getPeerAddress() {
        return new PeerAddress(this.remoteIp, this.params.port);
    }
}

