/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.store.BlockStoreException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionConfidence
implements Serializable {
    private static final long serialVersionUID = 4577920141400556444L;
    private Set<PeerAddress> broadcastBy;
    private Transaction transaction;
    private transient ArrayList<Listener> listeners;
    private ConfidenceType confidenceType = ConfidenceType.UNKNOWN;
    private int appearedAtChainHeight = -1;
    private Transaction overridingTransaction;

    public synchronized void addEventListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(listener);
    }

    public synchronized void removeEventListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listeners.remove(listener);
    }

    public TransactionConfidence(Transaction tx) {
        this.broadcastBy = new HashSet<PeerAddress>(10);
        this.transaction = tx;
    }

    public synchronized int getAppearedAtChainHeight() {
        if (this.getConfidenceType() != ConfidenceType.BUILDING) {
            throw new IllegalStateException("Confidence type is " + (Object)((Object)this.getConfidenceType()) + ", not BUILDING");
        }
        return this.appearedAtChainHeight;
    }

    public synchronized void setAppearedAtChainHeight(int appearedAtChainHeight) {
        if (appearedAtChainHeight < 0) {
            throw new IllegalArgumentException("appearedAtChainHeight out of range");
        }
        this.appearedAtChainHeight = appearedAtChainHeight;
        this.setConfidenceType(ConfidenceType.BUILDING);
    }

    public synchronized ConfidenceType getConfidenceType() {
        return this.confidenceType;
    }

    public synchronized void setConfidenceType(ConfidenceType confidenceType) {
        if (confidenceType == this.confidenceType) {
            return;
        }
        this.confidenceType = confidenceType;
        this.runListeners();
    }

    public synchronized void markBroadcastBy(PeerAddress address) {
        this.broadcastBy.add(address);
        if (this.getConfidenceType() == ConfidenceType.UNKNOWN) {
            this.setConfidenceType(ConfidenceType.NOT_SEEN_IN_CHAIN);
        }
    }

    public synchronized int numBroadcastPeers() {
        return this.broadcastBy.size();
    }

    public synchronized Set<PeerAddress> getBroadcastBy() {
        return this.broadcastBy;
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        int peers = this.numBroadcastPeers();
        if (peers > 0) {
            builder.append("Seen by ");
            builder.append(peers);
            if (peers > 1) {
                builder.append(" peers. ");
            } else {
                builder.append(" peer. ");
            }
        }
        switch (this.getConfidenceType()) {
            case UNKNOWN: {
                builder.append("Unknown confidence level.");
                break;
            }
            case OVERRIDDEN_BY_DOUBLE_SPEND: {
                builder.append("Dead: overridden by double spend and will not confirm.");
                break;
            }
            case NOT_IN_BEST_CHAIN: {
                builder.append("Seen in side chain but not best chain.");
                break;
            }
            case NOT_SEEN_IN_CHAIN: {
                builder.append("Not seen in chain.");
                break;
            }
            case BUILDING: {
                builder.append("Appeared in best chain at height ");
                builder.append(this.getAppearedAtChainHeight());
                builder.append(".");
            }
        }
        return builder.toString();
    }

    public synchronized int getDepthInBlocks(BlockChain chain) {
        if (this.getConfidenceType() != ConfidenceType.BUILDING) {
            throw new IllegalStateException("Confidence type is not BUILDING");
        }
        int height = this.getAppearedAtChainHeight();
        return chain.getBestChainHeight() - height + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getWorkDone(BlockChain chain) throws BlockStoreException {
        TransactionConfidence transactionConfidence = this;
        synchronized (transactionConfidence) {
            if (this.getConfidenceType() != ConfidenceType.BUILDING) {
                throw new IllegalStateException("Confidence type is " + (Object)((Object)this.getConfidenceType()) + ", not BUILDING");
            }
        }
        BigInteger work = BigInteger.ZERO;
        StoredBlock block = chain.getChainHead();
        for (int depth = this.getDepthInBlocks(chain); depth > 0; --depth) {
            work = work.add(block.getChainWork());
            block = block.getPrev(chain.blockStore);
        }
        return work;
    }

    public synchronized Transaction getOverridingTransaction() {
        if (this.getConfidenceType() != ConfidenceType.OVERRIDDEN_BY_DOUBLE_SPEND) {
            throw new IllegalStateException("Confidence type is " + (Object)((Object)this.getConfidenceType()) + ", not OVERRIDDEN_BY_DOUBLE_SPEND");
        }
        return this.overridingTransaction;
    }

    public synchronized void setOverridingTransaction(Transaction overridingTransaction) {
        this.overridingTransaction = overridingTransaction;
        this.setConfidenceType(ConfidenceType.OVERRIDDEN_BY_DOUBLE_SPEND);
    }

    public synchronized TransactionConfidence duplicate() {
        TransactionConfidence c = new TransactionConfidence(this.transaction);
        c.broadcastBy.addAll(this.broadcastBy);
        c.confidenceType = this.confidenceType;
        c.overridingTransaction = this.overridingTransaction;
        c.appearedAtChainHeight = this.appearedAtChainHeight;
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runListeners() {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener l;
            Listener listener = l = this.listeners.get(i);
            synchronized (listener) {
                l.onConfidenceChanged(this.transaction);
            }
            if (this.listeners.get(i) == l) continue;
            --i;
        }
    }

    public static interface Listener {
        public void onConfidenceChanged(Transaction var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfidenceType {
        BUILDING(1),
        NOT_SEEN_IN_CHAIN(2),
        NOT_IN_BEST_CHAIN(3),
        OVERRIDDEN_BY_DOUBLE_SPEND(4),
        UNKNOWN(0);

        private int value;

        private ConfidenceType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ConfidenceType valueOf(int value) {
            switch (value) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return BUILDING;
                }
                case 2: {
                    return NOT_SEEN_IN_CHAIN;
                }
                case 3: {
                    return NOT_IN_BEST_CHAIN;
                }
                case 4: {
                    return OVERRIDDEN_BY_DOUBLE_SPEND;
                }
            }
            return null;
        }
    }
}

