/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.ChildMessage;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Script;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import com.google.bitcoin.core.Wallet;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionOutput
extends ChildMessage
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TransactionOutput.class);
    private static final long serialVersionUID = -590332479859256824L;
    private BigInteger value;
    private byte[] scriptBytes;
    private transient Script scriptPubKey;
    private boolean availableForSpending;
    private TransactionInput spentBy;
    Transaction parentTransaction;
    private transient int scriptLen;

    public TransactionOutput(NetworkParameters params, Transaction parent, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
        this.parentTransaction = parent;
        this.availableForSpending = true;
    }

    public TransactionOutput(NetworkParameters params, Transaction parent, byte[] msg, int offset, boolean parseLazy, boolean parseRetain) throws ProtocolException {
        super(params, msg, offset, parent, parseLazy, parseRetain, -1);
        this.parentTransaction = parent;
        this.availableForSpending = true;
    }

    TransactionOutput(NetworkParameters params, Transaction parent, BigInteger value, Address to) {
        super(params);
        this.value = value;
        this.scriptBytes = Script.createOutputScript(to);
        this.parentTransaction = parent;
        this.availableForSpending = true;
        this.length = 8 + VarInt.sizeOf(this.scriptBytes.length) + this.scriptBytes.length;
    }

    public TransactionOutput(NetworkParameters params, Transaction parent, BigInteger value, byte[] scriptBytes) {
        super(params);
        this.value = value;
        this.scriptBytes = scriptBytes;
        this.parentTransaction = parent;
        this.availableForSpending = true;
        this.length = 8 + VarInt.sizeOf(scriptBytes.length) + scriptBytes.length;
    }

    TransactionOutput(NetworkParameters params, Transaction parent, byte[] scriptBytes) {
        super(params);
        this.scriptBytes = scriptBytes;
        this.value = Utils.toNanoCoins(50, 0);
        this.parentTransaction = parent;
        this.availableForSpending = true;
    }

    public Script getScriptPubKey() throws ScriptException {
        if (this.scriptPubKey == null) {
            this.maybeParse();
            this.scriptPubKey = new Script(this.params, this.scriptBytes, 0, this.scriptBytes.length);
        }
        return this.scriptPubKey;
    }

    protected void parseLite() {
        this.value = this.readUint64();
        this.scriptLen = (int)this.readVarInt();
        this.length = this.cursor - this.offset + this.scriptLen;
    }

    void parse() throws ProtocolException {
        this.scriptBytes = this.readBytes(this.scriptLen);
    }

    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        assert (this.scriptBytes != null);
        Utils.uint64ToByteStreamLE(this.getValue(), stream);
        stream.write(new VarInt(this.scriptBytes.length).encode());
        stream.write(this.scriptBytes);
    }

    public BigInteger getValue() {
        this.maybeParse();
        return this.value;
    }

    int getIndex() {
        assert (this.parentTransaction != null);
        for (int i = 0; i < this.parentTransaction.getOutputs().size(); ++i) {
            if (this.parentTransaction.getOutputs().get(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Output linked to wrong parent transaction?");
    }

    public void markAsSpent(TransactionInput input) {
        assert (this.availableForSpending);
        this.availableForSpending = false;
        this.spentBy = input;
    }

    void markAsUnspent() {
        this.availableForSpending = true;
        this.spentBy = null;
    }

    boolean isAvailableForSpending() {
        return this.availableForSpending;
    }

    public byte[] getScriptBytes() {
        this.maybeParse();
        return this.scriptBytes;
    }

    public boolean isMine(Wallet wallet) {
        try {
            byte[] pubkeyHash = this.getScriptPubKey().getPubKeyHash();
            return wallet.isPubKeyHashMine(pubkeyHash);
        }
        catch (ScriptException e) {
            log.debug("Could not parse tx output script: {}", (Object)e.toString());
            return false;
        }
    }

    public String toString() {
        try {
            return "TxOut of " + Utils.bitcoinValueToFriendlyString(this.value) + " to " + this.getScriptPubKey().getToAddress().toString() + " script:" + this.getScriptPubKey().toString();
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public TransactionInput getSpentBy() {
        return this.spentBy;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.maybeParse();
        out.defaultWriteObject();
    }
}

