/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class VersionMessage
extends Message {
    private static final long serialVersionUID = 7313594258967483180L;
    public static final int NODE_NETWORK = 1;
    public int clientVersion;
    public long localServices;
    public long time;
    public PeerAddress myAddr;
    public PeerAddress theirAddr;
    public String subVer;
    public long bestHeight;

    public VersionMessage(NetworkParameters params, byte[] msg) throws ProtocolException {
        super(params, msg, 0);
    }

    public VersionMessage(NetworkParameters params, int newBestHeight) {
        super(params);
        this.clientVersion = 31800;
        this.localServices = 0L;
        this.time = System.currentTimeMillis() / 1000L;
        try {
            byte[] localhost = new byte[]{127, 0, 0, 1};
            this.myAddr = new PeerAddress(InetAddress.getByAddress(localhost), params.port, 0);
            this.theirAddr = new PeerAddress(InetAddress.getByAddress(localhost), params.port, 0);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.subVer = "/BitCoinJ:0.4/";
        this.bestHeight = newBestHeight;
        this.length = 84;
        if (this.protocolVersion > 31402) {
            this.length += 8;
        }
        this.length += this.subVer == null ? 1 : VarInt.sizeOf(this.subVer.length()) + this.subVer.length();
    }

    protected void parseLite() throws ProtocolException {
    }

    public void parse() throws ProtocolException {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        this.clientVersion = (int)this.readUint32();
        this.localServices = this.readUint64().longValue();
        this.time = this.readUint64().longValue();
        this.myAddr = new PeerAddress(this.params, this.bytes, this.cursor, 0);
        this.cursor += this.myAddr.getMessageSize();
        this.theirAddr = new PeerAddress(this.params, this.bytes, this.cursor, 0);
        this.cursor += this.theirAddr.getMessageSize();
        this.readUint64();
        this.subVer = this.readStr();
        this.bestHeight = this.readUint32();
        this.length = this.cursor - this.offset;
    }

    public void bitcoinSerializeToStream(OutputStream buf) throws IOException {
        Utils.uint32ToByteStreamLE(this.clientVersion, buf);
        Utils.uint32ToByteStreamLE(this.localServices, buf);
        Utils.uint32ToByteStreamLE(this.localServices >> 32, buf);
        Utils.uint32ToByteStreamLE(this.time, buf);
        Utils.uint32ToByteStreamLE(this.time >> 32, buf);
        try {
            this.myAddr.bitcoinSerialize(buf);
            this.theirAddr.bitcoinSerialize(buf);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Utils.uint32ToByteStreamLE(0L, buf);
        Utils.uint32ToByteStreamLE(0L, buf);
        byte[] subVerBytes = this.subVer.getBytes("UTF-8");
        buf.write(new VarInt(subVerBytes.length).encode());
        buf.write(subVerBytes);
        Utils.uint32ToByteStreamLE(this.bestHeight, buf);
    }

    public boolean hasBlockChain() {
        return (this.localServices & 1L) == 1L;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VersionMessage)) {
            return false;
        }
        VersionMessage other = (VersionMessage)o;
        return other.bestHeight == this.bestHeight && other.clientVersion == this.clientVersion && other.localServices == this.localServices && other.time == this.time && other.subVer.equals(this.subVer) && other.myAddr.equals(this.myAddr) && other.theirAddr.equals(this.theirAddr);
    }

    byte[] getChecksum() {
        return null;
    }

    void setChecksum(byte[] checksum) {
    }

    public int hashCode() {
        return (int)this.bestHeight ^ this.clientVersion ^ (int)this.localServices ^ (int)this.time ^ this.subVer.hashCode() ^ this.myAddr.hashCode() ^ this.theirAddr.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("client version: ").append(this.clientVersion).append("\n");
        sb.append("local services: ").append(this.localServices).append("\n");
        sb.append("time:           ").append(this.time).append("\n");
        sb.append("my addr:        ").append(this.myAddr).append("\n");
        sb.append("their addr:     ").append(this.theirAddr).append("\n");
        sb.append("sub version:    ").append(this.subVer).append("\n");
        sb.append("best height:    ").append(this.bestHeight).append("\n");
        return sb.toString();
    }

    public VersionMessage duplicate() {
        VersionMessage v = new VersionMessage(this.params, (int)this.bestHeight);
        v.clientVersion = this.clientVersion;
        v.localServices = this.localServices;
        v.time = this.time;
        v.myAddr = this.myAddr;
        v.theirAddr = this.theirAddr;
        v.subVer = this.subVer;
        return v;
    }

    public void appendToSubVer(String name, String version, String comments) {
        this.checkSubVerComponent(name);
        this.checkSubVerComponent(version);
        if (comments != null) {
            this.checkSubVerComponent(comments);
            this.subVer = this.subVer.concat(String.format("%s:%s(%s)/", name, version, comments));
        } else {
            this.subVer = this.subVer.concat(String.format("%s:%s/", name, version));
        }
    }

    private void checkSubVerComponent(String component) {
        if (component.contains("/") || component.contains("(") || component.contains(")")) {
            throw new IllegalArgumentException("name contains invalid characters");
        }
    }
}

