/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AddressFormatException;
import com.google.bitcoin.core.Base58;
import com.google.bitcoin.core.Utils;
import java.util.Arrays;

public class VersionedChecksummedBytes {
    protected int version;
    protected byte[] bytes;

    protected VersionedChecksummedBytes(String encoded) throws AddressFormatException {
        byte[] tmp = Base58.decodeChecked(encoded);
        this.version = tmp[0] & 0xFF;
        this.bytes = new byte[tmp.length - 1];
        System.arraycopy(tmp, 1, this.bytes, 0, tmp.length - 1);
    }

    protected VersionedChecksummedBytes(int version, byte[] bytes) {
        assert (version < 256 && version >= 0);
        this.version = version;
        this.bytes = bytes;
    }

    public String toString() {
        byte[] addressBytes = new byte[1 + this.bytes.length + 4];
        addressBytes[0] = (byte)this.version;
        System.arraycopy(this.bytes, 0, addressBytes, 1, this.bytes.length);
        byte[] check = Utils.doubleDigest(addressBytes, 0, this.bytes.length + 1);
        System.arraycopy(check, 0, addressBytes, this.bytes.length + 1, 4);
        return Base58.encode(addressBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object o) {
        if (!(o instanceof VersionedChecksummedBytes)) {
            return false;
        }
        VersionedChecksummedBytes vcb = (VersionedChecksummedBytes)o;
        return Arrays.equals(vcb.bytes, this.bytes);
    }

    public int getVersion() {
        return this.version;
    }
}

