/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.discovery;

import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.discovery.PeerDiscovery;
import com.google.bitcoin.discovery.PeerDiscoveryException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsDiscovery
implements PeerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(DnsDiscovery.class);
    private String[] hostNames;
    private NetworkParameters netParams;
    public static final String[] defaultHosts = new String[]{"dnsseed.bluematt.me", "bitseed.xf2.org", "seed.bitcoin.sipa.be", "dnsseed.bitcoin.dashjr.org"};

    public DnsDiscovery(NetworkParameters netParams) {
        this(DnsDiscovery.getDefaultHostNames(), netParams);
    }

    public DnsDiscovery(String[] hostNames, NetworkParameters netParams) {
        this.hostNames = hostNames;
        this.netParams = netParams;
    }

    public InetSocketAddress[] getPeers() throws PeerDiscoveryException {
        HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
        int failedLookups = 0;
        for (String hostName : this.hostNames) {
            try {
                InetAddress[] hostAddresses;
                for (InetAddress inetAddress : hostAddresses = InetAddress.getAllByName(hostName)) {
                    InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, this.netParams.port);
                    if (addresses.contains(socketAddress)) continue;
                    addresses.add(socketAddress);
                }
            }
            catch (Exception e) {
                log.info("DNS lookup for " + hostName + " failed.");
                if (++failedLookups != this.hostNames.length) continue;
                throw new PeerDiscoveryException("DNS resolution for all hosts failed.", e);
            }
        }
        return addresses.toArray(new InetSocketAddress[0]);
    }

    public static String[] getDefaultHostNames() {
        return defaultHosts;
    }

    public void shutdown() {
    }
}

