/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.examples;

import com.google.bitcoin.core.AbstractWalletEventListener;
import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerGroup;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.store.DerbyBlockStore;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;

public class DerbyPingService {
    public static void main(String[] args) throws Exception {
        Wallet wallet;
        boolean testNet = args.length > 0 && args[0].equalsIgnoreCase("testnet");
        NetworkParameters params = testNet ? NetworkParameters.testNet() : NetworkParameters.prodNet();
        String suffix = testNet ? "testnet" : "prodnet";
        String filePrefix = "pingservice-" + suffix;
        final File walletFile = new File(filePrefix + ".wallet");
        try {
            wallet = Wallet.loadFromFile(walletFile);
        }
        catch (IOException e) {
            wallet = new Wallet(params);
            wallet.keychain.add(new ECKey());
            wallet.saveToFile(walletFile);
        }
        ECKey key = wallet.keychain.get(0);
        System.out.println("Reading block store from disk");
        long time = System.currentTimeMillis();
        DerbyBlockStore blockStore = new DerbyBlockStore(params, ".bitcoinj-" + suffix);
        System.out.println("Opened block store in " + (System.currentTimeMillis() - time) + " ms");
        System.out.println("Connecting ...");
        BlockChain chain = new BlockChain(params, wallet, (BlockStore)blockStore);
        final PeerGroup peerGroup = new PeerGroup(params, chain);
        peerGroup.addAddress(new PeerAddress(InetAddress.getLocalHost()));
        peerGroup.addWallet(wallet);
        peerGroup.start();
        wallet.addEventListener(new AbstractWalletEventListener(){

            public void onCoinsReceived(Wallet w, Transaction tx, BigInteger prevBalance, BigInteger newBalance) {
                assert (!newBalance.equals(BigInteger.ZERO));
                try {
                    TransactionInput input = tx.getInputs().get(0);
                    Address from = input.getFromAddress();
                    BigInteger value = tx.getValueSentToMe(w);
                    System.out.println("Received " + Utils.bitcoinValueToFriendlyString(value) + " from " + from.toString());
                    Transaction sendTx = w.sendCoins(peerGroup, from, value);
                    assert (sendTx != null);
                    System.out.println("Sent coins back! Transaction hash is " + sendTx.getHashAsString());
                    w.saveToFile(walletFile);
                }
                catch (ScriptException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
        peerGroup.downloadBlockChain();
        System.out.println("Send coins to: " + key.toAddress(params).toString());
        System.out.println("Waiting for coins to arrive. Press Ctrl-C to quit.");
    }

    static void iterateAll(DerbyBlockStore blockStore) throws BlockStoreException {
        long time = System.currentTimeMillis();
        int count = 0;
        for (StoredBlock block = blockStore.getChainHead(); block != null; block = block.getPrev(blockStore)) {
            if (++count % 1000 != 0) continue;
            System.out.println("iterated " + count);
        }
        System.out.println("iterated " + count);
        System.out.println("Iterated block store in " + (System.currentTimeMillis() - time) + " ms");
    }
}

