/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.examples;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Peer;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.store.MemoryBlockStore;
import java.net.InetAddress;
import java.util.concurrent.Future;

public class FetchBlock {
    public static void main(String[] args) throws Exception {
        System.out.println("Connecting to node");
        NetworkParameters params = NetworkParameters.prodNet();
        MemoryBlockStore blockStore = new MemoryBlockStore(params);
        BlockChain chain = new BlockChain(params, blockStore);
        final Peer peer = new Peer(params, new PeerAddress(InetAddress.getLocalHost()), chain);
        peer.connect();
        new Thread(new Runnable(){

            public void run() {
                try {
                    peer.run();
                }
                catch (PeerException e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        Sha256Hash blockHash = new Sha256Hash(args[0]);
        Future<Block> future = peer.getBlock(blockHash);
        System.out.println("Waiting for node to send us the requested block: " + blockHash);
        Block block = future.get();
        System.out.println(block);
        peer.disconnect();
    }
}

