/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.examples;

import com.google.bitcoin.core.AbstractPeerEventListener;
import com.google.bitcoin.core.AbstractWalletEventListener;
import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Peer;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerGroup;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.discovery.DnsDiscovery;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.store.BoundedOverheadBlockStore;
import com.google.bitcoin.utils.BriefLogFormatter;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Date;
import java.util.Set;

public class PingService {
    private Wallet w;
    private final PeerGroup peerGroup;
    private final BlockChain chain;
    private final BlockStore blockStore;
    private final File walletFile;

    public static void main(String[] args) throws Exception {
        BriefLogFormatter.init();
        new PingService(args);
    }

    public PingService(String[] args) throws Exception {
        String peerHost = args.length > 0 ? args[0] : null;
        int peerPort = args.length > 1 ? Integer.parseInt(args[1]) : NetworkParameters.prodNet().port;
        boolean testNet = peerPort != NetworkParameters.prodNet().port;
        NetworkParameters params = testNet ? NetworkParameters.testNet() : NetworkParameters.prodNet();
        String filePrefix = testNet ? "pingservice-testnet" : "pingservice-prodnet";
        this.walletFile = new File(filePrefix + ".wallet");
        try {
            this.w = Wallet.loadFromFile(this.walletFile);
        }
        catch (IOException e) {
            this.w = new Wallet(params);
            this.w.keychain.add(new ECKey());
            this.w.saveToFile(this.walletFile);
        }
        final Wallet wallet = this.w;
        ECKey key = wallet.keychain.get(0);
        System.out.println(wallet);
        System.out.println("Reading block store from disk");
        this.blockStore = new BoundedOverheadBlockStore(params, new File(filePrefix + ".blockchain"));
        System.out.println("Connecting ...");
        this.chain = new BlockChain(params, wallet, this.blockStore);
        this.peerGroup = new PeerGroup(params, this.chain);
        this.peerGroup.setUserAgent("PingService", "1.0");
        this.peerGroup.setFastCatchupTimeSecs(new Date().getTime() / 1000L - 86400L);
        if (peerHost != null) {
            this.peerGroup.addAddress(new PeerAddress(InetAddress.getByName(peerHost), peerPort));
        } else {
            this.peerGroup.addPeerDiscovery(new DnsDiscovery(params));
        }
        this.peerGroup.addWallet(wallet);
        this.peerGroup.start();
        this.peerGroup.addEventListener(new AbstractPeerEventListener(){

            public void onBlocksDownloaded(Peer peer, Block block, int blocksLeft) {
                super.onBlocksDownloaded(peer, block, blocksLeft);
                if (blocksLeft > 0) {
                    return;
                }
                Set<Transaction> transactions = wallet.getTransactions(false, false);
                if (transactions.size() == 0) {
                    return;
                }
                System.out.println("Confidences of wallet transactions:");
                for (Transaction tx : transactions) {
                    System.out.println(tx);
                    try {
                        System.out.println(tx.getConfidence());
                        if (tx.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
                            System.out.println("Work done: " + tx.getConfidence().getWorkDone(PingService.this.chain).toString());
                        }
                    }
                    catch (BlockStoreException e) {
                        throw new RuntimeException(e);
                    }
                    System.out.println();
                }
            }
        });
        wallet.addEventListener(new AbstractWalletEventListener(){

            public void onCoinsReceived(Wallet w, Transaction tx, BigInteger prevBalance, BigInteger newBalance) {
                assert (!newBalance.equals(BigInteger.ZERO));
                if (tx.isPending()) {
                    BigInteger value = tx.getValueSentToMe(w);
                    System.out.println("Received pending tx for " + Utils.bitcoinValueToFriendlyString(value) + ": " + tx);
                    System.out.println(tx.getConfidence());
                    tx.getConfidence().addEventListener(new TransactionConfidence.Listener(){

                        public void onConfidenceChanged(Transaction tx2) {
                            if (tx2.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
                                PingService.this.bounceCoins(tx2);
                                tx2.getConfidence().removeEventListener(this);
                            } else {
                                System.out.println(String.format("Confidence of %s changed, is now: %s", tx2.getHashAsString(), tx2.getConfidence().toString()));
                            }
                        }
                    });
                    try {
                        w.saveToFile(PingService.this.walletFile);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return;
                }
                PingService.this.bounceCoins(tx);
            }
        });
        this.peerGroup.downloadBlockChain();
        System.out.println("Send coins to: " + key.toAddress(params).toString());
        System.out.println("Waiting for coins to arrive. Press Ctrl-C to quit.");
    }

    private void bounceCoins(Transaction tx) {
        try {
            BigInteger value = tx.getValueSentToMe(this.w);
            TransactionInput input = tx.getInputs().get(0);
            Address from = input.getFromAddress();
            System.out.println("Received " + Utils.bitcoinValueToFriendlyString(value) + " from " + from.toString());
            Transaction sendTx = this.w.sendCoins(this.peerGroup, from, value);
            assert (sendTx != null);
            System.out.println("Sent coins back! Transaction hash is " + sendTx.getHashAsString());
            this.w.saveToFile(this.walletFile);
        }
        catch (ScriptException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

