/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.examples;

import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.TCPNetworkConnection;
import com.google.bitcoin.discovery.DnsDiscovery;
import com.google.bitcoin.discovery.IrcDiscovery;
import com.google.bitcoin.discovery.PeerDiscoveryException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class PrintPeers {
    private static InetSocketAddress[] dnsPeers;
    private static InetSocketAddress[] ircPeers;

    private static void printElapsed(long start) {
        long now = System.currentTimeMillis();
        System.out.println(String.format("Took %.2f seconds", (double)(now - start) / 1000.0));
    }

    private static void printPeers(InetSocketAddress[] addresses) {
        for (InetSocketAddress address : addresses) {
            String hostAddress = address.getAddress().getHostAddress();
            System.out.println(String.format("%s:%d", hostAddress.toString(), address.getPort()));
        }
    }

    private static void printIRC() throws PeerDiscoveryException {
        long start = System.currentTimeMillis();
        IrcDiscovery d = new IrcDiscovery("#bitcoin"){

            protected void onIRCReceive(String message) {
                System.out.println("<- " + message);
            }

            protected void onIRCSend(String message) {
                System.out.println("-> " + message);
            }
        };
        ircPeers = d.getPeers();
        PrintPeers.printPeers(ircPeers);
        PrintPeers.printElapsed(start);
    }

    private static void printDNS() throws PeerDiscoveryException {
        long start = System.currentTimeMillis();
        DnsDiscovery dns = new DnsDiscovery(NetworkParameters.prodNet());
        dnsPeers = dns.getPeers();
        PrintPeers.printPeers(dnsPeers);
        PrintPeers.printElapsed(start);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("=== IRC ===");
        PrintPeers.printIRC();
        System.out.println("=== DNS ===");
        PrintPeers.printDNS();
        System.out.println("=== Version/chain heights ===");
        ExecutorService pool = Executors.newFixedThreadPool(100);
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        for (InetSocketAddress peer : dnsPeers) {
            addrs.add(peer.getAddress());
        }
        for (InetSocketAddress peer : ircPeers) {
            addrs.add(peer.getAddress());
        }
        System.out.println("Scanning " + addrs.size() + " peers:");
        final Object lock = new Object();
        final long[] bestHeight = new long[1];
        for (final InetAddress addr : addrs) {
            pool.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        TCPNetworkConnection conn = new TCPNetworkConnection(addr, NetworkParameters.prodNet(), 0, 1000);
                        Object object = lock;
                        synchronized (object) {
                            long nodeHeight = conn.getVersionMessage().bestHeight;
                            long diff = bestHeight[0] - nodeHeight;
                            if (diff > 0L) {
                                System.out.println("Node is behind by " + diff + " blocks: " + addr.toString());
                            } else {
                                bestHeight[0] = nodeHeight;
                            }
                        }
                        conn.shutdown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        pool.awaitTermination(86400L, TimeUnit.SECONDS);
    }
}

