/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.examples;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.Base58;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.DumpedPrivateKey;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerGroup;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.MemoryBlockStore;
import java.math.BigInteger;
import java.net.InetAddress;

public class PrivateKeys {
    public static void main(String[] args) throws Exception {
        NetworkParameters params = NetworkParameters.prodNet();
        try {
            ECKey key;
            if (args[0].length() == 51) {
                DumpedPrivateKey dumpedPrivateKey = new DumpedPrivateKey(params, args[0]);
                key = dumpedPrivateKey.getKey();
            } else {
                BigInteger privKey = Base58.decodeToBigInteger(args[0]);
                key = new ECKey(privKey);
            }
            System.out.println("Address from private key is: " + key.toAddress(params).toString());
            Address destination = new Address(params, args[1]);
            Wallet wallet = new Wallet(params);
            wallet.addKey(key);
            MemoryBlockStore blockStore = new MemoryBlockStore(params);
            BlockChain chain = new BlockChain(params, wallet, (BlockStore)blockStore);
            PeerGroup peerGroup = new PeerGroup(params, chain);
            peerGroup.addAddress(new PeerAddress(InetAddress.getLocalHost()));
            peerGroup.start();
            peerGroup.downloadBlockChain();
            peerGroup.stop();
            System.out.println("Claiming " + Utils.bitcoinValueToFriendlyString(wallet.getBalance()) + " coins");
            wallet.sendCoins(peerGroup, destination, wallet.getBalance());
            Thread.sleep(5000L);
            System.exit(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("First arg should be private key in Base58 format. Second argument should be address to send to.");
            return;
        }
    }
}

