/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.examples.toywallet;

import com.google.bitcoin.core.AbstractPeerEventListener;
import com.google.bitcoin.core.AbstractWalletEventListener;
import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Peer;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerGroup;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.discovery.DnsDiscovery;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BoundedOverheadBlockStore;
import com.google.bitcoin.utils.BriefLogFormatter;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.bouncycastle.util.encoders.Hex;

public class ToyWallet {
    private final TxListModel txListModel = new TxListModel();
    private JList txList;
    private NetworkParameters params;
    private Wallet wallet;
    private PeerGroup peerGroup;
    private BlockChain chain;
    private JLabel networkStats;
    private File walletFile;
    private JScrollPane txScrollPane;

    public static void main(String[] args) throws Exception {
        BriefLogFormatter.init();
        new ToyWallet(false, args);
    }

    public ToyWallet(boolean testnet, String[] args) throws Exception {
        this.params = testnet ? NetworkParameters.testNet() : NetworkParameters.prodNet();
        boolean freshWallet = false;
        this.walletFile = new File("toy.wallet");
        try {
            this.wallet = Wallet.loadFromFile(this.walletFile);
        }
        catch (IOException e) {
            ECKey key;
            this.wallet = new Wallet(this.params);
            if (args.length > 0) {
                try {
                    String[] parts = args[0].split(":");
                    byte[] pubKey = Hex.decode((String)parts[0]);
                    key = new ECKey(null, pubKey);
                    long creationTimeSeconds = Long.parseLong(parts[1]);
                    key.setCreationTimeSeconds(creationTimeSeconds);
                    System.out.println(String.format("Using address from command line %s, created on %s", key.toAddress(this.params).toString(), new Date(creationTimeSeconds * 1000L).toString()));
                }
                catch (Exception e2) {
                    System.err.println("Could not understand argument. Try a hex encoded pub key with a creation time in seconds appended with a colon in between: " + e2.toString());
                    return;
                }
            } else {
                key = new ECKey();
            }
            this.wallet.keychain.add(key);
            this.wallet.saveToFile(this.walletFile);
            freshWallet = true;
        }
        System.out.println("Send to: " + this.wallet.keychain.get(0).toAddress(this.params));
        System.out.println(this.wallet);
        File blockChainFile = new File("toy.blockchain");
        if (!blockChainFile.exists() && !freshWallet) {
            this.wallet.clearTransactions(0);
        }
        this.chain = new BlockChain(this.params, this.wallet, (BlockStore)new BoundedOverheadBlockStore(this.params, blockChainFile));
        this.peerGroup = new PeerGroup(this.params, this.chain);
        this.peerGroup.setUserAgent("ToyWallet", "1.0");
        if (testnet) {
            this.peerGroup.addAddress(new PeerAddress(InetAddress.getByName("plan99.net"), 18333));
            this.peerGroup.addAddress(new PeerAddress(InetAddress.getByName("localhost"), 18333));
        } else {
            this.peerGroup.addPeerDiscovery(new DnsDiscovery(this.params));
        }
        this.peerGroup.addWallet(this.wallet);
        this.peerGroup.setFastCatchupTimeSecs(this.wallet.getEarliestKeyCreationTime());
        this.peerGroup.addEventListener(new AbstractPeerEventListener(){

            public void onPeerConnected(Peer peer, int peerCount) {
                super.onPeerConnected(peer, peerCount);
                ToyWallet.this.triggerNetworkStatsUpdate();
            }

            public void onPeerDisconnected(Peer peer, int peerCount) {
                super.onPeerDisconnected(peer, peerCount);
                ToyWallet.this.triggerNetworkStatsUpdate();
            }

            public void onBlocksDownloaded(Peer peer, Block block, int blocksLeft) {
                super.onBlocksDownloaded(peer, block, blocksLeft);
                ToyWallet.this.triggerNetworkStatsUpdate();
                ToyWallet.this.handleNewBlock();
            }
        });
        this.wallet.addEventListener(new AbstractWalletEventListener(){

            public void onCoinsReceived(Wallet wallet, Transaction tx, BigInteger prevBalance, BigInteger newBalance) {
                super.onCoinsReceived(wallet, tx, prevBalance, newBalance);
                ToyWallet.this.handleNewTransaction(tx);
            }

            public void onCoinsSent(Wallet wallet, Transaction tx, BigInteger prevBalance, BigInteger newBalance) {
                super.onCoinsSent(wallet, tx, prevBalance, newBalance);
                ToyWallet.this.handleNewTransaction(tx);
            }

            public void onChange() {
                try {
                    System.out.println("Wallet changed");
                    ToyWallet.this.wallet.saveToFile(ToyWallet.this.walletFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        JFrame window = new JFrame("Toy wallet");
        window.setDefaultCloseOperation(3);
        this.setupWindow(window);
        window.pack();
        window.setSize(640, 480);
        final Set<Transaction> walletTransactions = this.wallet.getTransactions(true, true);
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                for (Transaction tx : walletTransactions) {
                    ToyWallet.this.txListModel.monitorTx(tx);
                }
            }
        });
        window.setVisible(true);
        this.peerGroup.start();
        this.peerGroup.downloadBlockChain();
    }

    private void handleNewBlock() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToyWallet.this.txListModel.newBlock();
            }
        });
    }

    private void handleNewTransaction(final Transaction t) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToyWallet.this.txListModel.monitorTx(t);
            }
        });
    }

    private void triggerNetworkStatsUpdate() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int numPeers = ToyWallet.this.peerGroup.numConnectedPeers();
                StoredBlock chainHead = ToyWallet.this.chain.getChainHead();
                String date = chainHead.getHeader().getTime().toString();
                String plural = numPeers > 1 ? "peers" : "peer";
                String status = String.format("%d %s connected. %d blocks: %s", numPeers, plural, chainHead.getHeight(), date);
                ToyWallet.this.networkStats.setText(status);
            }
        });
    }

    private void setupWindow(JFrame window) {
        JLabel instructions = new JLabel("<html>Broadcast transactions appear below. Watch them gain confidence.<br>Send coins to: <b>" + this.wallet.keychain.get(0).toAddress(this.params) + "</b>");
        window.getContentPane().add((Component)instructions, "North");
        this.txList = new JList(this.txListModel);
        this.txList.setCellRenderer(new TxListLabel());
        this.txList.setSelectionMode(1);
        this.txList.setLayoutOrientation(0);
        this.txScrollPane = new JScrollPane(this.txList);
        window.getContentPane().add((Component)this.txScrollPane, "Center");
        this.networkStats = new JLabel("Connecting to the Bitcoin network ...");
        window.getContentPane().add((Component)this.networkStats, "South");
    }

    private class TxListLabel
    extends JLabel
    implements ListCellRenderer {
        private TxListLabel() {
        }

        public Component getListCellRendererComponent(JList list, Object contents, int index, boolean isSelected, boolean cellHasFocus) {
            String value = (String)contents;
            String key = ((ToyWallet)ToyWallet.this).wallet.keychain.get(0).toAddress(ToyWallet.this.params).toString();
            value = "<html>" + value.replaceAll("\n", "<br>").replaceAll("<br> ", "<br>&nbsp;&nbsp;").replaceAll(key, "<i>" + key + "</i>");
            this.setText(value);
            this.setOpaque(true);
            this.setBackground(index % 2 == 1 ? new Color(230, 230, 230) : Color.WHITE);
            return this;
        }
    }

    private class TxListModel
    extends AbstractListModel {
        private List<Transaction> transactions = new ArrayList<Transaction>();

        private TxListModel() {
        }

        public void monitorTx(Transaction tx) {
            assert (SwingUtilities.isEventDispatchThread());
            this.transactions.add(tx);
            tx.getConfidence().addEventListener(new TransactionConfidence.Listener(){

                public void onConfidenceChanged(Transaction tx) {
                    int txIndex = TxListModel.this.transactions.indexOf(tx);
                    TxListModel.this.fireContentsChanged(this, txIndex, txIndex);
                }
            });
            this.fireIntervalAdded(this, this.transactions.size() - 1, this.transactions.size() - 1);
        }

        public int getSize() {
            return this.transactions.size();
        }

        public Object getElementAt(int i) {
            Transaction tx = this.transactions.get(i);
            return tx.toString() + "\n" + tx.getConfidence().toString();
        }

        public void newBlock() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }
}

