/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class BriefLogFormatter
extends Formatter {
    private static final MessageFormat messageFormat = new MessageFormat("{3,date,hh:mm:ss} {0} {1}.{2}: {4}\n{5}");

    public static void init() {
        LogManager.getLogManager().getLogger("").getHandlers()[0].setFormatter(new BriefLogFormatter());
    }

    public static void initVerbose() {
        Logger logger = LogManager.getLogManager().getLogger("");
        logger.getHandlers()[0].setFormatter(new BriefLogFormatter());
        logger.setLevel(Level.FINEST);
        logger.log(Level.FINE, "test");
    }

    public String format(LogRecord logRecord) {
        Object[] arguments = new Object[6];
        arguments[0] = logRecord.getThreadID();
        String fullClassName = logRecord.getSourceClassName();
        int lastDot = fullClassName.lastIndexOf(46);
        String className = fullClassName.substring(lastDot + 1);
        arguments[1] = className;
        arguments[2] = logRecord.getSourceMethodName();
        arguments[3] = new Date(logRecord.getMillis());
        arguments[4] = logRecord.getMessage();
        if (logRecord.getThrown() != null) {
            StringWriter result = new StringWriter();
            logRecord.getThrown().printStackTrace(new PrintWriter(result));
            arguments[5] = ((Object)result).toString();
        } else {
            arguments[5] = "";
        }
        return messageFormat.format(arguments);
    }
}

