/*
 * Decompiled with CFR 0.152.
 */
package bar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BARModel {
    public String getBlockChainData(File f) throws FileNotFoundException, Exception {
        ArrayList<String> hashes = new ArrayList<String>();
        Scanner sc = new Scanner(f);
        while (sc.hasNext()) {
            String hash = sc.next();
            hashes.add(hash);
        }
        return this.getBlockChainData(hashes);
    }

    public String getBlockChainData(String hash) throws Exception {
        ArrayList<String> hashes = new ArrayList<String>();
        hashes.add(hash);
        return this.getBlockChainData(hashes);
    }

    private String getBlockChainData(List<String> hashes) throws Exception {
        String data = "";
        try {
            for (String hash : hashes) {
                String line;
                URL url = new URL("http://blockexplorer.com/rawtx/" + hash);
                InputStream is = url.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String downloadedData = "";
                while ((line = br.readLine()) != null) {
                    downloadedData = downloadedData + line;
                }
                data = data + this.parseTransaction(downloadedData);
            }
            String dataByteString = "";
            Scanner sc = new Scanner(data);
            while (sc.hasNext()) {
                String word = sc.next();
                if (word.startsWith("OP_")) continue;
                dataByteString = dataByteString + word;
            }
            byte[] dataByte = this.hexStringToByteArray(dataByteString);
            int dataLength = 0;
            dataLength = dataByte[0] & 0xFF;
            dataLength += (dataByte[1] & 0xFF) << 8;
            dataLength += (dataByte[2] & 0xFF) << 16;
            String result = new String(dataByte, 4, dataLength += (dataByte[3] & 0xFF) << 24);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception();
        }
    }

    private String parseTransaction(String downloadedData) {
        JSONObject json = new JSONObject();
        String data = "";
        try {
            json = (JSONObject)new JSONParser().parse(downloadedData);
            JSONArray outs = (JSONArray)json.get("out");
            for (Object outO : outs) {
                JSONObject out = (JSONObject)outO;
                String scriptPubKey = (String)out.get("scriptPubKey");
                if (scriptPubKey.lastIndexOf("OP_DROP") > -1) {
                    int pos = scriptPubKey.lastIndexOf("OP_DROP");
                    scriptPubKey = scriptPubKey.substring(0, pos);
                }
                data = data + " " + scriptPubKey;
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        return data;
    }

    private byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
        }
        return b;
    }
}

