/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package bar;

import java.io.*;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/**
 *
 * @author Albert
 */
public class BARModel {
    
    
    public String getBlockChainData(File f) throws FileNotFoundException, Exception {
        ArrayList<String> hashes = new ArrayList<String>();
        
        Scanner sc = new Scanner(f);
        while(sc.hasNext()) {
            String hash = sc.next();
            hashes.add(hash);
        }
        
        return getBlockChainData(hashes);
    }
    
    public String getBlockChainData(String hash) throws Exception {
        ArrayList<String> hashes = new ArrayList<String>();
        hashes.add(hash);
        return getBlockChainData(hashes);
    }
    
    private String getBlockChainData(List<String> hashes) throws Exception {
        String data = "";

        try {
            for (String hash : hashes) {
                URL url = new URL("http://blockexplorer.com/rawtx/" + hash);
                InputStream is = url.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));

                String downloadedData = "";
                String line;
                while ((line = br.readLine()) != null) {
                    downloadedData = downloadedData + line;
                }

                data = data + parseTransaction(downloadedData);
            }
            
            String dataByteString = "";
            Scanner sc = new Scanner(data);
            while(sc.hasNext()) {
                String word = sc.next();
                if (!word.startsWith("OP_")) {
                    dataByteString = dataByteString+word;
                }
            }
            byte[] dataByte = hexStringToByteArray(dataByteString);
            
            int dataLength = 0;
            dataLength =  (dataByte[0] & 0xff);
            dataLength += (dataByte[1] & 0xff) << 8;
            dataLength += (dataByte[2] & 0xff) << 16;
            dataLength += (dataByte[3] & 0xff) << 24;
            
            String result = new String(dataByte, 4, dataLength);
            
            return result;

        } catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception();
            //return "";
        }
        
    }

    private String parseTransaction(String downloadedData) {
        JSONObject json = new JSONObject();
        String data = "";
        
        try {
            json = (JSONObject) new JSONParser().parse(downloadedData);
            JSONArray outs = (JSONArray) json.get("out");
            for (Object outO : outs) {
                JSONObject out = (JSONObject) outO;
                String scriptPubKey = (String) out.get("scriptPubKey");
                
                // dekodujeme to celkom jednoducho.... ak ide o "script kodovanie" tak musime vymazat vsetko po poslednom OP_DROP
                if (scriptPubKey.lastIndexOf("OP_DROP") > -1) {
                    int pos = scriptPubKey.lastIndexOf("OP_DROP");
                    scriptPubKey = scriptPubKey.substring(0, pos);
                }
                data = data + " " + scriptPubKey;
            }
        } catch (ParseException ex) {
            ex.printStackTrace();
        }
        
        return data;
    }

    private byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; i++) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte) v;
        }
        return b;
    }
}
