/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package baw;

import com.google.bitcoin.core.TransactionConfidence.ConfidenceType;
import com.google.bitcoin.core.*;
import com.google.bitcoin.discovery.DnsDiscovery;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.store.BoundedOverheadBlockStore;
import java.io.*;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.*;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

/**
 *
 * @author Albert
 */
public class BAWModel extends Observable implements Runnable {
    private NetworkParameters params;
    private Wallet wallet;
    private PeerGroup peerGroup;
    private BlockChain blockChain;
    private File walletFile;
    
    private boolean FTRPconnected;
    
    public BAWModel() throws IOException, BlockStoreException {
        // Chceme sa napojit na normalnu siet
        params = NetworkParameters.prodNet();
        
        //nainicializujeme premenne
        FTRPconnected = false;
        
        // penazenku vytvorime/nacitame
        boolean freshWallet = false;
        walletFile = new File("baw.wallet");
        try {
            wallet = Wallet.loadFromFile(walletFile);
        } catch (IOException e) {
            wallet = new Wallet(params);

            ECKey key = new ECKey();  // vytvorime novu dvojicu kulocov
            wallet.keychain.add(key);
            
            wallet.saveToFile(walletFile);
            freshWallet = true;
        }
        System.out.println("Send to: " + wallet.keychain.get(0).toAddress(params));
        System.out.println(wallet);
        
        // vytvorime triedy pre blockchain
        File blockChainFile = new File("baw.blockchain");
        if (!blockChainFile.exists() && !freshWallet) {
            // Neexistuje subor s blockchainom, ale penazenku sme uz mali vytvorenu. Treba zmazat transakcie z penazenkzy, aby sa dali znova nacitat bloky/transakcie (penazenka nepodporuje znovunahranie transakcie, treba ich vymazat)
            wallet.clearTransactions(0);
        }
        blockChain = new BlockChain(params, wallet, new BoundedOverheadBlockStore(params, blockChainFile));
        
        // vytvorime triedy pre peery
        peerGroup = new PeerGroup(params, blockChain);
        peerGroup.setUserAgent("BAW", "1.0");
        peerGroup.addPeerDiscovery(new DnsDiscovery(params));
        peerGroup.addWallet(wallet);
        peerGroup.setFastCatchupTimeSecs(wallet.getEarliestKeyCreationTime());

        // nastavit reagovanie na rozne eventy
        peerGroup.addEventListener(new AbstractPeerEventListener() {
            @Override
            public void onBlocksDownloaded(Peer peer, Block block, int blocksLeft) {
                super.onBlocksDownloaded(peer, block, blocksLeft);
                setChanged();
                notifyObservers();
            }

            @Override
            public void onPeerConnected(Peer peer, int peerCount) {
                super.onPeerConnected(peer, peerCount);
                System.out.println("Connected to: " + peer);
                String peerStr = peer.toString();
                if (peerStr.indexOf("173.242.112.53:8333")>-1) {
                    FTRPnodeConnected();
                }
                else {
                    setChanged();
                    notifyObservers();
                }
            }

            @Override
            public void onPeerDisconnected(Peer peer, int peerCount) {
                super.onPeerDisconnected(peer, peerCount);
                System.out.println("Disconnected from: " + peer);
                String peerStr = peer.toString();
                if (peerStr.indexOf("173.242.112.53:8333")>-1) {
                    FTRPnodeDisconnected();
                }
                else {
                    setChanged();   
                    notifyObservers();
                }
            }
        });
        
        // nastavime reagovanie na wallet eventy
        wallet.addEventListener(new AbstractWalletEventListener() {
            @Override
            public void onChange() {
                try {
                    System.out.println("Wallet changed");
                    wallet.saveToFile(walletFile);
                    System.out.println("Wallet saved");
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
                setChanged();
                notifyObservers();
            }

            @Override
            public void onCoinsReceived(Wallet wallet, Transaction tx, BigInteger prevBalance, BigInteger newBalance) {
                super.onCoinsReceived(wallet, tx, prevBalance, newBalance);
                setChanged();
                notifyObservers();
            }

            @Override
            public void onCoinsSent(Wallet wallet, Transaction tx, BigInteger prevBalance, BigInteger newBalance) {
                super.onCoinsSent(wallet, tx, prevBalance, newBalance);
                setChanged();
                notifyObservers();
            }

            @Override
            public void onReorganize(Wallet wallet) {
                super.onReorganize(wallet);
                setChanged();
                notifyObservers();
            }

            @Override
            public void onTransactionConfidenceChanged(Wallet wallet, Transaction tx) {
                super.onTransactionConfidenceChanged(wallet, tx);
                setChanged();
                notifyObservers();
            }
            
        });
        
        // nastavime pocet uzlov
        peerGroup.setMaxConnections(4);
    }
    
    public void start() {
        System.out.println("startuje");
        peerGroup.start();
        System.out.println("nacitavame blockchain");
        peerGroup.downloadBlockChain();
    }

    private void FTRPnodeDisconnected() {
        FTRPconnected = false;
        setChanged();
        notifyObservers();
    }

    private void FTRPnodeConnected() {
        FTRPconnected = true;
        setChanged();
        notifyObservers();
    }
    
    public String getMainAddress() {
        return wallet.keychain.get(0).toAddress(params).toString();
    }
    
    /*
     * Vrati, kolko Bitcoinov je v penazenke. Hodnotu vracia v Satoshi (10^-8).
     */
    public BigInteger getWalletBalance() {
        return wallet.getBalance();
    }
    
    public String getBlockChainInfo() {
        return "#" + blockChain.getChainHead().getHeight() + " (" + blockChain.getChainHead().getHeader().getTime().toString() + ")";
    }
    
    public int getNumConnectedPeers() {
        return peerGroup.numConnectedPeers();
    }
    
    public int getMaxConnectedPeers() {
        return peerGroup.getMaxConnections();
    }
    
    public boolean isConnectedToFTRPnode() {
        return FTRPconnected;
    }

    @Override
    public void run() {
        start();
    }

    public void setNumberOfPeers(int number) {
        peerGroup.setMaxConnections(number);
    }

    public void connectToFTRPnode() {
        //System.out.println("connectToFTRPnode");
        try {
            Peer peer = new Peer(params, new PeerAddress(InetAddress.getByName("173.242.112.53")), blockChain);
            peer.connect();
            if (peerGroup.numConnectedPeers() == peerGroup.getMaxConnections()) {
                peerGroup.setMaxConnections(peerGroup.getMaxConnections()+1);
            }
            peerGroup.addPeer(peer);
        } catch (PeerException ex) {
            ex.printStackTrace();
        } catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<TransactionBlockHelperClass> getWalletTransactions() {
        ArrayList<TransactionBlockHelperClass> data = new ArrayList<TransactionBlockHelperClass>();
        
        Set<Transaction> walletTransactions = wallet.getTransactions(true, true);
        for (Transaction tx : walletTransactions) {
            int appearedAtBlock = -1;
            String confidenceString = "";
            if (tx.hasConfidence()) {
                try {
                    appearedAtBlock = tx.getConfidence().getAppearedAtChainHeight();
                } catch (IllegalStateException ex) {
                }
                ConfidenceType confidenceType = tx.getConfidence().getConfidenceType();
                switch (confidenceType) {
                    case BUILDING:
                        confidenceString = "v blokovej vetve";
                        break;
                    case NOT_IN_BEST_CHAIN:
                        confidenceString = "nie v najlepsej vetve";
                        break;
                    case NOT_SEEN_IN_CHAIN:
                        confidenceString = "nie je v blokovej vetve";
                        break;
                    case OVERRIDDEN_BY_DOUBLE_SPEND:
                        confidenceString = "obet double spendingu";
                        break;
                    case UNKNOWN:
                        confidenceString = "neznamy";
                        break;
                }
            }
            TransactionBlockHelperClass tbhc = new TransactionBlockHelperClass(tx.getHashAsString(), appearedAtBlock, confidenceString);
            data.add(tbhc);
        }
        
        return data;
    }

    /*
     * preposlanie vsetkzch Bitcoinov z penazenky na adresu
     */
    public void sendTheWholeWallet(String addressStr) throws AddressFormatException, IOException, InsufficientFunds {
        Address targetAddress = new Address(params, addressStr);
        Transaction tx = wallet.sendCoinsAsync(peerGroup, targetAddress, wallet.getBalance());
        if (tx==null) {
            throw new InsufficientFunds(new BigInteger("0"));
        }
        //System.out.println(tx.toString());
    }
    
    public String saveDataInAddressTry(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException{
        TransactionDataSaveInfo dataSaveInfo = saveDataInAddress(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, transactionFee, transactionFeeType, false);
        
        return "Skutocne chcete ulozit udaje? Celkovo sa na data minie " + dataSaveInfo.getSumOutputPrice() + " Satoshi, na transakcne poplatky sa minie " + dataSaveInfo.getSumFee() + " Satoshi .";
    }
    
    public void saveDataInAddressExecute(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException{
        saveDataInAddress(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, transactionFee, transactionFeeType, true);
    }

    /*
     * Vlozenie dat do transakcii - ukalda sa do vystupnych adries
     */
    private TransactionDataSaveInfo saveDataInAddress(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType, boolean execute) throws InsufficientFunds, NotImplementedException, IOException{
        BigInteger sumOutputPrice = BigInteger.ZERO;
        BigInteger sumFee = BigInteger.ZERO;
        int numPieces = 0;
        
        byte[] messageBytes = convertToMessageBytes(transactionData);
        List<byte[]> pieces = divideIntoPieces(messageBytes, transactionMaxSize, "address");
        numPieces = pieces.size();
                
        List<Transaction> txs = new ArrayList<Transaction>();
        
        // Kvoli problemom s bitcoinj nebudeme podporovat take dlhe data, ktore by potrebovali viac transakcii
        if (pieces.size()>1) throw  new NotImplementedException();
        
        for (byte[] piece : pieces) {
            byte[] pieceWithSize = prependPieceSize(piece);
            
            Transaction tx = new Transaction(params);
            
            BigInteger txOutputPrice = addDataAddressOutputs(tx, pieceWithSize, outputPrice);
            sumOutputPrice = sumOutputPrice.add(txOutputPrice);
            
            BigInteger fee = calculateNeededFee(tx, transactionFee, transactionFeeType);
            sumFee = sumFee.add(fee);
            boolean b = completeTxWithFee(tx, fee);

            if (b) {
                
                ///////////////// pomocne vypisy
                System.out.println(tx);
                for (TransactionOutput to : tx.getOutputs()) {
                    try {
                        byte[] hash = to.getScriptPubKey().getToAddress().getHash160();
                        for (int i=0; i<hash.length; i++) {
                            int actByte = hash[i] & 0xff;
                            System.out.print(actByte + " ");       
                        }
                        String conv = new String(hash);
                        System.out.println(" " + conv);
                        byte[] scriptBytes = to.getScriptBytes();
                        for (int i = 0; i < scriptBytes.length; i++) {
                            int actByte = scriptBytes[i] & 0xff;
                            System.out.print(actByte + " ");
                        }
                        System.out.println();
                        //System.out.println(to.getScriptPubKey().getToAddress().getHash160());
                    } catch (ScriptException ex) {
                        ex.printStackTrace();
                    }
                }
                //////////////////
                
                
                txs.add(tx);
            }
            else {
                return null;
            }
            
        }
        
        if (execute) {

            FileWriter fstream = new FileWriter(infoSaveLocation);
            BufferedWriter out = new BufferedWriter(fstream);
            for (Transaction transaction : txs) {
                out.write(transaction.getHashAsString() + " ");
            }
            out.close();

            
            for (Transaction transaction : txs) {
                peerGroup.broadcastTransaction(transaction);
                try {
                    wallet.commitTx(transaction);
                } catch (VerificationException ex) {
                    System.out.println("POZOR!!!! VerificationException");
                    ex.printStackTrace();
                }
            }
             
        }
        
        TransactionDataSaveInfo dataSaveInfo = new TransactionDataSaveInfo(sumOutputPrice, sumFee, numPieces);
            
        return dataSaveInfo;
    }
    
    public String saveDataInPubKeyTry(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException{
        TransactionDataSaveInfo dataSaveInfo = saveDataInPubKey(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, transactionFee, transactionFeeType, false);
        
        return "Skutocne chcete ulozit udaje? Celkovo sa na data minie " + dataSaveInfo.getSumOutputPrice() + " Satoshi, na transakcne poplatky sa minie " + dataSaveInfo.getSumFee() + " Satoshi .";
    }
    
    public void saveDataInPubKeyExecute(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException{
        saveDataInPubKey(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, transactionFee, transactionFeeType, true);
    }
    
    /*
     * Vlozenie dat do transakcii - ukalda sa ako vystupne verejne kluce
     */
    private TransactionDataSaveInfo saveDataInPubKey(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, BigInteger transactionFee, String transactionFeeType, boolean execute) throws InsufficientFunds, NotImplementedException, IOException{
        BigInteger sumOutputPrice = BigInteger.ZERO;
        BigInteger sumFee = BigInteger.ZERO;
        int numPieces = 0;
        
        byte[] messageBytes = convertToMessageBytes(transactionData);
        List<byte[]> pieces = divideIntoPieces(messageBytes, transactionMaxSize, "pubkey");
        numPieces = pieces.size();
                
        List<Transaction> txs = new ArrayList<Transaction>();
        
        // Kvoli problemom s bitcoinj nebudeme podporovat take dlhe data, ktore by potrebovali viac transakcii
        if (pieces.size()>1) throw  new NotImplementedException();
        
        for (byte[] piece : pieces) {
            byte[] pieceWithSize = prependPieceSize(piece);
            
            Transaction tx = new Transaction(params);
            
            BigInteger txOutputPrice = addDataPubKeyOutputs(tx, pieceWithSize, outputPrice);
            sumOutputPrice = sumOutputPrice.add(txOutputPrice);
            
            BigInteger fee = calculateNeededFee(tx, transactionFee, transactionFeeType);
            sumFee = sumFee.add(fee);
            boolean b = completeTxWithFee(tx, fee);

            if (b) {
                
                ///////////////// pomocne vypisy
                System.out.println(tx);
                for (TransactionOutput to : tx.getOutputs()) {
                    byte[] scriptBytes = to.getScriptBytes();
                    for (int i = 0; i < scriptBytes.length; i++) {
                        int actByte = scriptBytes[i] & 0xff;
                        System.out.print(actByte + " ");
                    }
                    String conv = new String(scriptBytes);
                    System.out.println(" " + conv);
                }
                //////////////////
                
                
                txs.add(tx);
            }
            else {
                return null;
            }
            
        }
        
        if (execute) {

            FileWriter fstream = new FileWriter(infoSaveLocation);
            BufferedWriter out = new BufferedWriter(fstream);
            for (Transaction transaction : txs) {
                out.write(transaction.getHashAsString() + " ");
            }
            out.close();

            
            for (Transaction transaction : txs) {
                peerGroup.broadcastTransaction(transaction);
                try {
                    wallet.commitTx(transaction);
                } catch (VerificationException ex) {
                    System.out.println("POZOR!!!! VerificationException");
                    ex.printStackTrace();
                }
            }
             
        }
        
        TransactionDataSaveInfo dataSaveInfo = new TransactionDataSaveInfo(sumOutputPrice, sumFee, numPieces);
            
        return dataSaveInfo;
    }
    
    public String saveDataInScriptTry(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, String outputAddress, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException, AddressFormatException{
        TransactionDataSaveInfo dataSaveInfo = saveDataInScript(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, outputAddress, transactionFee, transactionFeeType, false);
        
        return "Skutocne chcete ulozit udaje? Celkovo sa na data minie " + dataSaveInfo.getSumOutputPrice() + " Satoshi, na transakcne poplatky sa minie " + dataSaveInfo.getSumFee() + " Satoshi .";
    }
    
    public void saveDataInScriptExecute(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, String outputAddress, BigInteger transactionFee, String transactionFeeType) throws InsufficientFunds, NotImplementedException, IOException, AddressFormatException{
        saveDataInScript(transactionData, infoSaveLocation, transactionMaxSize, outputPrice, outputAddress, transactionFee, transactionFeeType, true);
    }
    
    /*
     * Vlozenie dat do transakcii - ukalda sa ako vystupne verejne kluce
     */
    private TransactionDataSaveInfo saveDataInScript(String transactionData, String infoSaveLocation, int transactionMaxSize, BigInteger outputPrice, String outputAddress, BigInteger transactionFee, String transactionFeeType, boolean execute) throws InsufficientFunds, NotImplementedException, IOException, AddressFormatException{
        BigInteger sumOutputPrice = BigInteger.ZERO;
        BigInteger sumFee = BigInteger.ZERO;
        int numPieces = 0;
        
        byte[] messageBytes = convertToMessageBytes(transactionData);
        List<byte[]> pieces = divideIntoPieces(messageBytes, transactionMaxSize, "script");
        numPieces = pieces.size();
                
        List<Transaction> txs = new ArrayList<Transaction>();
        
        // Kvoli problemom s bitcoinj nebudeme podporovat take dlhe data, ktore by potrebovali viac transakcii
        if (pieces.size()>1) throw  new NotImplementedException();
        
        for (byte[] piece : pieces) {
            byte[] pieceWithSize = prependPieceSize(piece);
            
            Transaction tx = new Transaction(params);
            
            BigInteger txOutputPrice = addDataScriptOutputs(tx, pieceWithSize, outputPrice, outputAddress);
            sumOutputPrice = sumOutputPrice.add(txOutputPrice);
            
            BigInteger fee = calculateNeededFee(tx, transactionFee, transactionFeeType);
            sumFee = sumFee.add(fee);
            boolean b = completeTxWithFee(tx, fee);

            if (b) {
                
                ///////////////// pomocne vypisy
                System.out.println(tx);
                for (TransactionOutput to : tx.getOutputs()) {
                    byte[] scriptBytes = to.getScriptBytes();
                    for (int i = 0; i < scriptBytes.length; i++) {
                        int actByte = scriptBytes[i] & 0xff;
                        System.out.print(actByte + " ");
                    }
                    String conv = new String(scriptBytes);
                    System.out.println(" " + conv);
                }
                //////////////////
                
                
                txs.add(tx);
            }
            else {
                return null;
            }
            
        }
        
        if (execute) {

            FileWriter fstream = new FileWriter(infoSaveLocation);
            BufferedWriter out = new BufferedWriter(fstream);
            for (Transaction transaction : txs) {
                out.write(transaction.getHashAsString() + " ");
            }
            out.close();

            
            for (Transaction transaction : txs) {
                peerGroup.broadcastTransaction(transaction);
                try {
                    wallet.commitTx(transaction);
                } catch (VerificationException ex) {
                    System.out.println("POZOR!!!! VerificationException");
                    ex.printStackTrace();
                }
            }
             
        }
        
        TransactionDataSaveInfo dataSaveInfo = new TransactionDataSaveInfo(sumOutputPrice, sumFee, numPieces);
            
        return dataSaveInfo;
    }

    private byte[] convertToMessageBytes(String transactionData) {
        return transactionData.getBytes();
    }

    private List<byte[]> divideIntoPieces(byte[] messageBytes, int transactionMaxSize, String saveType) {
        if (transactionMaxSize == 0) transactionMaxSize = 1000000 - 100000; // max blocksize - rezerva pre istotu
        int pieceSize = transactionMaxSize;
        
        if (saveType.equals("address")) {
            int maxSize = transactionMaxSize - 13 - 63 - 4; // hlavicka/pata transakcie, vstup, kodovanie piece length
            double numOutputsInTrans = (double) maxSize / (9 + 1 + 3 + 20 + 2);
            pieceSize = (int) Math.ceil(numOutputsInTrans * 20);
        }
        
        if (saveType.equals("pubkey")) {
            int maxSize = transactionMaxSize - 13 - 63 - 4; // hlavicka/pata transakcie, vstup, kodovanie piece length
            double numOutputsInTrans = (double) maxSize / (9 + 1 + 65 + 1);
            pieceSize = (int) Math.ceil(numOutputsInTrans * 65);
        }
        
        if (saveType.equals("script")) {
            int maxSize = transactionMaxSize - 13 - 63 - 4; // hlavicka/pata transakcie, vstup, kodovanie piece length
            double numOutputsInTrans = (double) maxSize / (9 + 19*(3+520+1) + 25);
            pieceSize = (int) Math.ceil(numOutputsInTrans * (19*520));
        }
        
        System.out.println("piece size: " + pieceSize);
        
        ArrayList<byte[]> pieces = new ArrayList<byte[]>();
        
        int from = 0;
        while (from<messageBytes.length) {
            int to=from+pieceSize;
            if (to>messageBytes.length) to = messageBytes.length;
            byte[] piece = Arrays.copyOfRange(messageBytes, from, to);
            pieces.add(piece);
            from+=pieceSize;
        }
 
        return pieces;
    }

    private byte[] prependPieceSize(byte[] piece) {
        // the size is in little endian
        
        int pl = piece.length;
        byte[] pieceWS = new byte[pl+4];
        pieceWS[0] = (byte) (pl & 255);
        pieceWS[1] = (byte) (pl >> 8 & 255);
        pieceWS[2] = (byte) (pl >> 16 & 255);
        pieceWS[3] = (byte) (pl >> 24 & 255);
        
        System.arraycopy(piece, 0, pieceWS, 4, pl);
        
        return pieceWS;
    }

    private BigInteger addDataAddressOutputs(Transaction tx, byte[] piece, BigInteger outputPrice) {
        BigInteger sumOutputPrice = BigInteger.ZERO;
        
        int startByte = 0;
        while (startByte<piece.length) {
            byte[] addrBytes = new byte[20];
            int length = Math.min(20, piece.length-startByte);
            System.arraycopy(piece, startByte, addrBytes, 0, length);
            Address addr = new Address(params, addrBytes);
            tx.addOutput(outputPrice, addr);
            sumOutputPrice = sumOutputPrice.add(outputPrice);
            
            startByte+=20;
        }
        
        return sumOutputPrice;
    }

    private BigInteger calculateNeededFee(Transaction tx, BigInteger transactionFee, String transactionFeeType) {
        BigInteger fee = new BigInteger("0");
        
        if (transactionFeeType.equals("output")) {
            int numOutputs = tx.getOutputs().size();
            fee = fee.add(transactionFee);
            fee = fee.multiply(new BigInteger(numOutputs+""));
        }
        
        if (transactionFeeType.equals("kB")) {
            int numBytes =  0 + 13 + 63; // hlavicka/pata, vstup
            List<TransactionOutput> txOuts = tx.getOutputs();
            for (TransactionOutput transactionOutput : txOuts) {
                numBytes += 8;
                int scriptLen = transactionOutput.getScriptBytes().length;
                numBytes += scriptLen;
                int lengthBytes = (scriptLen<256) ? 1:4; // nie je to presne ale pri vacsich spravach je zanedbatelny +- jeden bajt
                numBytes += lengthBytes;
            }
            
            fee = fee.add(transactionFee);
            fee = fee.multiply(new BigInteger(numBytes+""));
            fee = fee.divide(new BigInteger("1000"));
            
        }
        
        if (transactionFeeType.equals("fix")) {
            fee = fee.add(transactionFee);
        }
        
        return fee;
    }
    
    private boolean completeTxWithFee(Transaction tx, BigInteger fee) throws InsufficientFunds {
        return completeTxWithFee(tx, fee, wallet.keychain.get(0).toAddress(params));
    }

    private boolean completeTxWithFee(Transaction tx, BigInteger fee, Address changeAddress) throws InsufficientFunds {
        // Calculate the transaction total
        BigInteger satoshis = BigInteger.ZERO;
        satoshis = satoshis.add(fee);
        for(TransactionOutput output : tx.getOutputs()) {
            satoshis = satoshis.add(output.getValue());
        }
        
        //System.out.println("Completing send tx with " + tx.getOutputs().size() + " outputs an fee " + fee + " totalling " + satoshis);

        // To send money to somebody else, we need to do gather up transactions with unspent outputs until we have
        // sufficient value. Many coin selection algorithms are possible, we use a simple but suboptimal one.
        // TODO: Sort coins so we use the smallest first, to combat wallet fragmentation and reduce fees.
        BigInteger valueGathered = BigInteger.ZERO;
        List<TransactionOutput> gathered = new LinkedList<TransactionOutput>();
        Set<Transaction> transactions = wallet.getTransactions(false, false);
        for (Transaction t : transactions) {
            for (TransactionOutput output : t.getOutputs()) {
                //if (!output.isAvailableForSpending()) continue;  je to package metoda.... :(... musime pouzit workaround... napriklad pomocou reflection >:-)
                try {
                    Method isAvailableForSpending = TransactionOutput.class.getDeclaredMethod("isAvailableForSpending", null);

                    isAvailableForSpending.setAccessible(true);
                    boolean res = (Boolean) isAvailableForSpending.invoke(output, null);
                    if (!res) {
                        continue;
                    }
                } catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }

                
                if (!output.isMine(wallet)) continue;
                gathered.add(output);
                valueGathered = valueGathered.add(output.getValue());
            }
            // pozbierame vsetky vstupy, aby:
            // - sa moc nerozdelovali peniaze
            // - transakcie s vyssou stupnou hodnotou maju vacsiu prioritu
            //if (valueGathered.compareTo(satoshis) >= 0) break;
        }
        // Can we afford this?
        if (valueGathered.compareTo(satoshis) < 0) {
            //System.out.println("Insufficient value in wallet for send, chyba " + satoshis.subtract(valueGathered) + " Satoshi.");
            throw new InsufficientFunds(satoshis.subtract(valueGathered));
        }
        assert gathered.size() > 0;
        tx.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.NOT_SEEN_IN_CHAIN);
        BigInteger change = valueGathered.subtract(satoshis);
        if (change.compareTo(BigInteger.ZERO) > 0) {
            // The value of the inputs is greater than what we want to send. Just like in real life then,
            // we need to take back some coins ... this is called "change". Add another output that sends the change
            // back to us.
            //System.out.println("  with " + change + " coins change");
            tx.addOutput(change, changeAddress);
        }
        for (TransactionOutput output : gathered) {
            tx.addInput(output);
        }

        // Now sign the inputs, thus proving that we are entitled to redeem the connected outputs.
        try {
            tx.signInputs(Transaction.SigHash.ALL, wallet);
        } catch (ScriptException e) {
            // If this happens it means an output script in a wallet tx could not be understood. That should never
            // happen, if it does it means the wallet has got into an inconsistent state.
            System.out.println("Velky problem");
            throw new RuntimeException(e);
        }
        //System.out.println("  pripraveny " + tx.getHashAsString());
        return true;
    }

    private BigInteger addDataPubKeyOutputs(Transaction tx, byte[] piece, BigInteger outputPrice) {
        BigInteger sumOutputPrice = BigInteger.ZERO;
        int embeddedLength = 65;
        
        int startByte = 0;
        while (startByte<piece.length) {
            byte[] dataBytes = new byte[embeddedLength];
            int length = Math.min(embeddedLength, piece.length-startByte);
            System.arraycopy(piece, startByte, dataBytes, 0, length);
            
            byte[] scriptBytes = new byte[1+embeddedLength+1];

            scriptBytes[0]= (byte) embeddedLength;
            scriptBytes[66]= (byte) 172;
            System.arraycopy(dataBytes, 0, scriptBytes, 1, embeddedLength);
            
            tx.addOutput(new TransactionOutput(params, tx, outputPrice, scriptBytes));
            sumOutputPrice = sumOutputPrice.add(outputPrice);
            
            startByte+=embeddedLength;
        }
        
        return sumOutputPrice;
    }

    private BigInteger addDataScriptOutputs(Transaction tx, byte[] piece, BigInteger outputPrice, String outputAddress) throws IOException, AddressFormatException {
        final int maxScriptLen = 10000-25; // -25, aby bolo miesto na pripadnu adresu kam posielame vystup
        final int maxItemLen = 520;
        final int OP_DROP = 117;
        final int OP_DUP = 118;
        final int OP_HASH160 = 169;
        final int OP_EQUALVERIFY = 136;
        final int OP_CHECKSIG = 172;
        final int OP_PUSHDATA1 = 76;
        final int OP_PUSHDATA2 = 77;   
        final int OP_TRUE = 81;
        
        BigInteger sumOutputPrice = BigInteger.ZERO;
        
        int startByte = 0;
        while (startByte < piece.length) { // transaction outputs
            ByteArrayOutputStream transactionOutputScript = new ByteArrayOutputStream();

            ByteArrayOutputStream subPiece = new ByteArrayOutputStream();
            while (startByte < piece.length) { // transaction output script
                int subPieceDataLength = Math.min(maxItemLen, piece.length - startByte);
                byte[] subPieceData = new byte[subPieceDataLength];
                System.arraycopy(piece, startByte, subPieceData, 0, subPieceDataLength);

                if (subPieceDataLength < 256) {
                    subPiece.write(OP_PUSHDATA1);
                    subPiece.write(subPieceDataLength);
                } else {
                    subPiece.write(OP_PUSHDATA2);
                    subPiece.write(subPieceDataLength);
                    subPiece.write(subPieceDataLength >> 8);
                }

                subPiece.write(subPieceData);

                subPiece.write(OP_DROP);

                if (transactionOutputScript.size() + subPiece.size() <= maxScriptLen) {
                    transactionOutputScript.write(subPiece.toByteArray());
                    startByte += subPieceDataLength;
                } else {
                    break;
                }
            }
            
            if (!outputAddress.equals("")) {
                Address addr = new Address(params, outputAddress);
                
                transactionOutputScript.write(OP_DUP);
                transactionOutputScript.write(OP_HASH160);
                transactionOutputScript.write(20);
                transactionOutputScript.write(addr.getHash160());
                transactionOutputScript.write(OP_EQUALVERIFY);
                transactionOutputScript.write(OP_CHECKSIG);
            }
            else {
                transactionOutputScript.write(OP_TRUE); // volne pouzitelny vystup.. bude zaujimave ci niekto to pouzije
            }
            
            tx.addOutput(new TransactionOutput(params, tx, outputPrice, transactionOutputScript.toByteArray()));
            sumOutputPrice = sumOutputPrice.add(outputPrice);
        }
        
        return sumOutputPrice;
    }
    
    public void resendAllPendingTransactions() {
        Set<Transaction> transactions = wallet.getTransactions(false, false);
        for (Transaction transaction : transactions) {
            if (transaction.getConfidence().getConfidenceType()==ConfidenceType.NOT_SEEN_IN_CHAIN) {
                System.out.println("rebroadcasting " + transaction.getHashAsString());
                peerGroup.broadcastTransaction(transaction);
            }
        }
    }
    
    public void resetTheWallet() {
        wallet.clearTransactions(0);
        try {
            wallet.saveToFile(walletFile);
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }
    
}
