/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package baw;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author Albert
 */
public class TransactionTableVModel extends AbstractTableModel{
    protected ArrayList<TransactionBlockHelperClass> data = new ArrayList<TransactionBlockHelperClass>();
    private String[] columnNames = {"Transakcia", "Stav"};
    
    public void setData(ArrayList<TransactionBlockHelperClass> data) {
        this.data=data;
        fireTableDataChanged();
    }
    
    public TransactionBlockHelperClass getRowData(int row) {
        return data.get(row);
    }

    @Override
    public int getRowCount() {
        if (data==null) return 0;
        return data.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }
    
    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
    
    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0:
                return String.class;
            case 1:
                return String.class;
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TransactionBlockHelperClass row = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0:
                return row.getTxHash();
            case 1:
                return row.getConfidenceState() + ((row.getBlockNum()==-1) ? "" : ", "+row.getBlockNum());
        }
        return null;
    }
}
