/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.dots;

import java.util.LinkedList;
import sk.lenhardt.game.Position;

public class DotsAndBoxesPosition
extends Position {
    protected int x;
    protected int y;
    protected int range;
    protected long val;

    public DotsAndBoxesPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.range = x * (y - 1) + y * (x - 1);
        this.val = 0L;
    }

    public DotsAndBoxesPosition(int x, int y, boolean[] val) {
        this.x = x;
        this.y = y;
        this.range = x * (y - 1) + y * (x - 1);
        for (int i = 0; i < val.length; ++i) {
            if (!val[i]) continue;
            this.val += 1L << i;
        }
    }

    public DotsAndBoxesPosition(int x, int y, long val) {
        this.x = x;
        this.y = y;
        this.range = x * (y - 1) + y * (x - 1);
        this.val = val;
    }

    public boolean getIndex(int index) {
        if (index >= 0 && index < this.range) {
            return (this.val & 1L << index) != 0L;
        }
        return false;
    }

    public boolean isFinal() {
        for (int i = 0; i < this.y - 1; ++i) {
            for (int j = 0; j < this.x - 1; ++j) {
                int up = (this.y - 1) * j + i + 1;
                int down = (this.y - 1) * (j + 1) + i + 1;
                int left = this.x * (this.y - 1) + 1 + i + j * this.y;
                int right = this.x * (this.y - 1) + 2 + i + j * this.y;
                if (!this.getIndex(up - 1) || !this.getIndex(down - 1) || !this.getIndex(right - 1) || !this.getIndex(left - 1)) continue;
                return true;
            }
        }
        return false;
    }

    public Position[] getAllPossibleMoves() {
        if (this.isFinal()) {
            return new Position[0];
        }
        LinkedList<DotsAndBoxesPosition> ret = new LinkedList<DotsAndBoxesPosition>();
        for (int i = 0; i < this.range; ++i) {
            if (this.getIndex(i)) continue;
            long pom = this.val;
            ret.add(new DotsAndBoxesPosition(this.x, this.y, pom += 1L << i));
        }
        return ret.toArray(new Position[ret.size()]);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DotsAndBoxesPosition)) {
            return false;
        }
        DotsAndBoxesPosition pos = (DotsAndBoxesPosition)o;
        return pos.x == this.x && pos.y == this.y && pos.val == this.val;
    }

    public int hashCode() {
        int ret = this.x * 37 ^ this.y * 17 ^ (int)(this.val % 123472539L);
        return ret;
    }

    public String toString() {
        return "x=" + this.x + " y=" + this.y + " val=" + this.val;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

