/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.dots;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import sk.lenhardt.dots.DotsAndBoxesPosition;
import sk.lenhardt.dots.Pair;
import sk.lenhardt.game.Position;
import sk.lenhardt.sum.WTIAPosition;

public class DotsAndBoxesSmallPosition
extends DotsAndBoxesPosition {
    private long disabled = 0L;

    public DotsAndBoxesSmallPosition(int x, int y, long dis) {
        super(x, y);
        this.disabled = dis;
    }

    public DotsAndBoxesSmallPosition(int x, int y, long val, long dis) {
        super(x, y, val);
        this.disabled = dis;
    }

    private int getDisabledNumber(int tx, int ty) {
        return this.y * tx + ty;
    }

    private boolean getDisabledXY(int tx, int ty) {
        return (this.disabled & 1L << this.getDisabledNumber(tx, ty)) != 0L;
    }

    private void setDisabled(int tx, int ty) {
        if (!this.getDisabledXY(tx, ty)) {
            this.disabled += 1L << this.getDisabledNumber(tx, ty);
        }
    }

    public boolean getIndex(int index) {
        if (index >= 0 && index < this.range) {
            return (this.val & 1L << index) != 0L;
        }
        return false;
    }

    public boolean isFinal() {
        for (int i = 0; i < this.y - 1; ++i) {
            for (int j = 0; j < this.x - 1; ++j) {
                if (this.getDisabledXY(j, i)) continue;
                int up = (this.y - 1) * j + i + 1;
                int down = (this.y - 1) * (j + 1) + i + 1;
                int left = this.x * (this.y - 1) + 1 + i + j * this.y;
                int right = this.x * (this.y - 1) + 2 + i + j * this.y;
                if (!this.getIndex(up - 1) || !this.getIndex(down - 1) || !this.getIndex(right - 1) || !this.getIndex(left - 1)) continue;
                return true;
            }
        }
        return false;
    }

    public Position[] getAllPossibleMoves() {
        if (this.isFinal()) {
            return new Position[0];
        }
        LinkedList<Position> ret = new LinkedList<Position>();
        HashMap used = new HashMap();
        for (int i = 0; i < this.y - 1; ++i) {
            for (int j = 0; j < this.x - 1; ++j) {
                if (this.getDisabledXY(j, i)) continue;
                boolean pocet = false;
                int up = (this.y - 1) * j + i + 1;
                int down = (this.y - 1) * (j + 1) + i + 1;
                int left = this.x * (this.y - 1) + 1 + i + j * this.y;
                int right = this.x * (this.y - 1) + 2 + i + j * this.y;
                int[] poss = new int[]{up, down, left, right};
                for (int k = 0; k < poss.length; ++k) {
                    if (used.containsKey(poss[k]) || this.getIndex(poss[k] - 1)) continue;
                    used.put(poss[k], null);
                    int[][] plan = new int[this.y - 1][this.x - 1];
                    for (int ii = 0; ii < this.y - 1; ++ii) {
                        for (int jj = 0; jj < this.x - 1; ++jj) {
                            plan[ii][jj] = -1;
                        }
                    }
                    int actual = -1;
                    for (int ii = 0; ii < this.y - 1; ++ii) {
                        for (int jj = 0; jj < this.x - 1; ++jj) {
                            if (plan[ii][jj] != -1 || this.getDisabledXY(jj, ii)) continue;
                            ArrayList<Pair> queue = new ArrayList<Pair>();
                            Pair pair = new Pair(ii, jj);
                            queue.add(pair);
                            plan[ii][jj] = ++actual;
                            for (int index = 0; index < queue.size(); ++index) {
                                Pair tmp = (Pair)queue.get(index);
                                int iii = tmp.getX();
                                int jjj = tmp.getY();
                                int[] poss2 = new int[]{(this.y - 1) * jjj + iii + 1, (this.y - 1) * (jjj + 1) + iii + 1, this.x * (this.y - 1) + 1 + iii + jjj * this.y, this.x * (this.y - 1) + 2 + iii + jjj * this.y};
                                int[] movex = new int[]{0, 0, -1, 1};
                                int[] movey = new int[]{-1, 1, 0, 0};
                                for (int kk = 0; kk < movex.length; ++kk) {
                                    int tmpx = tmp.getX() + movex[kk];
                                    int tmpy = tmp.getY() + movey[kk];
                                    if (tmpx < 0 || tmpx >= this.y - 1 || tmpy < 0 || tmpy >= this.x - 1 || plan[tmpx][tmpy] != -1 || this.getDisabledXY(tmpy, tmpx) || this.getIndex(poss2[kk] - 1) || poss2[kk] == poss[k]) continue;
                                    queue.add(new Pair(tmpx, tmpy));
                                    plan[tmpx][tmpy] = actual;
                                }
                            }
                        }
                    }
                    if (actual == 0) {
                        long pom = this.val;
                        ret.add(new DotsAndBoxesSmallPosition(this.x, this.y, pom += 1L << poss[k] - 1, this.disabled));
                        continue;
                    }
                    if (actual > 0) {
                        DotsAndBoxesSmallPosition[] pos = new DotsAndBoxesSmallPosition[actual + 1];
                        for (int u = 0; u < actual + 1; ++u) {
                            long d = 0L;
                            int mini = 999;
                            int minj = 999;
                            int maxi = -1;
                            int maxj = -1;
                            for (int ii = 0; ii < this.y - 1; ++ii) {
                                for (int jj = 0; jj < this.x - 1; ++jj) {
                                    if (plan[ii][jj] != u) {
                                        d += 1L << this.getDisabledNumber(jj, ii);
                                        continue;
                                    }
                                    if (ii < mini) {
                                        mini = ii;
                                    }
                                    if (ii > maxi) {
                                        maxi = ii;
                                    }
                                    if (jj < minj) {
                                        minj = jj;
                                    }
                                    if (jj <= maxj) continue;
                                    maxj = jj;
                                }
                            }
                            long pom = this.val + (1L << poss[k] - 1);
                            int ny = maxi - mini + 2;
                            int nx = maxj - minj + 2;
                            long nd = 0L;
                            for (int ii = mini; ii <= maxi; ++ii) {
                                for (int jj = minj; jj <= maxj; ++jj) {
                                    if (plan[ii][jj] == u) continue;
                                    nd += 1L << ny * (jj - minj) + (ii - mini);
                                }
                            }
                            long nval = 0L;
                            for (int ii = mini; ii <= maxi; ++ii) {
                                for (int jj = minj; jj <= maxj; ++jj) {
                                    if (plan[ii][jj] != u) continue;
                                    int nup = (this.y - 1) * jj + ii + 1;
                                    int ndown = (this.y - 1) * (jj + 1) + ii + 1;
                                    int nleft = this.x * (this.y - 1) + 1 + ii + jj * this.y;
                                    int nright = this.x * (this.y - 1) + 2 + ii + jj * this.y;
                                    int[] nposs = new int[]{nup, ndown, nleft, nright};
                                    int nup2 = (ny - 1) * (jj - minj) + (ii - mini) + 1;
                                    int ndown2 = (ny - 1) * (jj - minj + 1) + (ii - mini) + 1;
                                    int nleft2 = nx * (ny - 1) + 1 + (ii - mini) + (jj - minj) * ny;
                                    int nright2 = nx * (ny - 1) + 2 + (ii - mini) + (jj - minj) * ny;
                                    int[] nposs2 = new int[]{nup2, ndown2, nleft2, nright2};
                                    HashMap nused = new HashMap();
                                    for (int kk = 0; kk < nposs.length; ++kk) {
                                        if ((pom & 1L << nposs[kk] - 1) == 0L || nused.containsKey(nposs[kk])) continue;
                                        nused.put(nposs[kk], null);
                                        nval += 1L << nposs2[kk] - 1;
                                    }
                                }
                            }
                            pos[u] = new DotsAndBoxesSmallPosition(this.x, this.y, pom, d);
                        }
                        WTIAPosition w = new WTIAPosition(pos[0], pos[1]);
                        for (int q = 2; q < pos.length; ++q) {
                            w = new WTIAPosition(w, pos[q]);
                        }
                        ret.add(w);
                        continue;
                    }
                    System.out.println("error occured in decomposition of DotsAndBoxesSmallPosition");
                }
            }
        }
        return ret.toArray(new Position[ret.size()]);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DotsAndBoxesSmallPosition)) {
            return false;
        }
        DotsAndBoxesSmallPosition pos = (DotsAndBoxesSmallPosition)o;
        return pos.x == this.x && pos.y == this.y && pos.val == this.val && pos.disabled == this.disabled;
    }

    public int hashCode() {
        return super.hashCode() ^ (int)this.disabled;
    }
}

