/*
 * Decompiled with CFR 0.152.
 */
package sk.lenhardt.sum;

import java.util.LinkedList;
import sk.lenhardt.game.Position;

public class WTIAPosition
extends Position {
    public Position a;
    public Position b;

    public WTIAPosition(Position a, Position b) {
        this.a = a;
        this.b = b;
    }

    public Position[] getAllPossibleMoves() {
        int i;
        if (this.isFinal()) {
            return new Position[0];
        }
        Position[] aMoves = this.a.getAllPossibleMoves();
        Position[] bMoves = this.b.getAllPossibleMoves();
        LinkedList<WTIAPosition> ret = new LinkedList<WTIAPosition>();
        for (i = 0; i < aMoves.length; ++i) {
            ret.add(new WTIAPosition(aMoves[i], this.b));
        }
        for (i = 0; i < bMoves.length; ++i) {
            ret.add(new WTIAPosition(this.a, bMoves[i]));
        }
        return ret.toArray(new Position[ret.size()]);
    }

    public int getWTIANumber() {
        int wA = this.a.getWTIANumber();
        int wB = this.b.getWTIANumber();
        if (wA == -2 || wB == -2) {
            return -2;
        }
        if (wA == -1 || wB == -1) {
            return -1;
        }
        return wA ^ wB;
    }

    public boolean isLosing() {
        int val = this.getWTIANumber();
        return val == -2 || val == 0;
    }

    public boolean isFinal() {
        return this.a.isFinal() || this.b.isFinal();
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof WTIAPosition)) {
            return false;
        }
        WTIAPosition pos = (WTIAPosition)o;
        return this.a.equals(pos.a) && this.b.equals(pos.b) || this.a.equals(pos.b) && this.b.equals(pos.a);
    }
}

