/*
 * RemoenessAlgorithm.java
 *
 * Created on Sobota, 2007, marec 3, 10:58
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.game;


import java.util.HashMap;
/**
 *
 * @author rasto
 */
public class RemotenessAlgorithm {
    
    private static HashMap cache = new HashMap();
    
    public static int getRemoteness(Position pos) {
        if (cache.containsKey(pos)) {
            return ((Integer)cache.get(pos)).intValue();
        }
                
        Position[] moves = pos.getAllPossibleMoves();
                
        // -1 means that it is not defined yet
        int greatestOdd=-1;
        int leastEven=-1;
        
        for (int i=0;i<moves.length;i++) {
            int val = moves[i].getRemoteness();
            if (val%2==0) {
                if (leastEven==-1||val<leastEven) leastEven = val;
            } else {
                if (greatestOdd==-1||val>greatestOdd) greatestOdd = val;
            }
        }
        
        int ret=0;
        if (leastEven!=-1) {
            ret = leastEven + 1;
        } else if (greatestOdd!=-1) {
            ret = greatestOdd + 1;
        }
        
        cache.put(pos, Integer.valueOf(ret));
        return ret;        
    }
}
