/*
 * WTIAPosition.java
 *
 * Created on Utorok, 2006, november 7, 19:33
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package sk.lenhardt.sum;

import sk.lenhardt.game.Position;
import java.util.LinkedList;
import sk.lenhardt.game.WTIAAlgorithm;
/**
 *
 * @author rasto
 */
public class WTIAPosition extends Position  {
    
    
    public Position a, b;
    
    /** Creates a new instance of WTIAPosition */
    public WTIAPosition(Position a,Position b) {
        this.a = a;
        this.b = b;
    }
    
    public Position[] getAllPossibleMoves() {
        if (isFinal()) return new Position[0];
        Position[] aMoves = a.getAllPossibleMoves();
        Position[] bMoves = b.getAllPossibleMoves();
        LinkedList ret= new LinkedList();                
        for (int i=0;i<aMoves.length;i++) {
            ret.add(new WTIAPosition(aMoves[i],b));            
        }
        for (int i=0;i<bMoves.length;i++) {
            ret.add(new WTIAPosition(a,bMoves[i]));            
        }        
        return (Position[])ret.toArray(new Position[ret.size()]);                
    }
    
    public int getWTIANumber() {
        int wA = a.getWTIANumber();
        int wB = b.getWTIANumber();
        if (wA==WTIAAlgorithm.SUPER_LOOSING || wB == WTIAAlgorithm.SUPER_LOOSING) {            
            return WTIAAlgorithm.SUPER_LOOSING;            
        } else if (wA==WTIAAlgorithm.SUPER_WINNING || wB == WTIAAlgorithm.SUPER_WINNING){
            return WTIAAlgorithm.SUPER_WINNING;
        } else {
            return wA ^ wB;
        }                
    }
    
    public boolean isLosing() {
        int val=getWTIANumber();
        return (val==WTIAAlgorithm.SUPER_LOOSING||val==0);
    }
    
    public boolean isFinal() {
        return a.isFinal()||b.isFinal();
    }
    
    public int hashCode() {
        return a.hashCode()^b.hashCode();
    }
    
    public boolean equals(Object o) {
        if (! (o instanceof WTIAPosition)) return false;
        WTIAPosition pos = (WTIAPosition)o;
        return (this.a.equals(pos.a)&&this.b.equals(pos.b))||(this.a.equals(pos.b)&&this.b.equals(pos.a));
    }
    
}
